package software.amazon.awscdk.services.events.targets;

/**
 * The input to send to the CloudWatch LogGroup target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * LogGroup logGroup;
 * Rule rule;
 * rule.addTarget(CloudWatchLogGroup.Builder.create(logGroup)
 *         .logEvent(LogGroupTargetInput.fromObject(LogGroupTargetInputOptions.builder()
 *                 .timestamp(EventField.fromPath("$.time"))
 *                 .message(EventField.fromPath("$.detail-type"))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:54.840Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.LogGroupTargetInput")
public abstract class LogGroupTargetInput extends software.amazon.jsii.JsiiObject {

    protected LogGroupTargetInput(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LogGroupTargetInput(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected LogGroupTargetInput() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Pass a JSON object to the the log group event target.
     * <p>
     * May contain strings returned by <code>EventField.from()</code> to substitute in parts of the
     * matched event.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetInput fromObject(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.LogGroupTargetInputOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.targets.LogGroupTargetInput.class, "fromObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class), new Object[] { options });
    }

    /**
     * Pass a JSON object to the the log group event target.
     * <p>
     * May contain strings returned by <code>EventField.from()</code> to substitute in parts of the
     * matched event.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetInput fromObject() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.targets.LogGroupTargetInput.class, "fromObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class));
    }

    /**
     * Return the input properties for this input object.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetInputProperties bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.events.targets.LogGroupTargetInput {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Return the input properties for this input object.
         * <p>
         * @param rule This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetInputProperties bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule rule) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInputProperties.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
        }
    }
}
