package software.amazon.awscdk.services.globalaccelerator.endpoints;

/**
 * Use a Network Load Balancer as a Global Accelerator Endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create an Accelerator
 * Accelerator accelerator = new Accelerator(this, "Accelerator");
 * // Create a Listener
 * Listener listener = accelerator.addListener("Listener", ListenerOptions.builder()
 *         .portRanges(List.of(PortRange.builder().fromPort(80).build(), PortRange.builder().fromPort(443).build()))
 *         .build());
 * // Import the Load Balancers
 * INetworkLoadBalancer nlb1 = NetworkLoadBalancer.fromNetworkLoadBalancerAttributes(this, "NLB1", NetworkLoadBalancerAttributes.builder()
 *         .loadBalancerArn("arn:aws:elasticloadbalancing:us-west-2:111111111111:loadbalancer/app/my-load-balancer1/e16bef66805b")
 *         .build());
 * INetworkLoadBalancer nlb2 = NetworkLoadBalancer.fromNetworkLoadBalancerAttributes(this, "NLB2", NetworkLoadBalancerAttributes.builder()
 *         .loadBalancerArn("arn:aws:elasticloadbalancing:ap-south-1:111111111111:loadbalancer/app/my-load-balancer2/5513dc2ea8a1")
 *         .build());
 * // Add one EndpointGroup for each Region we are targeting
 * listener.addEndpointGroup("Group1", EndpointGroupOptions.builder()
 *         .endpoints(List.of(new NetworkLoadBalancerEndpoint(nlb1)))
 *         .build());
 * listener.addEndpointGroup("Group2", EndpointGroupOptions.builder()
 *         // Imported load balancers automatically calculate their Region from the ARN.
 *         // If you are load balancing to other resources, you must also pass a `region`
 *         // parameter here.
 *         .endpoints(List.of(new NetworkLoadBalancerEndpoint(nlb2)))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:55.159Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator_endpoints.NetworkLoadBalancerEndpoint")
public class NetworkLoadBalancerEndpoint extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.globalaccelerator.IEndpoint {

    protected NetworkLoadBalancerEndpoint(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkLoadBalancerEndpoint(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param loadBalancer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkLoadBalancerEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.globalaccelerator.endpoints.NetworkLoadBalancerEndpointProps options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required"), options });
    }

    /**
     * @param loadBalancer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NetworkLoadBalancerEndpoint(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * Render the endpoint to an endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object renderEndpointConfiguration() {
        return software.amazon.jsii.Kernel.call(this, "renderEndpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The region where the endpoint is located.
     * <p>
     * If the region cannot be determined, <code>undefined</code> is returned
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.globalaccelerator.endpoints.NetworkLoadBalancerEndpoint}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.globalaccelerator.endpoints.NetworkLoadBalancerEndpoint> {
        /**
         * @return a new instance of {@link Builder}.
         * @param loadBalancer This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer) {
            return new Builder(loadBalancer);
        }

        private final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer;
        private software.amazon.awscdk.services.globalaccelerator.endpoints.NetworkLoadBalancerEndpointProps.Builder options;

        private Builder(final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
        }

        /**
         * Forward the client IP address in an <code>X-Forwarded-For</code> header.
         * <p>
         * GlobalAccelerator will create Network Interfaces in your VPC in order
         * to preserve the client IP address.
         * <p>
         * Client IP address preservation is supported only in specific AWS Regions.
         * See the GlobalAccelerator Developer Guide for a list.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param preserveClientIp Forward the client IP address in an <code>X-Forwarded-For</code> header. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveClientIp(final java.lang.Boolean preserveClientIp) {
            this.options().preserveClientIp(preserveClientIp);
            return this;
        }

        /**
         * Endpoint weight across all endpoints in the group.
         * <p>
         * Must be a value between 0 and 255.
         * <p>
         * Default: 128
         * <p>
         * @return {@code this}
         * @param weight Endpoint weight across all endpoints in the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weight(final java.lang.Number weight) {
            this.options().weight(weight);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.globalaccelerator.endpoints.NetworkLoadBalancerEndpoint}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.globalaccelerator.endpoints.NetworkLoadBalancerEndpoint build() {
            return new software.amazon.awscdk.services.globalaccelerator.endpoints.NetworkLoadBalancerEndpoint(
                this.loadBalancer,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.globalaccelerator.endpoints.NetworkLoadBalancerEndpointProps.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.globalaccelerator.endpoints.NetworkLoadBalancerEndpointProps.Builder();
            }
            return this.options;
        }
    }
}
