package software.amazon.awscdk.services.greengrass;

/**
 * Properties for defining a <code>CfnDeviceDefinitionVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * CfnDeviceDefinitionVersionProps cfnDeviceDefinitionVersionProps = CfnDeviceDefinitionVersionProps.builder()
 *         .deviceDefinitionId("deviceDefinitionId")
 *         .devices(List.of(DeviceProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .id("id")
 *                 .thingArn("thingArn")
 *                 // the properties below are optional
 *                 .syncShadow(false)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:55.311Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnDeviceDefinitionVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnDeviceDefinitionVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDeviceDefinitionVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the device definition associated with this version.
     * <p>
     * This value is a GUID.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devicedefinitionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devicedefinitionid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeviceDefinitionId();

    /**
     * The devices in this version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devices</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDevices();

    /**
     * @return a {@link Builder} of {@link CfnDeviceDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDeviceDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDeviceDefinitionVersionProps> {
        java.lang.String deviceDefinitionId;
        java.lang.Object devices;

        /**
         * Sets the value of {@link CfnDeviceDefinitionVersionProps#getDeviceDefinitionId}
         * @param deviceDefinitionId The ID of the device definition associated with this version. This parameter is required.
         *                           This value is a GUID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceDefinitionId(java.lang.String deviceDefinitionId) {
            this.deviceDefinitionId = deviceDefinitionId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceDefinitionVersionProps#getDevices}
         * @param devices The devices in this version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder devices(software.amazon.awscdk.IResolvable devices) {
            this.devices = devices;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeviceDefinitionVersionProps#getDevices}
         * @param devices The devices in this version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder devices(java.util.List<? extends java.lang.Object> devices) {
            this.devices = devices;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDeviceDefinitionVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDeviceDefinitionVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDeviceDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDeviceDefinitionVersionProps {
        private final java.lang.String deviceDefinitionId;
        private final java.lang.Object devices;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deviceDefinitionId = software.amazon.jsii.Kernel.get(this, "deviceDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.devices = software.amazon.jsii.Kernel.get(this, "devices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deviceDefinitionId = java.util.Objects.requireNonNull(builder.deviceDefinitionId, "deviceDefinitionId is required");
            this.devices = java.util.Objects.requireNonNull(builder.devices, "devices is required");
        }

        @Override
        public final java.lang.String getDeviceDefinitionId() {
            return this.deviceDefinitionId;
        }

        @Override
        public final java.lang.Object getDevices() {
            return this.devices;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deviceDefinitionId", om.valueToTree(this.getDeviceDefinitionId()));
            data.set("devices", om.valueToTree(this.getDevices()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnDeviceDefinitionVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDeviceDefinitionVersionProps.Jsii$Proxy that = (CfnDeviceDefinitionVersionProps.Jsii$Proxy) o;

            if (!deviceDefinitionId.equals(that.deviceDefinitionId)) return false;
            return this.devices.equals(that.devices);
        }

        @Override
        public final int hashCode() {
            int result = this.deviceDefinitionId.hashCode();
            result = 31 * result + (this.devices.hashCode());
            return result;
        }
    }
}
