package software.amazon.awscdk.services.greengrass;

/**
 * The <code>AWS::Greengrass::GroupVersion</code> resource represents a group version in AWS IoT Greengrass .
 * <p>
 * A group version references a core definition version, device definition version, subscription definition version, and other version types that contain the components you want to deploy to a Greengrass core device. The group version must reference a core definition version that contains one core. Other version types are optionally included, depending on your business need.
 * <p>
 * <blockquote>
 * <p>
 * To create a group version, you must specify the ID of the group that you want to associate with the version. For information about creating a group, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * CfnGroupVersion cfnGroupVersion = CfnGroupVersion.Builder.create(this, "MyCfnGroupVersion")
 *         .groupId("groupId")
 *         // the properties below are optional
 *         .connectorDefinitionVersionArn("connectorDefinitionVersionArn")
 *         .coreDefinitionVersionArn("coreDefinitionVersionArn")
 *         .deviceDefinitionVersionArn("deviceDefinitionVersionArn")
 *         .functionDefinitionVersionArn("functionDefinitionVersionArn")
 *         .loggerDefinitionVersionArn("loggerDefinitionVersionArn")
 *         .resourceDefinitionVersionArn("resourceDefinitionVersionArn")
 *         .subscriptionDefinitionVersionArn("subscriptionDefinitionVersionArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:55.342Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnGroupVersion")
public class CfnGroupVersion extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnGroupVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGroupVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.greengrass.CfnGroupVersion.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGroupVersion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.greengrass.CfnGroupVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the group associated with this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGroupId() {
        return software.amazon.jsii.Kernel.get(this, "groupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the group associated with this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "groupId", java.util.Objects.requireNonNull(value, "groupId is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the connector definition version that contains the connectors you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectorDefinitionVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "connectorDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the connector definition version that contains the connectors you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorDefinitionVersionArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectorDefinitionVersionArn", value);
    }

    /**
     * The ARN of the core definition version that contains the core you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCoreDefinitionVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "coreDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the core definition version that contains the core you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCoreDefinitionVersionArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "coreDefinitionVersionArn", value);
    }

    /**
     * The ARN of the device definition version that contains the devices you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeviceDefinitionVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "deviceDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the device definition version that contains the devices you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeviceDefinitionVersionArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deviceDefinitionVersionArn", value);
    }

    /**
     * The ARN of the function definition version that contains the functions you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFunctionDefinitionVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "functionDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the function definition version that contains the functions you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctionDefinitionVersionArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "functionDefinitionVersionArn", value);
    }

    /**
     * The ARN of the logger definition version that contains the loggers you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLoggerDefinitionVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "loggerDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the logger definition version that contains the loggers you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggerDefinitionVersionArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "loggerDefinitionVersionArn", value);
    }

    /**
     * The ARN of the resource definition version that contains the resources you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceDefinitionVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "resourceDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the resource definition version that contains the resources you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceDefinitionVersionArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceDefinitionVersionArn", value);
    }

    /**
     * The ARN of the subscription definition version that contains the subscriptions you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSubscriptionDefinitionVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "subscriptionDefinitionVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the subscription definition version that contains the subscriptions you want to deploy with the group version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubscriptionDefinitionVersionArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "subscriptionDefinitionVersionArn", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.greengrass.CfnGroupVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.greengrass.CfnGroupVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.greengrass.CfnGroupVersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.greengrass.CfnGroupVersionProps.Builder();
        }

        /**
         * The ID of the group associated with this version.
         * <p>
         * This value is a GUID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-groupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-groupid</a>
         * @param groupId The ID of the group associated with this version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupId(final java.lang.String groupId) {
            this.props.groupId(groupId);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the connector definition version that contains the connectors you want to deploy with the group version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-connectordefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-connectordefinitionversionarn</a>
         * @param connectorDefinitionVersionArn The Amazon Resource Name (ARN) of the connector definition version that contains the connectors you want to deploy with the group version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorDefinitionVersionArn(final java.lang.String connectorDefinitionVersionArn) {
            this.props.connectorDefinitionVersionArn(connectorDefinitionVersionArn);
            return this;
        }

        /**
         * The ARN of the core definition version that contains the core you want to deploy with the group version.
         * <p>
         * Currently, the core definition version can contain only one core.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-coredefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-coredefinitionversionarn</a>
         * @param coreDefinitionVersionArn The ARN of the core definition version that contains the core you want to deploy with the group version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreDefinitionVersionArn(final java.lang.String coreDefinitionVersionArn) {
            this.props.coreDefinitionVersionArn(coreDefinitionVersionArn);
            return this;
        }

        /**
         * The ARN of the device definition version that contains the devices you want to deploy with the group version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-devicedefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-devicedefinitionversionarn</a>
         * @param deviceDefinitionVersionArn The ARN of the device definition version that contains the devices you want to deploy with the group version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceDefinitionVersionArn(final java.lang.String deviceDefinitionVersionArn) {
            this.props.deviceDefinitionVersionArn(deviceDefinitionVersionArn);
            return this;
        }

        /**
         * The ARN of the function definition version that contains the functions you want to deploy with the group version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-functiondefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-functiondefinitionversionarn</a>
         * @param functionDefinitionVersionArn The ARN of the function definition version that contains the functions you want to deploy with the group version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionDefinitionVersionArn(final java.lang.String functionDefinitionVersionArn) {
            this.props.functionDefinitionVersionArn(functionDefinitionVersionArn);
            return this;
        }

        /**
         * The ARN of the logger definition version that contains the loggers you want to deploy with the group version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-loggerdefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-loggerdefinitionversionarn</a>
         * @param loggerDefinitionVersionArn The ARN of the logger definition version that contains the loggers you want to deploy with the group version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggerDefinitionVersionArn(final java.lang.String loggerDefinitionVersionArn) {
            this.props.loggerDefinitionVersionArn(loggerDefinitionVersionArn);
            return this;
        }

        /**
         * The ARN of the resource definition version that contains the resources you want to deploy with the group version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-resourcedefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-resourcedefinitionversionarn</a>
         * @param resourceDefinitionVersionArn The ARN of the resource definition version that contains the resources you want to deploy with the group version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceDefinitionVersionArn(final java.lang.String resourceDefinitionVersionArn) {
            this.props.resourceDefinitionVersionArn(resourceDefinitionVersionArn);
            return this;
        }

        /**
         * The ARN of the subscription definition version that contains the subscriptions you want to deploy with the group version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-subscriptiondefinitionversionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-subscriptiondefinitionversionarn</a>
         * @param subscriptionDefinitionVersionArn The ARN of the subscription definition version that contains the subscriptions you want to deploy with the group version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionDefinitionVersionArn(final java.lang.String subscriptionDefinitionVersionArn) {
            this.props.subscriptionDefinitionVersionArn(subscriptionDefinitionVersionArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.greengrass.CfnGroupVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.greengrass.CfnGroupVersion build() {
            return new software.amazon.awscdk.services.greengrass.CfnGroupVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
