package software.amazon.awscdk.services.guardduty;

/**
 * Properties for defining a <code>CfnPublishingDestination</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.guardduty.*;
 * CfnPublishingDestinationProps cfnPublishingDestinationProps = CfnPublishingDestinationProps.builder()
 *         .destinationProperties(CFNDestinationPropertiesProperty.builder()
 *                 .destinationArn("destinationArn")
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .destinationType("destinationType")
 *         .detectorId("detectorId")
 *         // the properties below are optional
 *         .tags(List.of(TagItemProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-publishingdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-publishingdestination.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:55.460Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_guardduty.CfnPublishingDestinationProps")
@software.amazon.jsii.Jsii.Proxy(CfnPublishingDestinationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPublishingDestinationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-publishingdestination.html#cfn-guardduty-publishingdestination-destinationproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-publishingdestination.html#cfn-guardduty-publishingdestination-destinationproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDestinationProperties();

    /**
     * The type of resource for the publishing destination.
     * <p>
     * Currently only Amazon S3 buckets are supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-publishingdestination.html#cfn-guardduty-publishingdestination-destinationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-publishingdestination.html#cfn-guardduty-publishingdestination-destinationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDestinationType();

    /**
     * The ID of the GuardDuty detector associated with the publishing destination.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-publishingdestination.html#cfn-guardduty-publishingdestination-detectorid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-publishingdestination.html#cfn-guardduty-publishingdestination-detectorid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDetectorId();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-publishingdestination.html#cfn-guardduty-publishingdestination-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-guardduty-publishingdestination.html#cfn-guardduty-publishingdestination-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.guardduty.CfnPublishingDestination.TagItemProperty> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPublishingDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPublishingDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPublishingDestinationProps> {
        java.lang.Object destinationProperties;
        java.lang.String destinationType;
        java.lang.String detectorId;
        java.util.List<software.amazon.awscdk.services.guardduty.CfnPublishingDestination.TagItemProperty> tags;

        /**
         * Sets the value of {@link CfnPublishingDestinationProps#getDestinationProperties}
         * @param destinationProperties the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationProperties(software.amazon.awscdk.IResolvable destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublishingDestinationProps#getDestinationProperties}
         * @param destinationProperties the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationProperties(software.amazon.awscdk.services.guardduty.CfnPublishingDestination.CFNDestinationPropertiesProperty destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublishingDestinationProps#getDestinationType}
         * @param destinationType The type of resource for the publishing destination. This parameter is required.
         *                        Currently only Amazon S3 buckets are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationType(java.lang.String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublishingDestinationProps#getDetectorId}
         * @param detectorId The ID of the GuardDuty detector associated with the publishing destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorId(java.lang.String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublishingDestinationProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.guardduty.CfnPublishingDestination.TagItemProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.guardduty.CfnPublishingDestination.TagItemProperty>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPublishingDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPublishingDestinationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPublishingDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPublishingDestinationProps {
        private final java.lang.Object destinationProperties;
        private final java.lang.String destinationType;
        private final java.lang.String detectorId;
        private final java.util.List<software.amazon.awscdk.services.guardduty.CfnPublishingDestination.TagItemProperty> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationProperties = software.amazon.jsii.Kernel.get(this, "destinationProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.destinationType = software.amazon.jsii.Kernel.get(this, "destinationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detectorId = software.amazon.jsii.Kernel.get(this, "detectorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.guardduty.CfnPublishingDestination.TagItemProperty.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationProperties = java.util.Objects.requireNonNull(builder.destinationProperties, "destinationProperties is required");
            this.destinationType = java.util.Objects.requireNonNull(builder.destinationType, "destinationType is required");
            this.detectorId = java.util.Objects.requireNonNull(builder.detectorId, "detectorId is required");
            this.tags = (java.util.List<software.amazon.awscdk.services.guardduty.CfnPublishingDestination.TagItemProperty>)builder.tags;
        }

        @Override
        public final java.lang.Object getDestinationProperties() {
            return this.destinationProperties;
        }

        @Override
        public final java.lang.String getDestinationType() {
            return this.destinationType;
        }

        @Override
        public final java.lang.String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.guardduty.CfnPublishingDestination.TagItemProperty> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationProperties", om.valueToTree(this.getDestinationProperties()));
            data.set("destinationType", om.valueToTree(this.getDestinationType()));
            data.set("detectorId", om.valueToTree(this.getDetectorId()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_guardduty.CfnPublishingDestinationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPublishingDestinationProps.Jsii$Proxy that = (CfnPublishingDestinationProps.Jsii$Proxy) o;

            if (!destinationProperties.equals(that.destinationProperties)) return false;
            if (!destinationType.equals(that.destinationType)) return false;
            if (!detectorId.equals(that.detectorId)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationProperties.hashCode();
            result = 31 * result + (this.destinationType.hashCode());
            result = 31 * result + (this.detectorId.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
