package software.amazon.awscdk.services.healthlake;

/**
 * Properties for defining a <code>CfnFHIRDatastore</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.healthlake.*;
 * CfnFHIRDatastoreProps cfnFHIRDatastoreProps = CfnFHIRDatastoreProps.builder()
 *         .datastoreTypeVersion("datastoreTypeVersion")
 *         // the properties below are optional
 *         .datastoreName("datastoreName")
 *         .identityProviderConfiguration(IdentityProviderConfigurationProperty.builder()
 *                 .authorizationStrategy("authorizationStrategy")
 *                 // the properties below are optional
 *                 .fineGrainedAuthorizationEnabled(false)
 *                 .idpLambdaArn("idpLambdaArn")
 *                 .metadata("metadata")
 *                 .build())
 *         .preloadDataConfig(PreloadDataConfigProperty.builder()
 *                 .preloadDataType("preloadDataType")
 *                 .build())
 *         .sseConfiguration(SseConfigurationProperty.builder()
 *                 .kmsEncryptionConfig(KmsEncryptionConfigProperty.builder()
 *                         .cmkType("cmkType")
 *                         // the properties below are optional
 *                         .kmsKeyId("kmsKeyId")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:55.480Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_healthlake.CfnFHIRDatastoreProps")
@software.amazon.jsii.Jsii.Proxy(CfnFHIRDatastoreProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFHIRDatastoreProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The FHIR release version supported by the data store.
     * <p>
     * Current support is for version <code>R4</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastoretypeversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastoretypeversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatastoreTypeVersion();

    /**
     * The data store name (user-generated).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastorename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-datastorename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatastoreName() {
        return null;
    }

    /**
     * The identity provider configuration selected when the data store was created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-identityproviderconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIdentityProviderConfiguration() {
        return null;
    }

    /**
     * The preloaded Synthea data configuration for the data store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-preloaddataconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-preloaddataconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPreloadDataConfig() {
        return null;
    }

    /**
     * The server-side encryption key configuration for a customer-provided encryption key specified for creating a data store.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-sseconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-sseconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSseConfiguration() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-healthlake-fhirdatastore.html#cfn-healthlake-fhirdatastore-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFHIRDatastoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFHIRDatastoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFHIRDatastoreProps> {
        java.lang.String datastoreTypeVersion;
        java.lang.String datastoreName;
        java.lang.Object identityProviderConfiguration;
        java.lang.Object preloadDataConfig;
        java.lang.Object sseConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFHIRDatastoreProps#getDatastoreTypeVersion}
         * @param datastoreTypeVersion The FHIR release version supported by the data store. This parameter is required.
         *                             Current support is for version <code>R4</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreTypeVersion(java.lang.String datastoreTypeVersion) {
            this.datastoreTypeVersion = datastoreTypeVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnFHIRDatastoreProps#getDatastoreName}
         * @param datastoreName The data store name (user-generated).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datastoreName(java.lang.String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFHIRDatastoreProps#getIdentityProviderConfiguration}
         * @param identityProviderConfiguration The identity provider configuration selected when the data store was created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderConfiguration(software.amazon.awscdk.IResolvable identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFHIRDatastoreProps#getIdentityProviderConfiguration}
         * @param identityProviderConfiguration The identity provider configuration selected when the data store was created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityProviderConfiguration(software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.IdentityProviderConfigurationProperty identityProviderConfiguration) {
            this.identityProviderConfiguration = identityProviderConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFHIRDatastoreProps#getPreloadDataConfig}
         * @param preloadDataConfig The preloaded Synthea data configuration for the data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preloadDataConfig(software.amazon.awscdk.IResolvable preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFHIRDatastoreProps#getPreloadDataConfig}
         * @param preloadDataConfig The preloaded Synthea data configuration for the data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preloadDataConfig(software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.PreloadDataConfigProperty preloadDataConfig) {
            this.preloadDataConfig = preloadDataConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFHIRDatastoreProps#getSseConfiguration}
         * @param sseConfiguration The server-side encryption key configuration for a customer-provided encryption key specified for creating a data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseConfiguration(software.amazon.awscdk.IResolvable sseConfiguration) {
            this.sseConfiguration = sseConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFHIRDatastoreProps#getSseConfiguration}
         * @param sseConfiguration The server-side encryption key configuration for a customer-provided encryption key specified for creating a data store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseConfiguration(software.amazon.awscdk.services.healthlake.CfnFHIRDatastore.SseConfigurationProperty sseConfiguration) {
            this.sseConfiguration = sseConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFHIRDatastoreProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFHIRDatastoreProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFHIRDatastoreProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFHIRDatastoreProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFHIRDatastoreProps {
        private final java.lang.String datastoreTypeVersion;
        private final java.lang.String datastoreName;
        private final java.lang.Object identityProviderConfiguration;
        private final java.lang.Object preloadDataConfig;
        private final java.lang.Object sseConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.datastoreTypeVersion = software.amazon.jsii.Kernel.get(this, "datastoreTypeVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.datastoreName = software.amazon.jsii.Kernel.get(this, "datastoreName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityProviderConfiguration = software.amazon.jsii.Kernel.get(this, "identityProviderConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.preloadDataConfig = software.amazon.jsii.Kernel.get(this, "preloadDataConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sseConfiguration = software.amazon.jsii.Kernel.get(this, "sseConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.datastoreTypeVersion = java.util.Objects.requireNonNull(builder.datastoreTypeVersion, "datastoreTypeVersion is required");
            this.datastoreName = builder.datastoreName;
            this.identityProviderConfiguration = builder.identityProviderConfiguration;
            this.preloadDataConfig = builder.preloadDataConfig;
            this.sseConfiguration = builder.sseConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDatastoreTypeVersion() {
            return this.datastoreTypeVersion;
        }

        @Override
        public final java.lang.String getDatastoreName() {
            return this.datastoreName;
        }

        @Override
        public final java.lang.Object getIdentityProviderConfiguration() {
            return this.identityProviderConfiguration;
        }

        @Override
        public final java.lang.Object getPreloadDataConfig() {
            return this.preloadDataConfig;
        }

        @Override
        public final java.lang.Object getSseConfiguration() {
            return this.sseConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("datastoreTypeVersion", om.valueToTree(this.getDatastoreTypeVersion()));
            if (this.getDatastoreName() != null) {
                data.set("datastoreName", om.valueToTree(this.getDatastoreName()));
            }
            if (this.getIdentityProviderConfiguration() != null) {
                data.set("identityProviderConfiguration", om.valueToTree(this.getIdentityProviderConfiguration()));
            }
            if (this.getPreloadDataConfig() != null) {
                data.set("preloadDataConfig", om.valueToTree(this.getPreloadDataConfig()));
            }
            if (this.getSseConfiguration() != null) {
                data.set("sseConfiguration", om.valueToTree(this.getSseConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_healthlake.CfnFHIRDatastoreProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFHIRDatastoreProps.Jsii$Proxy that = (CfnFHIRDatastoreProps.Jsii$Proxy) o;

            if (!datastoreTypeVersion.equals(that.datastoreTypeVersion)) return false;
            if (this.datastoreName != null ? !this.datastoreName.equals(that.datastoreName) : that.datastoreName != null) return false;
            if (this.identityProviderConfiguration != null ? !this.identityProviderConfiguration.equals(that.identityProviderConfiguration) : that.identityProviderConfiguration != null) return false;
            if (this.preloadDataConfig != null ? !this.preloadDataConfig.equals(that.preloadDataConfig) : that.preloadDataConfig != null) return false;
            if (this.sseConfiguration != null ? !this.sseConfiguration.equals(that.sseConfiguration) : that.sseConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.datastoreTypeVersion.hashCode();
            result = 31 * result + (this.datastoreName != null ? this.datastoreName.hashCode() : 0);
            result = 31 * result + (this.identityProviderConfiguration != null ? this.identityProviderConfiguration.hashCode() : 0);
            result = 31 * result + (this.preloadDataConfig != null ? this.preloadDataConfig.hashCode() : 0);
            result = 31 * result + (this.sseConfiguration != null ? this.sseConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
