package software.amazon.awscdk.services.imagebuilder;

/**
 * Create a lifecycle policy resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnLifecyclePolicy cfnLifecyclePolicy = CfnLifecyclePolicy.Builder.create(this, "MyCfnLifecyclePolicy")
 *         .executionRole("executionRole")
 *         .name("name")
 *         .policyDetails(List.of(PolicyDetailProperty.builder()
 *                 .action(ActionProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .includeResources(IncludeResourcesProperty.builder()
 *                                 .amis(false)
 *                                 .containers(false)
 *                                 .snapshots(false)
 *                                 .build())
 *                         .build())
 *                 .filter(FilterProperty.builder()
 *                         .type("type")
 *                         .value(123)
 *                         // the properties below are optional
 *                         .retainAtLeast(123)
 *                         .unit("unit")
 *                         .build())
 *                 // the properties below are optional
 *                 .exclusionRules(ExclusionRulesProperty.builder()
 *                         .amis(AmiExclusionRulesProperty.builder()
 *                                 .isPublic(false)
 *                                 .lastLaunched(LastLaunchedProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .regions(List.of("regions"))
 *                                 .sharedAccounts(List.of("sharedAccounts"))
 *                                 .tagMap(Map.of(
 *                                         "tagMapKey", "tagMap"))
 *                                 .build())
 *                         .tagMap(Map.of(
 *                                 "tagMapKey", "tagMap"))
 *                         .build())
 *                 .build()))
 *         .resourceSelection(ResourceSelectionProperty.builder()
 *                 .recipes(List.of(RecipeSelectionProperty.builder()
 *                         .name("name")
 *                         .semanticVersion("semanticVersion")
 *                         .build()))
 *                 .tagMap(Map.of(
 *                         "tagMapKey", "tagMap"))
 *                 .build())
 *         .resourceType("resourceType")
 *         // the properties below are optional
 *         .description("description")
 *         .status("status")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:55.668Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy")
public class CfnLifecyclePolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnLifecyclePolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLifecyclePolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLifecyclePolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the lifecycle policy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to run lifecycle actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole() {
        return software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to run lifecycle actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRole", java.util.Objects.requireNonNull(value, "executionRole is required"));
    }

    /**
     * The name of the lifecycle policy to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the lifecycle policy to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Configuration details for the lifecycle policy rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPolicyDetails() {
        return software.amazon.jsii.Kernel.get(this, "policyDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration details for the lifecycle policy rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "policyDetails", java.util.Objects.requireNonNull(value, "policyDetails is required"));
    }

    /**
     * Configuration details for the lifecycle policy rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyDetails(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.PolicyDetailProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.PolicyDetailProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "policyDetails", java.util.Objects.requireNonNull(value, "policyDetails is required"));
    }

    /**
     * Selection criteria for the resources that the lifecycle policy applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResourceSelection() {
        return software.amazon.jsii.Kernel.get(this, "resourceSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Selection criteria for the resources that the lifecycle policy applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceSelection(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceSelection", java.util.Objects.requireNonNull(value, "resourceSelection is required"));
    }

    /**
     * Selection criteria for the resources that the lifecycle policy applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceSelection(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.ResourceSelectionProperty value) {
        software.amazon.jsii.Kernel.set(this, "resourceSelection", java.util.Objects.requireNonNull(value, "resourceSelection is required"));
    }

    /**
     * The type of Image Builder resource that the lifecycle policy applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of Image Builder resource that the lifecycle policy applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceType", java.util.Objects.requireNonNull(value, "resourceType is required"));
    }

    /**
     * Optional description for the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Optional description for the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Indicates whether the lifecycle policy resource is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether the lifecycle policy resource is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", value);
    }

    /**
     * Tags to apply to the lifecycle policy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Tags to apply to the lifecycle policy resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Contains selection criteria for the lifecycle policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .includeResources(IncludeResourcesProperty.builder()
     *                 .amis(false)
     *                 .containers(false)
     *                 .snapshots(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the lifecycle action to take.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-action.html#cfn-imagebuilder-lifecyclepolicy-action-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-action.html#cfn-imagebuilder-lifecyclepolicy-action-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Specifies the resources that the lifecycle policy applies to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-action.html#cfn-imagebuilder-lifecyclepolicy-action-includeresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-action.html#cfn-imagebuilder-lifecyclepolicy-action-includeresources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeResources() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.String type;
            java.lang.Object includeResources;

            /**
             * Sets the value of {@link ActionProperty#getType}
             * @param type Specifies the lifecycle action to take. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIncludeResources}
             * @param includeResources Specifies the resources that the lifecycle policy applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeResources(software.amazon.awscdk.IResolvable includeResources) {
                this.includeResources = includeResources;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getIncludeResources}
             * @param includeResources Specifies the resources that the lifecycle policy applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeResources(software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.IncludeResourcesProperty includeResources) {
                this.includeResources = includeResources;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.String type;
            private final java.lang.Object includeResources;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeResources = software.amazon.jsii.Kernel.get(this, "includeResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.includeResources = builder.includeResources;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getIncludeResources() {
                return this.includeResources;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getIncludeResources() != null) {
                    data.set("includeResources", om.valueToTree(this.getIncludeResources()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.includeResources != null ? this.includeResources.equals(that.includeResources) : that.includeResources == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.includeResources != null ? this.includeResources.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines criteria for AMIs that are excluded from lifecycle actions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * AmiExclusionRulesProperty amiExclusionRulesProperty = AmiExclusionRulesProperty.builder()
     *         .isPublic(false)
     *         .lastLaunched(LastLaunchedProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .regions(List.of("regions"))
     *         .sharedAccounts(List.of("sharedAccounts"))
     *         .tagMap(Map.of(
     *                 "tagMapKey", "tagMap"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.AmiExclusionRulesProperty")
    @software.amazon.jsii.Jsii.Proxy(AmiExclusionRulesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmiExclusionRulesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configures whether public AMIs are excluded from the lifecycle action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html#cfn-imagebuilder-lifecyclepolicy-amiexclusionrules-ispublic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html#cfn-imagebuilder-lifecyclepolicy-amiexclusionrules-ispublic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsPublic() {
            return null;
        }

        /**
         * Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle actions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html#cfn-imagebuilder-lifecyclepolicy-amiexclusionrules-lastlaunched">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html#cfn-imagebuilder-lifecyclepolicy-amiexclusionrules-lastlaunched</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLastLaunched() {
            return null;
        }

        /**
         * Configures AWS Region s that are excluded from the lifecycle action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html#cfn-imagebuilder-lifecyclepolicy-amiexclusionrules-regions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html#cfn-imagebuilder-lifecyclepolicy-amiexclusionrules-regions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegions() {
            return null;
        }

        /**
         * Specifies AWS account s whose resources are excluded from the lifecycle action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html#cfn-imagebuilder-lifecyclepolicy-amiexclusionrules-sharedaccounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html#cfn-imagebuilder-lifecyclepolicy-amiexclusionrules-sharedaccounts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSharedAccounts() {
            return null;
        }

        /**
         * Lists tags that should be excluded from lifecycle actions for the AMIs that have them.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html#cfn-imagebuilder-lifecyclepolicy-amiexclusionrules-tagmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-amiexclusionrules.html#cfn-imagebuilder-lifecyclepolicy-amiexclusionrules-tagmap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagMap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmiExclusionRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmiExclusionRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmiExclusionRulesProperty> {
            java.lang.Object isPublic;
            java.lang.Object lastLaunched;
            java.util.List<java.lang.String> regions;
            java.util.List<java.lang.String> sharedAccounts;
            java.lang.Object tagMap;

            /**
             * Sets the value of {@link AmiExclusionRulesProperty#getIsPublic}
             * @param isPublic Configures whether public AMIs are excluded from the lifecycle action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isPublic(java.lang.Boolean isPublic) {
                this.isPublic = isPublic;
                return this;
            }

            /**
             * Sets the value of {@link AmiExclusionRulesProperty#getIsPublic}
             * @param isPublic Configures whether public AMIs are excluded from the lifecycle action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isPublic(software.amazon.awscdk.IResolvable isPublic) {
                this.isPublic = isPublic;
                return this;
            }

            /**
             * Sets the value of {@link AmiExclusionRulesProperty#getLastLaunched}
             * @param lastLaunched Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle actions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastLaunched(software.amazon.awscdk.IResolvable lastLaunched) {
                this.lastLaunched = lastLaunched;
                return this;
            }

            /**
             * Sets the value of {@link AmiExclusionRulesProperty#getLastLaunched}
             * @param lastLaunched Specifies configuration details for Image Builder to exclude the most recent resources from lifecycle actions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastLaunched(software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.LastLaunchedProperty lastLaunched) {
                this.lastLaunched = lastLaunched;
                return this;
            }

            /**
             * Sets the value of {@link AmiExclusionRulesProperty#getRegions}
             * @param regions Configures AWS Region s that are excluded from the lifecycle action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regions(java.util.List<java.lang.String> regions) {
                this.regions = regions;
                return this;
            }

            /**
             * Sets the value of {@link AmiExclusionRulesProperty#getSharedAccounts}
             * @param sharedAccounts Specifies AWS account s whose resources are excluded from the lifecycle action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharedAccounts(java.util.List<java.lang.String> sharedAccounts) {
                this.sharedAccounts = sharedAccounts;
                return this;
            }

            /**
             * Sets the value of {@link AmiExclusionRulesProperty#getTagMap}
             * @param tagMap Lists tags that should be excluded from lifecycle actions for the AMIs that have them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagMap(java.util.Map<java.lang.String, java.lang.String> tagMap) {
                this.tagMap = tagMap;
                return this;
            }

            /**
             * Sets the value of {@link AmiExclusionRulesProperty#getTagMap}
             * @param tagMap Lists tags that should be excluded from lifecycle actions for the AMIs that have them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagMap(software.amazon.awscdk.IResolvable tagMap) {
                this.tagMap = tagMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmiExclusionRulesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmiExclusionRulesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmiExclusionRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmiExclusionRulesProperty {
            private final java.lang.Object isPublic;
            private final java.lang.Object lastLaunched;
            private final java.util.List<java.lang.String> regions;
            private final java.util.List<java.lang.String> sharedAccounts;
            private final java.lang.Object tagMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isPublic = software.amazon.jsii.Kernel.get(this, "isPublic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lastLaunched = software.amazon.jsii.Kernel.get(this, "lastLaunched", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.sharedAccounts = software.amazon.jsii.Kernel.get(this, "sharedAccounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tagMap = software.amazon.jsii.Kernel.get(this, "tagMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isPublic = builder.isPublic;
                this.lastLaunched = builder.lastLaunched;
                this.regions = builder.regions;
                this.sharedAccounts = builder.sharedAccounts;
                this.tagMap = builder.tagMap;
            }

            @Override
            public final java.lang.Object getIsPublic() {
                return this.isPublic;
            }

            @Override
            public final java.lang.Object getLastLaunched() {
                return this.lastLaunched;
            }

            @Override
            public final java.util.List<java.lang.String> getRegions() {
                return this.regions;
            }

            @Override
            public final java.util.List<java.lang.String> getSharedAccounts() {
                return this.sharedAccounts;
            }

            @Override
            public final java.lang.Object getTagMap() {
                return this.tagMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsPublic() != null) {
                    data.set("isPublic", om.valueToTree(this.getIsPublic()));
                }
                if (this.getLastLaunched() != null) {
                    data.set("lastLaunched", om.valueToTree(this.getLastLaunched()));
                }
                if (this.getRegions() != null) {
                    data.set("regions", om.valueToTree(this.getRegions()));
                }
                if (this.getSharedAccounts() != null) {
                    data.set("sharedAccounts", om.valueToTree(this.getSharedAccounts()));
                }
                if (this.getTagMap() != null) {
                    data.set("tagMap", om.valueToTree(this.getTagMap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.AmiExclusionRulesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmiExclusionRulesProperty.Jsii$Proxy that = (AmiExclusionRulesProperty.Jsii$Proxy) o;

                if (this.isPublic != null ? !this.isPublic.equals(that.isPublic) : that.isPublic != null) return false;
                if (this.lastLaunched != null ? !this.lastLaunched.equals(that.lastLaunched) : that.lastLaunched != null) return false;
                if (this.regions != null ? !this.regions.equals(that.regions) : that.regions != null) return false;
                if (this.sharedAccounts != null ? !this.sharedAccounts.equals(that.sharedAccounts) : that.sharedAccounts != null) return false;
                return this.tagMap != null ? this.tagMap.equals(that.tagMap) : that.tagMap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isPublic != null ? this.isPublic.hashCode() : 0;
                result = 31 * result + (this.lastLaunched != null ? this.lastLaunched.hashCode() : 0);
                result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
                result = 31 * result + (this.sharedAccounts != null ? this.sharedAccounts.hashCode() : 0);
                result = 31 * result + (this.tagMap != null ? this.tagMap.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies resources that lifecycle policy actions should not apply to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * ExclusionRulesProperty exclusionRulesProperty = ExclusionRulesProperty.builder()
     *         .amis(AmiExclusionRulesProperty.builder()
     *                 .isPublic(false)
     *                 .lastLaunched(LastLaunchedProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .regions(List.of("regions"))
     *                 .sharedAccounts(List.of("sharedAccounts"))
     *                 .tagMap(Map.of(
     *                         "tagMapKey", "tagMap"))
     *                 .build())
     *         .tagMap(Map.of(
     *                 "tagMapKey", "tagMap"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-exclusionrules.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-exclusionrules.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.ExclusionRulesProperty")
    @software.amazon.jsii.Jsii.Proxy(ExclusionRulesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExclusionRulesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Lists configuration values that apply to AMIs that Image Builder should exclude from the lifecycle action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-exclusionrules.html#cfn-imagebuilder-lifecyclepolicy-exclusionrules-amis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-exclusionrules.html#cfn-imagebuilder-lifecyclepolicy-exclusionrules-amis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmis() {
            return null;
        }

        /**
         * Contains a list of tags that Image Builder uses to skip lifecycle actions for Image Builder image resources that have them.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-exclusionrules.html#cfn-imagebuilder-lifecyclepolicy-exclusionrules-tagmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-exclusionrules.html#cfn-imagebuilder-lifecyclepolicy-exclusionrules-tagmap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagMap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExclusionRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExclusionRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExclusionRulesProperty> {
            java.lang.Object amis;
            java.lang.Object tagMap;

            /**
             * Sets the value of {@link ExclusionRulesProperty#getAmis}
             * @param amis Lists configuration values that apply to AMIs that Image Builder should exclude from the lifecycle action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amis(software.amazon.awscdk.IResolvable amis) {
                this.amis = amis;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionRulesProperty#getAmis}
             * @param amis Lists configuration values that apply to AMIs that Image Builder should exclude from the lifecycle action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amis(software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.AmiExclusionRulesProperty amis) {
                this.amis = amis;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionRulesProperty#getTagMap}
             * @param tagMap Contains a list of tags that Image Builder uses to skip lifecycle actions for Image Builder image resources that have them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagMap(java.util.Map<java.lang.String, java.lang.String> tagMap) {
                this.tagMap = tagMap;
                return this;
            }

            /**
             * Sets the value of {@link ExclusionRulesProperty#getTagMap}
             * @param tagMap Contains a list of tags that Image Builder uses to skip lifecycle actions for Image Builder image resources that have them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagMap(software.amazon.awscdk.IResolvable tagMap) {
                this.tagMap = tagMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExclusionRulesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExclusionRulesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExclusionRulesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExclusionRulesProperty {
            private final java.lang.Object amis;
            private final java.lang.Object tagMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amis = software.amazon.jsii.Kernel.get(this, "amis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagMap = software.amazon.jsii.Kernel.get(this, "tagMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amis = builder.amis;
                this.tagMap = builder.tagMap;
            }

            @Override
            public final java.lang.Object getAmis() {
                return this.amis;
            }

            @Override
            public final java.lang.Object getTagMap() {
                return this.tagMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmis() != null) {
                    data.set("amis", om.valueToTree(this.getAmis()));
                }
                if (this.getTagMap() != null) {
                    data.set("tagMap", om.valueToTree(this.getTagMap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.ExclusionRulesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExclusionRulesProperty.Jsii$Proxy that = (ExclusionRulesProperty.Jsii$Proxy) o;

                if (this.amis != null ? !this.amis.equals(that.amis) : that.amis != null) return false;
                return this.tagMap != null ? this.tagMap.equals(that.tagMap) : that.tagMap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amis != null ? this.amis.hashCode() : 0;
                result = 31 * result + (this.tagMap != null ? this.tagMap.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines filters that the lifecycle policy uses to determine impacted resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * FilterProperty filterProperty = FilterProperty.builder()
     *         .type("type")
     *         .value(123)
     *         // the properties below are optional
     *         .retainAtLeast(123)
     *         .unit("unit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-filter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-filter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.FilterProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Filter resources based on either <code>age</code> or <code>count</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-filter.html#cfn-imagebuilder-lifecyclepolicy-filter-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-filter.html#cfn-imagebuilder-lifecyclepolicy-filter-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The number of units for the time period or for the count.
         * <p>
         * For example, a value of <code>6</code> might refer to six months or six AMIs.
         * <p>
         * <blockquote>
         * <p>
         * For count-based filters, this value represents the minimum number of resources to keep on hand. If you have fewer resources than this number, the resource is excluded from lifecycle actions.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-filter.html#cfn-imagebuilder-lifecyclepolicy-filter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-filter.html#cfn-imagebuilder-lifecyclepolicy-filter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * For age-based filters, this is the number of resources to keep on hand after the lifecycle <code>DELETE</code> action is applied.
         * <p>
         * Impacted resources are only deleted if you have more than this number of resources. If you have fewer resources than this number, the impacted resource is not deleted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-filter.html#cfn-imagebuilder-lifecyclepolicy-filter-retainatleast">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-filter.html#cfn-imagebuilder-lifecyclepolicy-filter-retainatleast</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetainAtLeast() {
            return null;
        }

        /**
         * Defines the unit of time that the lifecycle policy uses to determine impacted resources.
         * <p>
         * This is required for age-based rules.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-filter.html#cfn-imagebuilder-lifecyclepolicy-filter-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-filter.html#cfn-imagebuilder-lifecyclepolicy-filter-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterProperty> {
            java.lang.String type;
            java.lang.Number value;
            java.lang.Number retainAtLeast;
            java.lang.String unit;

            /**
             * Sets the value of {@link FilterProperty#getType}
             * @param type Filter resources based on either <code>age</code> or <code>count</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getValue}
             * @param value The number of units for the time period or for the count. This parameter is required.
             *              For example, a value of <code>6</code> might refer to six months or six AMIs.
             *              <p>
             *              <blockquote>
             *              <p>
             *              For count-based filters, this value represents the minimum number of resources to keep on hand. If you have fewer resources than this number, the resource is excluded from lifecycle actions.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getRetainAtLeast}
             * @param retainAtLeast For age-based filters, this is the number of resources to keep on hand after the lifecycle <code>DELETE</code> action is applied.
             *                      Impacted resources are only deleted if you have more than this number of resources. If you have fewer resources than this number, the impacted resource is not deleted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retainAtLeast(java.lang.Number retainAtLeast) {
                this.retainAtLeast = retainAtLeast;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getUnit}
             * @param unit Defines the unit of time that the lifecycle policy uses to determine impacted resources.
             *             This is required for age-based rules.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterProperty {
            private final java.lang.String type;
            private final java.lang.Number value;
            private final java.lang.Number retainAtLeast;
            private final java.lang.String unit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.retainAtLeast = software.amazon.jsii.Kernel.get(this, "retainAtLeast", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.retainAtLeast = builder.retainAtLeast;
                this.unit = builder.unit;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            public final java.lang.Number getRetainAtLeast() {
                return this.retainAtLeast;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));
                if (this.getRetainAtLeast() != null) {
                    data.set("retainAtLeast", om.valueToTree(this.getRetainAtLeast()));
                }
                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.FilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterProperty.Jsii$Proxy that = (FilterProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (!value.equals(that.value)) return false;
                if (this.retainAtLeast != null ? !this.retainAtLeast.equals(that.retainAtLeast) : that.retainAtLeast != null) return false;
                return this.unit != null ? this.unit.equals(that.unit) : that.unit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                result = 31 * result + (this.retainAtLeast != null ? this.retainAtLeast.hashCode() : 0);
                result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies how the lifecycle policy should apply actions to selected resources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * IncludeResourcesProperty includeResourcesProperty = IncludeResourcesProperty.builder()
     *         .amis(false)
     *         .containers(false)
     *         .snapshots(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-includeresources.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-includeresources.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.IncludeResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(IncludeResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IncludeResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the lifecycle action should apply to distributed AMIs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-includeresources.html#cfn-imagebuilder-lifecyclepolicy-includeresources-amis">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-includeresources.html#cfn-imagebuilder-lifecyclepolicy-includeresources-amis</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmis() {
            return null;
        }

        /**
         * Specifies whether the lifecycle action should apply to distributed containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-includeresources.html#cfn-imagebuilder-lifecyclepolicy-includeresources-containers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-includeresources.html#cfn-imagebuilder-lifecyclepolicy-includeresources-containers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainers() {
            return null;
        }

        /**
         * Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-includeresources.html#cfn-imagebuilder-lifecyclepolicy-includeresources-snapshots">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-includeresources.html#cfn-imagebuilder-lifecyclepolicy-includeresources-snapshots</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnapshots() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IncludeResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IncludeResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IncludeResourcesProperty> {
            java.lang.Object amis;
            java.lang.Object containers;
            java.lang.Object snapshots;

            /**
             * Sets the value of {@link IncludeResourcesProperty#getAmis}
             * @param amis Specifies whether the lifecycle action should apply to distributed AMIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amis(java.lang.Boolean amis) {
                this.amis = amis;
                return this;
            }

            /**
             * Sets the value of {@link IncludeResourcesProperty#getAmis}
             * @param amis Specifies whether the lifecycle action should apply to distributed AMIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amis(software.amazon.awscdk.IResolvable amis) {
                this.amis = amis;
                return this;
            }

            /**
             * Sets the value of {@link IncludeResourcesProperty#getContainers}
             * @param containers Specifies whether the lifecycle action should apply to distributed containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(java.lang.Boolean containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link IncludeResourcesProperty#getContainers}
             * @param containers Specifies whether the lifecycle action should apply to distributed containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(software.amazon.awscdk.IResolvable containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link IncludeResourcesProperty#getSnapshots}
             * @param snapshots Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshots(java.lang.Boolean snapshots) {
                this.snapshots = snapshots;
                return this;
            }

            /**
             * Sets the value of {@link IncludeResourcesProperty#getSnapshots}
             * @param snapshots Specifies whether the lifecycle action should apply to snapshots associated with distributed AMIs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshots(software.amazon.awscdk.IResolvable snapshots) {
                this.snapshots = snapshots;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IncludeResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IncludeResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IncludeResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IncludeResourcesProperty {
            private final java.lang.Object amis;
            private final java.lang.Object containers;
            private final java.lang.Object snapshots;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amis = software.amazon.jsii.Kernel.get(this, "amis", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snapshots = software.amazon.jsii.Kernel.get(this, "snapshots", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amis = builder.amis;
                this.containers = builder.containers;
                this.snapshots = builder.snapshots;
            }

            @Override
            public final java.lang.Object getAmis() {
                return this.amis;
            }

            @Override
            public final java.lang.Object getContainers() {
                return this.containers;
            }

            @Override
            public final java.lang.Object getSnapshots() {
                return this.snapshots;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmis() != null) {
                    data.set("amis", om.valueToTree(this.getAmis()));
                }
                if (this.getContainers() != null) {
                    data.set("containers", om.valueToTree(this.getContainers()));
                }
                if (this.getSnapshots() != null) {
                    data.set("snapshots", om.valueToTree(this.getSnapshots()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.IncludeResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IncludeResourcesProperty.Jsii$Proxy that = (IncludeResourcesProperty.Jsii$Proxy) o;

                if (this.amis != null ? !this.amis.equals(that.amis) : that.amis != null) return false;
                if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
                return this.snapshots != null ? this.snapshots.equals(that.snapshots) : that.snapshots == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amis != null ? this.amis.hashCode() : 0;
                result = 31 * result + (this.containers != null ? this.containers.hashCode() : 0);
                result = 31 * result + (this.snapshots != null ? this.snapshots.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines criteria to exclude AMIs from lifecycle actions based on the last time they were used to launch an instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * LastLaunchedProperty lastLaunchedProperty = LastLaunchedProperty.builder()
     *         .unit("unit")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-lastlaunched.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-lastlaunched.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.LastLaunchedProperty")
    @software.amazon.jsii.Jsii.Proxy(LastLaunchedProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LastLaunchedProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the unit of time that the lifecycle policy uses to calculate elapsed time since the last instance launched from the AMI.
         * <p>
         * For example: days, weeks, months, or years.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-lastlaunched.html#cfn-imagebuilder-lifecyclepolicy-lastlaunched-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-lastlaunched.html#cfn-imagebuilder-lifecyclepolicy-lastlaunched-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * The integer number of units for the time period.
         * <p>
         * For example <code>6</code> (months).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-lastlaunched.html#cfn-imagebuilder-lifecyclepolicy-lastlaunched-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-lastlaunched.html#cfn-imagebuilder-lifecyclepolicy-lastlaunched-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link LastLaunchedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LastLaunchedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LastLaunchedProperty> {
            java.lang.String unit;
            java.lang.Number value;

            /**
             * Sets the value of {@link LastLaunchedProperty#getUnit}
             * @param unit Defines the unit of time that the lifecycle policy uses to calculate elapsed time since the last instance launched from the AMI. This parameter is required.
             *             For example: days, weeks, months, or years.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link LastLaunchedProperty#getValue}
             * @param value The integer number of units for the time period. This parameter is required.
             *              For example <code>6</code> (months).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LastLaunchedProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LastLaunchedProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LastLaunchedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LastLaunchedProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.LastLaunchedProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LastLaunchedProperty.Jsii$Proxy that = (LastLaunchedProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration details for a lifecycle policy resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * PolicyDetailProperty policyDetailProperty = PolicyDetailProperty.builder()
     *         .action(ActionProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .includeResources(IncludeResourcesProperty.builder()
     *                         .amis(false)
     *                         .containers(false)
     *                         .snapshots(false)
     *                         .build())
     *                 .build())
     *         .filter(FilterProperty.builder()
     *                 .type("type")
     *                 .value(123)
     *                 // the properties below are optional
     *                 .retainAtLeast(123)
     *                 .unit("unit")
     *                 .build())
     *         // the properties below are optional
     *         .exclusionRules(ExclusionRulesProperty.builder()
     *                 .amis(AmiExclusionRulesProperty.builder()
     *                         .isPublic(false)
     *                         .lastLaunched(LastLaunchedProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .regions(List.of("regions"))
     *                         .sharedAccounts(List.of("sharedAccounts"))
     *                         .tagMap(Map.of(
     *                                 "tagMapKey", "tagMap"))
     *                         .build())
     *                 .tagMap(Map.of(
     *                         "tagMapKey", "tagMap"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-policydetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-policydetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.PolicyDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration details for the policy action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-policydetail.html#cfn-imagebuilder-lifecyclepolicy-policydetail-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-policydetail.html#cfn-imagebuilder-lifecyclepolicy-policydetail-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAction();

        /**
         * Specifies the resources that the lifecycle policy applies to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-policydetail.html#cfn-imagebuilder-lifecyclepolicy-policydetail-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-policydetail.html#cfn-imagebuilder-lifecyclepolicy-policydetail-filter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFilter();

        /**
         * Additional rules to specify resources that should be exempt from policy actions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-policydetail.html#cfn-imagebuilder-lifecyclepolicy-policydetail-exclusionrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-policydetail.html#cfn-imagebuilder-lifecyclepolicy-policydetail-exclusionrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExclusionRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyDetailProperty> {
            java.lang.Object action;
            java.lang.Object filter;
            java.lang.Object exclusionRules;

            /**
             * Sets the value of {@link PolicyDetailProperty#getAction}
             * @param action Configuration details for the policy action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailProperty#getAction}
             * @param action Configuration details for the policy action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.ActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailProperty#getFilter}
             * @param filter Specifies the resources that the lifecycle policy applies to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.IResolvable filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailProperty#getFilter}
             * @param filter Specifies the resources that the lifecycle policy applies to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filter(software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.FilterProperty filter) {
                this.filter = filter;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailProperty#getExclusionRules}
             * @param exclusionRules Additional rules to specify resources that should be exempt from policy actions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionRules(software.amazon.awscdk.IResolvable exclusionRules) {
                this.exclusionRules = exclusionRules;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDetailProperty#getExclusionRules}
             * @param exclusionRules Additional rules to specify resources that should be exempt from policy actions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclusionRules(software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.ExclusionRulesProperty exclusionRules) {
                this.exclusionRules = exclusionRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyDetailProperty {
            private final java.lang.Object action;
            private final java.lang.Object filter;
            private final java.lang.Object exclusionRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exclusionRules = software.amazon.jsii.Kernel.get(this, "exclusionRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.filter = java.util.Objects.requireNonNull(builder.filter, "filter is required");
                this.exclusionRules = builder.exclusionRules;
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getFilter() {
                return this.filter;
            }

            @Override
            public final java.lang.Object getExclusionRules() {
                return this.exclusionRules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("filter", om.valueToTree(this.getFilter()));
                if (this.getExclusionRules() != null) {
                    data.set("exclusionRules", om.valueToTree(this.getExclusionRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.PolicyDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyDetailProperty.Jsii$Proxy that = (PolicyDetailProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!filter.equals(that.filter)) return false;
                return this.exclusionRules != null ? this.exclusionRules.equals(that.exclusionRules) : that.exclusionRules == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.filter.hashCode());
                result = 31 * result + (this.exclusionRules != null ? this.exclusionRules.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an Image Builder recipe that the lifecycle policy uses for resource selection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * RecipeSelectionProperty recipeSelectionProperty = RecipeSelectionProperty.builder()
     *         .name("name")
     *         .semanticVersion("semanticVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-recipeselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-recipeselection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.RecipeSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(RecipeSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RecipeSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an Image Builder recipe that the lifecycle policy uses for resource selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-recipeselection.html#cfn-imagebuilder-lifecyclepolicy-recipeselection-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-recipeselection.html#cfn-imagebuilder-lifecyclepolicy-recipeselection-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The version of the Image Builder recipe specified by the <code>name</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-recipeselection.html#cfn-imagebuilder-lifecyclepolicy-recipeselection-semanticversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-recipeselection.html#cfn-imagebuilder-lifecyclepolicy-recipeselection-semanticversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSemanticVersion();

        /**
         * @return a {@link Builder} of {@link RecipeSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RecipeSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RecipeSelectionProperty> {
            java.lang.String name;
            java.lang.String semanticVersion;

            /**
             * Sets the value of {@link RecipeSelectionProperty#getName}
             * @param name The name of an Image Builder recipe that the lifecycle policy uses for resource selection. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RecipeSelectionProperty#getSemanticVersion}
             * @param semanticVersion The version of the Image Builder recipe specified by the <code>name</code> field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticVersion(java.lang.String semanticVersion) {
                this.semanticVersion = semanticVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RecipeSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RecipeSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RecipeSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecipeSelectionProperty {
            private final java.lang.String name;
            private final java.lang.String semanticVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.semanticVersion = software.amazon.jsii.Kernel.get(this, "semanticVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.semanticVersion = java.util.Objects.requireNonNull(builder.semanticVersion, "semanticVersion is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSemanticVersion() {
                return this.semanticVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("semanticVersion", om.valueToTree(this.getSemanticVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.RecipeSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RecipeSelectionProperty.Jsii$Proxy that = (RecipeSelectionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.semanticVersion.equals(that.semanticVersion);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.semanticVersion.hashCode());
                return result;
            }
        }
    }
    /**
     * Resource selection criteria for the lifecycle policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * ResourceSelectionProperty resourceSelectionProperty = ResourceSelectionProperty.builder()
     *         .recipes(List.of(RecipeSelectionProperty.builder()
     *                 .name("name")
     *                 .semanticVersion("semanticVersion")
     *                 .build()))
     *         .tagMap(Map.of(
     *                 "tagMapKey", "tagMap"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-resourceselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-resourceselection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.ResourceSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of recipes that are used as selection criteria for the output images that the lifecycle policy applies to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-resourceselection.html#cfn-imagebuilder-lifecyclepolicy-resourceselection-recipes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-resourceselection.html#cfn-imagebuilder-lifecyclepolicy-resourceselection-recipes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecipes() {
            return null;
        }

        /**
         * A list of tags that are used as selection criteria for the Image Builder image resources that the lifecycle policy applies to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-resourceselection.html#cfn-imagebuilder-lifecyclepolicy-resourceselection-tagmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-imagebuilder-lifecyclepolicy-resourceselection.html#cfn-imagebuilder-lifecyclepolicy-resourceselection-tagmap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagMap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceSelectionProperty> {
            java.lang.Object recipes;
            java.lang.Object tagMap;

            /**
             * Sets the value of {@link ResourceSelectionProperty#getRecipes}
             * @param recipes A list of recipes that are used as selection criteria for the output images that the lifecycle policy applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recipes(software.amazon.awscdk.IResolvable recipes) {
                this.recipes = recipes;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSelectionProperty#getRecipes}
             * @param recipes A list of recipes that are used as selection criteria for the output images that the lifecycle policy applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recipes(java.util.List<? extends java.lang.Object> recipes) {
                this.recipes = recipes;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSelectionProperty#getTagMap}
             * @param tagMap A list of tags that are used as selection criteria for the Image Builder image resources that the lifecycle policy applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagMap(java.util.Map<java.lang.String, java.lang.String> tagMap) {
                this.tagMap = tagMap;
                return this;
            }

            /**
             * Sets the value of {@link ResourceSelectionProperty#getTagMap}
             * @param tagMap A list of tags that are used as selection criteria for the Image Builder image resources that the lifecycle policy applies to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagMap(software.amazon.awscdk.IResolvable tagMap) {
                this.tagMap = tagMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceSelectionProperty {
            private final java.lang.Object recipes;
            private final java.lang.Object tagMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recipes = software.amazon.jsii.Kernel.get(this, "recipes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagMap = software.amazon.jsii.Kernel.get(this, "tagMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recipes = builder.recipes;
                this.tagMap = builder.tagMap;
            }

            @Override
            public final java.lang.Object getRecipes() {
                return this.recipes;
            }

            @Override
            public final java.lang.Object getTagMap() {
                return this.tagMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRecipes() != null) {
                    data.set("recipes", om.valueToTree(this.getRecipes()));
                }
                if (this.getTagMap() != null) {
                    data.set("tagMap", om.valueToTree(this.getTagMap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnLifecyclePolicy.ResourceSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceSelectionProperty.Jsii$Proxy that = (ResourceSelectionProperty.Jsii$Proxy) o;

                if (this.recipes != null ? !this.recipes.equals(that.recipes) : that.recipes != null) return false;
                return this.tagMap != null ? this.tagMap.equals(that.tagMap) : that.tagMap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recipes != null ? this.recipes.hashCode() : 0;
                result = 31 * result + (this.tagMap != null ? this.tagMap.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicyProps.Builder();
        }

        /**
         * The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to run lifecycle actions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-executionrole</a>
         * @param executionRole The name or Amazon Resource Name (ARN) for the IAM role you create that grants Image Builder access to run lifecycle actions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final java.lang.String executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        /**
         * The name of the lifecycle policy to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-name</a>
         * @param name The name of the lifecycle policy to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Configuration details for the lifecycle policy rules.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-policydetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-policydetails</a>
         * @param policyDetails Configuration details for the lifecycle policy rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(final software.amazon.awscdk.IResolvable policyDetails) {
            this.props.policyDetails(policyDetails);
            return this;
        }
        /**
         * Configuration details for the lifecycle policy rules.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-policydetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-policydetails</a>
         * @param policyDetails Configuration details for the lifecycle policy rules. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(final java.util.List<? extends java.lang.Object> policyDetails) {
            this.props.policyDetails(policyDetails);
            return this;
        }

        /**
         * Selection criteria for the resources that the lifecycle policy applies to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-resourceselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-resourceselection</a>
         * @param resourceSelection Selection criteria for the resources that the lifecycle policy applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSelection(final software.amazon.awscdk.IResolvable resourceSelection) {
            this.props.resourceSelection(resourceSelection);
            return this;
        }
        /**
         * Selection criteria for the resources that the lifecycle policy applies to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-resourceselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-resourceselection</a>
         * @param resourceSelection Selection criteria for the resources that the lifecycle policy applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSelection(final software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy.ResourceSelectionProperty resourceSelection) {
            this.props.resourceSelection(resourceSelection);
            return this;
        }

        /**
         * The type of Image Builder resource that the lifecycle policy applies to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-resourcetype</a>
         * @param resourceType The type of Image Builder resource that the lifecycle policy applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(final java.lang.String resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        /**
         * Optional description for the lifecycle policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-description</a>
         * @param description Optional description for the lifecycle policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Indicates whether the lifecycle policy resource is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-status</a>
         * @param status Indicates whether the lifecycle policy resource is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * Tags to apply to the lifecycle policy resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-lifecyclepolicy.html#cfn-imagebuilder-lifecyclepolicy-tags</a>
         * @param tags Tags to apply to the lifecycle policy resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy build() {
            return new software.amazon.awscdk.services.imagebuilder.CfnLifecyclePolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
