package software.amazon.awscdk.services.iotfleetwise;

/**
 * Properties for defining a <code>CfnCampaign</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * CfnCampaignProps cfnCampaignProps = CfnCampaignProps.builder()
 *         .collectionScheme(CollectionSchemeProperty.builder()
 *                 .conditionBasedCollectionScheme(ConditionBasedCollectionSchemeProperty.builder()
 *                         .expression("expression")
 *                         // the properties below are optional
 *                         .conditionLanguageVersion(123)
 *                         .minimumTriggerIntervalMs(123)
 *                         .triggerMode("triggerMode")
 *                         .build())
 *                 .timeBasedCollectionScheme(TimeBasedCollectionSchemeProperty.builder()
 *                         .periodMs(123)
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .signalCatalogArn("signalCatalogArn")
 *         .targetArn("targetArn")
 *         // the properties below are optional
 *         .action("action")
 *         .compression("compression")
 *         .dataDestinationConfigs(List.of(DataDestinationConfigProperty.builder()
 *                 .mqttTopicConfig(MqttTopicConfigProperty.builder()
 *                         .executionRoleArn("executionRoleArn")
 *                         .mqttTopicArn("mqttTopicArn")
 *                         .build())
 *                 .s3Config(S3ConfigProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         // the properties below are optional
 *                         .dataFormat("dataFormat")
 *                         .prefix("prefix")
 *                         .storageCompressionFormat("storageCompressionFormat")
 *                         .build())
 *                 .timestreamConfig(TimestreamConfigProperty.builder()
 *                         .executionRoleArn("executionRoleArn")
 *                         .timestreamTableArn("timestreamTableArn")
 *                         .build())
 *                 .build()))
 *         .dataExtraDimensions(List.of("dataExtraDimensions"))
 *         .dataPartitions(List.of(DataPartitionProperty.builder()
 *                 .id("id")
 *                 .storageOptions(DataPartitionStorageOptionsProperty.builder()
 *                         .maximumSize(StorageMaximumSizeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .minimumTimeToLive(StorageMinimumTimeToLiveProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .storageLocation("storageLocation")
 *                         .build())
 *                 // the properties below are optional
 *                 .uploadOptions(DataPartitionUploadOptionsProperty.builder()
 *                         .expression("expression")
 *                         // the properties below are optional
 *                         .conditionLanguageVersion(123)
 *                         .build())
 *                 .build()))
 *         .description("description")
 *         .diagnosticsMode("diagnosticsMode")
 *         .expiryTime("expiryTime")
 *         .postTriggerCollectionDuration(123)
 *         .priority(123)
 *         .signalsToCollect(List.of(SignalInformationProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .dataPartitionId("dataPartitionId")
 *                 .maxSampleCount(123)
 *                 .minimumSamplingIntervalMs(123)
 *                 .build()))
 *         .signalsToFetch(List.of(SignalFetchInformationProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .fullyQualifiedName("fullyQualifiedName")
 *                 .signalFetchConfig(SignalFetchConfigProperty.builder()
 *                         .conditionBased(ConditionBasedSignalFetchConfigProperty.builder()
 *                                 .conditionExpression("conditionExpression")
 *                                 .triggerMode("triggerMode")
 *                                 .build())
 *                         .timeBased(TimeBasedSignalFetchConfigProperty.builder()
 *                                 .executionFrequencyMs(123)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .conditionLanguageVersion(123)
 *                 .build()))
 *         .spoolingMode("spoolingMode")
 *         .startTime("startTime")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:55.980Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnCampaignProps")
@software.amazon.jsii.Jsii.Proxy(CfnCampaignProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCampaignProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The data collection scheme associated with the campaign.
     * <p>
     * You can specify a scheme that collects data based on time or an event.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-collectionscheme">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-collectionscheme</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCollectionScheme();

    /**
     * The name of a campaign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the signal catalog associated with the campaign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalcatalogarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalcatalogarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSignalCatalogArn();

    /**
     * The Amazon Resource Name (ARN) of a vehicle or fleet to which the campaign is deployed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-targetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-targetarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

    /**
     * Specifies how to update a campaign. The action can be one of the following:.
     * <p>
     * <ul>
     * <li><code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.</li>
     * <li><code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and all vehicles in the suspended campaign will stop sending data.</li>
     * <li><code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to all vehicles and the vehicles will resume sending data.</li>
     * <li><code>UPDATE</code> - To update a campaign.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-action</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
        return null;
    }

    /**
     * Whether to compress signals before transmitting data to AWS IoT FleetWise .
     * <p>
     * If you don't want to compress the signals, use <code>OFF</code> . If it's not specified, <code>SNAPPY</code> is used.
     * <p>
     * Default: <code>SNAPPY</code>
     * <p>
     * Default: - "OFF"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-compression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-compression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCompression() {
        return null;
    }

    /**
     * The destination where the campaign sends data.
     * <p>
     * You can choose to send data to be stored in Amazon S3 or Amazon Timestream .
     * <p>
     * Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as data lakes, centralized data storage, data processing pipelines, and analytics. AWS IoT FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on multiple AWS IoT FleetWise servers for redundancy and high availability.
     * <p>
     * You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so that you can identify trends and patterns.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-datadestinationconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-datadestinationconfigs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataDestinationConfigs() {
        return null;
    }

    /**
     * A list of vehicle attributes to associate with a campaign.
     * <p>
     * Enrich the data with specified vehicle attributes. For example, add <code>make</code> and <code>model</code> to the campaign, and AWS IoT FleetWise will associate the data with those attributes as dimensions in Amazon Timestream . You can then query the data against <code>make</code> and <code>model</code> .
     * <p>
     * Default: An empty array
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-dataextradimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-dataextradimensions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDataExtraDimensions() {
        return null;
    }

    /**
     * The data partitions associated with the signals collected from the vehicle.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-datapartitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-datapartitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataPartitions() {
        return null;
    }

    /**
     * The description of the campaign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Option for a vehicle to send diagnostic trouble codes to AWS IoT FleetWise .
     * <p>
     * If you want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code> . If it's not specified, <code>OFF</code> is used.
     * <p>
     * Default: <code>OFF</code>
     * <p>
     * Default: - "OFF"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-diagnosticsmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-diagnosticsmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDiagnosticsMode() {
        return null;
    }

    /**
     * The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time).
     * <p>
     * Vehicle data isn't collected after the campaign expires.
     * <p>
     * Default: 253402214400 (December 31, 9999, 00:00:00 UTC)
     * <p>
     * Default: - "253402214400"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-expirytime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-expirytime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExpiryTime() {
        return null;
    }

    /**
     * How long (in milliseconds) to collect raw data after a triggering event initiates the collection.
     * <p>
     * If it's not specified, <code>0</code> is used.
     * <p>
     * Default: <code>0</code>
     * <p>
     * Default: - 0
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-posttriggercollectionduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-posttriggercollectionduration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPostTriggerCollectionDuration() {
        return null;
    }

    /**
     * A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet.
     * <p>
     * A campaign with the lowest value is deployed to vehicles before any other campaigns. If it's not specified, <code>0</code> is used.
     * <p>
     * Default: <code>0</code>
     * <p>
     * Default: - 0
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-priority</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * A list of information about signals to collect.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalstocollect">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalstocollect</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSignalsToCollect() {
        return null;
    }

    /**
     * A list of information about signals to fetch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalstofetch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-signalstofetch</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSignalsToFetch() {
        return null;
    }

    /**
     * Whether to store collected data after a vehicle lost a connection with the cloud.
     * <p>
     * After a connection is re-established, the data is automatically forwarded to AWS IoT FleetWise . If you want to store collected data when a vehicle loses connection with the cloud, use <code>TO_DISK</code> . If it's not specified, <code>OFF</code> is used.
     * <p>
     * Default: <code>OFF</code>
     * <p>
     * Default: - "OFF"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-spoolingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-spoolingmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSpoolingMode() {
        return null;
    }

    /**
     * The time, in milliseconds, to deliver a campaign after it was approved. If it's not specified, <code>0</code> is used.
     * <p>
     * Default: <code>0</code>
     * <p>
     * Default: - "0"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-starttime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStartTime() {
        return null;
    }

    /**
     * Metadata that can be used to manage the campaign.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-campaign.html#cfn-iotfleetwise-campaign-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCampaignProps> {
        java.lang.Object collectionScheme;
        java.lang.String name;
        java.lang.String signalCatalogArn;
        java.lang.String targetArn;
        java.lang.String action;
        java.lang.String compression;
        java.lang.Object dataDestinationConfigs;
        java.util.List<java.lang.String> dataExtraDimensions;
        java.lang.Object dataPartitions;
        java.lang.String description;
        java.lang.String diagnosticsMode;
        java.lang.String expiryTime;
        java.lang.Number postTriggerCollectionDuration;
        java.lang.Number priority;
        java.lang.Object signalsToCollect;
        java.lang.Object signalsToFetch;
        java.lang.String spoolingMode;
        java.lang.String startTime;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCampaignProps#getCollectionScheme}
         * @param collectionScheme The data collection scheme associated with the campaign. This parameter is required.
         *                         You can specify a scheme that collects data based on time or an event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionScheme(software.amazon.awscdk.IResolvable collectionScheme) {
            this.collectionScheme = collectionScheme;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getCollectionScheme}
         * @param collectionScheme The data collection scheme associated with the campaign. This parameter is required.
         *                         You can specify a scheme that collects data based on time or an event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionScheme(software.amazon.awscdk.services.iotfleetwise.CfnCampaign.CollectionSchemeProperty collectionScheme) {
            this.collectionScheme = collectionScheme;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getName}
         * @param name The name of a campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSignalCatalogArn}
         * @param signalCatalogArn The Amazon Resource Name (ARN) of the signal catalog associated with the campaign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalCatalogArn(java.lang.String signalCatalogArn) {
            this.signalCatalogArn = signalCatalogArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getTargetArn}
         * @param targetArn The Amazon Resource Name (ARN) of a vehicle or fleet to which the campaign is deployed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(java.lang.String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getAction}
         * @param action Specifies how to update a campaign. The action can be one of the following:.
         *               <ul>
         *               <li><code>APPROVE</code> - To approve delivering a data collection scheme to vehicles.</li>
         *               <li><code>SUSPEND</code> - To suspend collecting signal data. The campaign is deleted from vehicles and all vehicles in the suspended campaign will stop sending data.</li>
         *               <li><code>RESUME</code> - To reactivate the <code>SUSPEND</code> campaign. The campaign is redeployed to all vehicles and the vehicles will resume sending data.</li>
         *               <li><code>UPDATE</code> - To update a campaign.</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getCompression}
         * @param compression Whether to compress signals before transmitting data to AWS IoT FleetWise .
         *                    If you don't want to compress the signals, use <code>OFF</code> . If it's not specified, <code>SNAPPY</code> is used.
         *                    <p>
         *                    Default: <code>SNAPPY</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(java.lang.String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getDataDestinationConfigs}
         * @param dataDestinationConfigs The destination where the campaign sends data.
         *                               You can choose to send data to be stored in Amazon S3 or Amazon Timestream .
         *                               <p>
         *                               Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as data lakes, centralized data storage, data processing pipelines, and analytics. AWS IoT FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on multiple AWS IoT FleetWise servers for redundancy and high availability.
         *                               <p>
         *                               You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so that you can identify trends and patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDestinationConfigs(software.amazon.awscdk.IResolvable dataDestinationConfigs) {
            this.dataDestinationConfigs = dataDestinationConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getDataDestinationConfigs}
         * @param dataDestinationConfigs The destination where the campaign sends data.
         *                               You can choose to send data to be stored in Amazon S3 or Amazon Timestream .
         *                               <p>
         *                               Amazon S3 optimizes the cost of data storage and provides additional mechanisms to use vehicle data, such as data lakes, centralized data storage, data processing pipelines, and analytics. AWS IoT FleetWise supports at-least-once file delivery to S3. Your vehicle data is stored on multiple AWS IoT FleetWise servers for redundancy and high availability.
         *                               <p>
         *                               You can use Amazon Timestream to access and analyze time series data, and Timestream to query vehicle data so that you can identify trends and patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDestinationConfigs(java.util.List<? extends java.lang.Object> dataDestinationConfigs) {
            this.dataDestinationConfigs = dataDestinationConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getDataExtraDimensions}
         * @param dataExtraDimensions A list of vehicle attributes to associate with a campaign.
         *                            Enrich the data with specified vehicle attributes. For example, add <code>make</code> and <code>model</code> to the campaign, and AWS IoT FleetWise will associate the data with those attributes as dimensions in Amazon Timestream . You can then query the data against <code>make</code> and <code>model</code> .
         *                            <p>
         *                            Default: An empty array
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataExtraDimensions(java.util.List<java.lang.String> dataExtraDimensions) {
            this.dataExtraDimensions = dataExtraDimensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getDataPartitions}
         * @param dataPartitions The data partitions associated with the signals collected from the vehicle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataPartitions(software.amazon.awscdk.IResolvable dataPartitions) {
            this.dataPartitions = dataPartitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getDataPartitions}
         * @param dataPartitions The data partitions associated with the signals collected from the vehicle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataPartitions(java.util.List<? extends java.lang.Object> dataPartitions) {
            this.dataPartitions = dataPartitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getDescription}
         * @param description The description of the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getDiagnosticsMode}
         * @param diagnosticsMode Option for a vehicle to send diagnostic trouble codes to AWS IoT FleetWise .
         *                        If you want to send diagnostic trouble codes, use <code>SEND_ACTIVE_DTCS</code> . If it's not specified, <code>OFF</code> is used.
         *                        <p>
         *                        Default: <code>OFF</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder diagnosticsMode(java.lang.String diagnosticsMode) {
            this.diagnosticsMode = diagnosticsMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getExpiryTime}
         * @param expiryTime The time the campaign expires, in seconds since epoch (January 1, 1970 at midnight UTC time).
         *                   Vehicle data isn't collected after the campaign expires.
         *                   <p>
         *                   Default: 253402214400 (December 31, 9999, 00:00:00 UTC)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expiryTime(java.lang.String expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getPostTriggerCollectionDuration}
         * @param postTriggerCollectionDuration How long (in milliseconds) to collect raw data after a triggering event initiates the collection.
         *                                      If it's not specified, <code>0</code> is used.
         *                                      <p>
         *                                      Default: <code>0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder postTriggerCollectionDuration(java.lang.Number postTriggerCollectionDuration) {
            this.postTriggerCollectionDuration = postTriggerCollectionDuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getPriority}
         * @param priority A number indicating the priority of one campaign over another campaign for a certain vehicle or fleet.
         *                 A campaign with the lowest value is deployed to vehicles before any other campaigns. If it's not specified, <code>0</code> is used.
         *                 <p>
         *                 Default: <code>0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSignalsToCollect}
         * @param signalsToCollect A list of information about signals to collect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalsToCollect(software.amazon.awscdk.IResolvable signalsToCollect) {
            this.signalsToCollect = signalsToCollect;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSignalsToCollect}
         * @param signalsToCollect A list of information about signals to collect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalsToCollect(java.util.List<? extends java.lang.Object> signalsToCollect) {
            this.signalsToCollect = signalsToCollect;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSignalsToFetch}
         * @param signalsToFetch A list of information about signals to fetch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalsToFetch(software.amazon.awscdk.IResolvable signalsToFetch) {
            this.signalsToFetch = signalsToFetch;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSignalsToFetch}
         * @param signalsToFetch A list of information about signals to fetch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalsToFetch(java.util.List<? extends java.lang.Object> signalsToFetch) {
            this.signalsToFetch = signalsToFetch;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getSpoolingMode}
         * @param spoolingMode Whether to store collected data after a vehicle lost a connection with the cloud.
         *                     After a connection is re-established, the data is automatically forwarded to AWS IoT FleetWise . If you want to store collected data when a vehicle loses connection with the cloud, use <code>TO_DISK</code> . If it's not specified, <code>OFF</code> is used.
         *                     <p>
         *                     Default: <code>OFF</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spoolingMode(java.lang.String spoolingMode) {
            this.spoolingMode = spoolingMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getStartTime}
         * @param startTime The time, in milliseconds, to deliver a campaign after it was approved. If it's not specified, <code>0</code> is used.
         *                  Default: <code>0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(java.lang.String startTime) {
            this.startTime = startTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnCampaignProps#getTags}
         * @param tags Metadata that can be used to manage the campaign.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCampaignProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCampaignProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCampaignProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCampaignProps {
        private final java.lang.Object collectionScheme;
        private final java.lang.String name;
        private final java.lang.String signalCatalogArn;
        private final java.lang.String targetArn;
        private final java.lang.String action;
        private final java.lang.String compression;
        private final java.lang.Object dataDestinationConfigs;
        private final java.util.List<java.lang.String> dataExtraDimensions;
        private final java.lang.Object dataPartitions;
        private final java.lang.String description;
        private final java.lang.String diagnosticsMode;
        private final java.lang.String expiryTime;
        private final java.lang.Number postTriggerCollectionDuration;
        private final java.lang.Number priority;
        private final java.lang.Object signalsToCollect;
        private final java.lang.Object signalsToFetch;
        private final java.lang.String spoolingMode;
        private final java.lang.String startTime;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.collectionScheme = software.amazon.jsii.Kernel.get(this, "collectionScheme", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signalCatalogArn = software.amazon.jsii.Kernel.get(this, "signalCatalogArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataDestinationConfigs = software.amazon.jsii.Kernel.get(this, "dataDestinationConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataExtraDimensions = software.amazon.jsii.Kernel.get(this, "dataExtraDimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dataPartitions = software.amazon.jsii.Kernel.get(this, "dataPartitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.diagnosticsMode = software.amazon.jsii.Kernel.get(this, "diagnosticsMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.expiryTime = software.amazon.jsii.Kernel.get(this, "expiryTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.postTriggerCollectionDuration = software.amazon.jsii.Kernel.get(this, "postTriggerCollectionDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.signalsToCollect = software.amazon.jsii.Kernel.get(this, "signalsToCollect", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.signalsToFetch = software.amazon.jsii.Kernel.get(this, "signalsToFetch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.spoolingMode = software.amazon.jsii.Kernel.get(this, "spoolingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.collectionScheme = java.util.Objects.requireNonNull(builder.collectionScheme, "collectionScheme is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.signalCatalogArn = java.util.Objects.requireNonNull(builder.signalCatalogArn, "signalCatalogArn is required");
            this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
            this.action = builder.action;
            this.compression = builder.compression;
            this.dataDestinationConfigs = builder.dataDestinationConfigs;
            this.dataExtraDimensions = builder.dataExtraDimensions;
            this.dataPartitions = builder.dataPartitions;
            this.description = builder.description;
            this.diagnosticsMode = builder.diagnosticsMode;
            this.expiryTime = builder.expiryTime;
            this.postTriggerCollectionDuration = builder.postTriggerCollectionDuration;
            this.priority = builder.priority;
            this.signalsToCollect = builder.signalsToCollect;
            this.signalsToFetch = builder.signalsToFetch;
            this.spoolingMode = builder.spoolingMode;
            this.startTime = builder.startTime;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getCollectionScheme() {
            return this.collectionScheme;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getSignalCatalogArn() {
            return this.signalCatalogArn;
        }

        @Override
        public final java.lang.String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.String getCompression() {
            return this.compression;
        }

        @Override
        public final java.lang.Object getDataDestinationConfigs() {
            return this.dataDestinationConfigs;
        }

        @Override
        public final java.util.List<java.lang.String> getDataExtraDimensions() {
            return this.dataExtraDimensions;
        }

        @Override
        public final java.lang.Object getDataPartitions() {
            return this.dataPartitions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDiagnosticsMode() {
            return this.diagnosticsMode;
        }

        @Override
        public final java.lang.String getExpiryTime() {
            return this.expiryTime;
        }

        @Override
        public final java.lang.Number getPostTriggerCollectionDuration() {
            return this.postTriggerCollectionDuration;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.Object getSignalsToCollect() {
            return this.signalsToCollect;
        }

        @Override
        public final java.lang.Object getSignalsToFetch() {
            return this.signalsToFetch;
        }

        @Override
        public final java.lang.String getSpoolingMode() {
            return this.spoolingMode;
        }

        @Override
        public final java.lang.String getStartTime() {
            return this.startTime;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("collectionScheme", om.valueToTree(this.getCollectionScheme()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("signalCatalogArn", om.valueToTree(this.getSignalCatalogArn()));
            data.set("targetArn", om.valueToTree(this.getTargetArn()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getCompression() != null) {
                data.set("compression", om.valueToTree(this.getCompression()));
            }
            if (this.getDataDestinationConfigs() != null) {
                data.set("dataDestinationConfigs", om.valueToTree(this.getDataDestinationConfigs()));
            }
            if (this.getDataExtraDimensions() != null) {
                data.set("dataExtraDimensions", om.valueToTree(this.getDataExtraDimensions()));
            }
            if (this.getDataPartitions() != null) {
                data.set("dataPartitions", om.valueToTree(this.getDataPartitions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDiagnosticsMode() != null) {
                data.set("diagnosticsMode", om.valueToTree(this.getDiagnosticsMode()));
            }
            if (this.getExpiryTime() != null) {
                data.set("expiryTime", om.valueToTree(this.getExpiryTime()));
            }
            if (this.getPostTriggerCollectionDuration() != null) {
                data.set("postTriggerCollectionDuration", om.valueToTree(this.getPostTriggerCollectionDuration()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }
            if (this.getSignalsToCollect() != null) {
                data.set("signalsToCollect", om.valueToTree(this.getSignalsToCollect()));
            }
            if (this.getSignalsToFetch() != null) {
                data.set("signalsToFetch", om.valueToTree(this.getSignalsToFetch()));
            }
            if (this.getSpoolingMode() != null) {
                data.set("spoolingMode", om.valueToTree(this.getSpoolingMode()));
            }
            if (this.getStartTime() != null) {
                data.set("startTime", om.valueToTree(this.getStartTime()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnCampaignProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCampaignProps.Jsii$Proxy that = (CfnCampaignProps.Jsii$Proxy) o;

            if (!collectionScheme.equals(that.collectionScheme)) return false;
            if (!name.equals(that.name)) return false;
            if (!signalCatalogArn.equals(that.signalCatalogArn)) return false;
            if (!targetArn.equals(that.targetArn)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
            if (this.dataDestinationConfigs != null ? !this.dataDestinationConfigs.equals(that.dataDestinationConfigs) : that.dataDestinationConfigs != null) return false;
            if (this.dataExtraDimensions != null ? !this.dataExtraDimensions.equals(that.dataExtraDimensions) : that.dataExtraDimensions != null) return false;
            if (this.dataPartitions != null ? !this.dataPartitions.equals(that.dataPartitions) : that.dataPartitions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.diagnosticsMode != null ? !this.diagnosticsMode.equals(that.diagnosticsMode) : that.diagnosticsMode != null) return false;
            if (this.expiryTime != null ? !this.expiryTime.equals(that.expiryTime) : that.expiryTime != null) return false;
            if (this.postTriggerCollectionDuration != null ? !this.postTriggerCollectionDuration.equals(that.postTriggerCollectionDuration) : that.postTriggerCollectionDuration != null) return false;
            if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
            if (this.signalsToCollect != null ? !this.signalsToCollect.equals(that.signalsToCollect) : that.signalsToCollect != null) return false;
            if (this.signalsToFetch != null ? !this.signalsToFetch.equals(that.signalsToFetch) : that.signalsToFetch != null) return false;
            if (this.spoolingMode != null ? !this.spoolingMode.equals(that.spoolingMode) : that.spoolingMode != null) return false;
            if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.collectionScheme.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.signalCatalogArn.hashCode());
            result = 31 * result + (this.targetArn.hashCode());
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
            result = 31 * result + (this.dataDestinationConfigs != null ? this.dataDestinationConfigs.hashCode() : 0);
            result = 31 * result + (this.dataExtraDimensions != null ? this.dataExtraDimensions.hashCode() : 0);
            result = 31 * result + (this.dataPartitions != null ? this.dataPartitions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.diagnosticsMode != null ? this.diagnosticsMode.hashCode() : 0);
            result = 31 * result + (this.expiryTime != null ? this.expiryTime.hashCode() : 0);
            result = 31 * result + (this.postTriggerCollectionDuration != null ? this.postTriggerCollectionDuration.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            result = 31 * result + (this.signalsToCollect != null ? this.signalsToCollect.hashCode() : 0);
            result = 31 * result + (this.signalsToFetch != null ? this.signalsToFetch.hashCode() : 0);
            result = 31 * result + (this.spoolingMode != null ? this.spoolingMode.hashCode() : 0);
            result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
