package software.amazon.awscdk.services.iotsitewise;

/**
 * Properties for defining a <code>CfnDashboard</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * CfnDashboardProps cfnDashboardProps = CfnDashboardProps.builder()
 *         .dashboardDefinition("dashboardDefinition")
 *         .dashboardDescription("dashboardDescription")
 *         .dashboardName("dashboardName")
 *         // the properties below are optional
 *         .projectId("projectId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:56.052Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnDashboardProps")
@software.amazon.jsii.Jsii.Proxy(CfnDashboardProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDashboardProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The dashboard definition specified in a JSON literal.
     * <p>
     * <ul>
     * <li>AWS IoT SiteWise Monitor (Classic) see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Create dashboards ( AWS CLI )</a></li>
     * <li>AWS IoT SiteWise Monitor (AI-aware) see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-ai-dashboard-cli.html">Create dashboards ( AWS CLI )</a></li>
     * </ul>
     * <p>
     * in the <em>AWS IoT SiteWise User Guide</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboarddefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboarddefinition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDashboardDefinition();

    /**
     * A description for the dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboarddescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboarddescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDashboardDescription();

    /**
     * A friendly name for the dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboardname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-dashboardname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDashboardName();

    /**
     * The ID of the project in which to create the dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-projectid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-projectid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProjectId() {
        return null;
    }

    /**
     * A list of key-value pairs that contain metadata for the dashboard.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-dashboard.html#cfn-iotsitewise-dashboard-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDashboardProps> {
        java.lang.String dashboardDefinition;
        java.lang.String dashboardDescription;
        java.lang.String dashboardName;
        java.lang.String projectId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDashboardProps#getDashboardDefinition}
         * @param dashboardDefinition The dashboard definition specified in a JSON literal. This parameter is required.
         *                            <ul>
         *                            <li>AWS IoT SiteWise Monitor (Classic) see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-using-aws-cli.html">Create dashboards ( AWS CLI )</a></li>
         *                            <li>AWS IoT SiteWise Monitor (AI-aware) see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-dashboards-ai-dashboard-cli.html">Create dashboards ( AWS CLI )</a></li>
         *                            </ul>
         *                            <p>
         *                            in the <em>AWS IoT SiteWise User Guide</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardDefinition(java.lang.String dashboardDefinition) {
            this.dashboardDefinition = dashboardDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getDashboardDescription}
         * @param dashboardDescription A description for the dashboard. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardDescription(java.lang.String dashboardDescription) {
            this.dashboardDescription = dashboardDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getDashboardName}
         * @param dashboardName A friendly name for the dashboard. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardName(java.lang.String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getProjectId}
         * @param projectId The ID of the project in which to create the dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDashboardProps#getTags}
         * @param tags A list of key-value pairs that contain metadata for the dashboard.
         *             For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDashboardProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDashboardProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDashboardProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDashboardProps {
        private final java.lang.String dashboardDefinition;
        private final java.lang.String dashboardDescription;
        private final java.lang.String dashboardName;
        private final java.lang.String projectId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dashboardDefinition = software.amazon.jsii.Kernel.get(this, "dashboardDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dashboardDescription = software.amazon.jsii.Kernel.get(this, "dashboardDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dashboardName = software.amazon.jsii.Kernel.get(this, "dashboardName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.projectId = software.amazon.jsii.Kernel.get(this, "projectId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dashboardDefinition = java.util.Objects.requireNonNull(builder.dashboardDefinition, "dashboardDefinition is required");
            this.dashboardDescription = java.util.Objects.requireNonNull(builder.dashboardDescription, "dashboardDescription is required");
            this.dashboardName = java.util.Objects.requireNonNull(builder.dashboardName, "dashboardName is required");
            this.projectId = builder.projectId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDashboardDefinition() {
            return this.dashboardDefinition;
        }

        @Override
        public final java.lang.String getDashboardDescription() {
            return this.dashboardDescription;
        }

        @Override
        public final java.lang.String getDashboardName() {
            return this.dashboardName;
        }

        @Override
        public final java.lang.String getProjectId() {
            return this.projectId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dashboardDefinition", om.valueToTree(this.getDashboardDefinition()));
            data.set("dashboardDescription", om.valueToTree(this.getDashboardDescription()));
            data.set("dashboardName", om.valueToTree(this.getDashboardName()));
            if (this.getProjectId() != null) {
                data.set("projectId", om.valueToTree(this.getProjectId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnDashboardProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDashboardProps.Jsii$Proxy that = (CfnDashboardProps.Jsii$Proxy) o;

            if (!dashboardDefinition.equals(that.dashboardDefinition)) return false;
            if (!dashboardDescription.equals(that.dashboardDescription)) return false;
            if (!dashboardName.equals(that.dashboardName)) return false;
            if (this.projectId != null ? !this.projectId.equals(that.projectId) : that.projectId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dashboardDefinition.hashCode();
            result = 31 * result + (this.dashboardDescription.hashCode());
            result = 31 * result + (this.dashboardName.hashCode());
            result = 31 * result + (this.projectId != null ? this.projectId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
