package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Configuration interface for logging errors when data transformation or delivery fails.
 * <p>
 * This interface defines whether logging is enabled and optionally allows specifying a
 * CloudWatch Log Group for storing error logs.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:56.523Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.ILoggingConfig")
@software.amazon.jsii.Jsii.Proxy(ILoggingConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ILoggingConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * If true, log errors when data transformation or data delivery fails.
     * <p>
     * <code>true</code> when using <code>EnableLogging</code>, <code>false</code> when using <code>DisableLogging</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getLogging();

    /**
     * The CloudWatch log group where log streams will be created to hold error logs.
     * <p>
     * Default: - if `logging` is set to `true`, a log group will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * If true, log errors when data transformation or data delivery fails.
         * <p>
         * <code>true</code> when using <code>EnableLogging</code>, <code>false</code> when using <code>DisableLogging</code>.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean getLogging() {
            return software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The CloudWatch log group where log streams will be created to hold error logs.
         * <p>
         * Default: - if `logging` is set to `true`, a log group will be created for you.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
        }
    }

    /**
     * Internal default implementation for {@link ILoggingConfig}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends ILoggingConfig {

        /**
         * If true, log errors when data transformation or data delivery fails.
         * <p>
         * <code>true</code> when using <code>EnableLogging</code>, <code>false</code> when using <code>DisableLogging</code>.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.Boolean getLogging() {
            return software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The CloudWatch log group where log streams will be created to hold error logs.
         * <p>
         * Default: - if `logging` is set to `true`, a log group will be created for you.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
        }
    }
}
