package software.amazon.awscdk.services.lambda;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * LambdaRuntimeProps lambdaRuntimeProps = LambdaRuntimeProps.builder()
 *         .bundlingDockerImage("bundlingDockerImage")
 *         .isVariable(false)
 *         .supportsCodeGuruProfiling(false)
 *         .supportsInlineCode(false)
 *         .supportsSnapStart(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:56.802Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.LambdaRuntimeProps")
@software.amazon.jsii.Jsii.Proxy(LambdaRuntimeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaRuntimeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Docker image name to be used for bundling in this runtime.
     * <p>
     * Default: - the latest docker image "amazon/public.ecr.aws/sam/build-<runtime>" from https://gallery.ecr.aws
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBundlingDockerImage() {
        return null;
    }

    /**
     * Whether the runtime enum is meant to change over time, IE NODEJS_LATEST.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIsVariable() {
        return null;
    }

    /**
     * Whether this runtime is integrated with and supported for profiling using Amazon CodeGuru Profiler.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportsCodeGuruProfiling() {
        return null;
    }

    /**
     * Whether the <code>ZipFile</code> (aka inline code) property can be used with this runtime.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportsInlineCode() {
        return null;
    }

    /**
     * Whether this runtime supports SnapStart.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSupportsSnapStart() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaRuntimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaRuntimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaRuntimeProps> {
        java.lang.String bundlingDockerImage;
        java.lang.Boolean isVariable;
        java.lang.Boolean supportsCodeGuruProfiling;
        java.lang.Boolean supportsInlineCode;
        java.lang.Boolean supportsSnapStart;

        /**
         * Sets the value of {@link LambdaRuntimeProps#getBundlingDockerImage}
         * @param bundlingDockerImage The Docker image name to be used for bundling in this runtime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundlingDockerImage(java.lang.String bundlingDockerImage) {
            this.bundlingDockerImage = bundlingDockerImage;
            return this;
        }

        /**
         * Sets the value of {@link LambdaRuntimeProps#getIsVariable}
         * @param isVariable Whether the runtime enum is meant to change over time, IE NODEJS_LATEST.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isVariable(java.lang.Boolean isVariable) {
            this.isVariable = isVariable;
            return this;
        }

        /**
         * Sets the value of {@link LambdaRuntimeProps#getSupportsCodeGuruProfiling}
         * @param supportsCodeGuruProfiling Whether this runtime is integrated with and supported for profiling using Amazon CodeGuru Profiler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportsCodeGuruProfiling(java.lang.Boolean supportsCodeGuruProfiling) {
            this.supportsCodeGuruProfiling = supportsCodeGuruProfiling;
            return this;
        }

        /**
         * Sets the value of {@link LambdaRuntimeProps#getSupportsInlineCode}
         * @param supportsInlineCode Whether the <code>ZipFile</code> (aka inline code) property can be used with this runtime.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportsInlineCode(java.lang.Boolean supportsInlineCode) {
            this.supportsInlineCode = supportsInlineCode;
            return this;
        }

        /**
         * Sets the value of {@link LambdaRuntimeProps#getSupportsSnapStart}
         * @param supportsSnapStart Whether this runtime supports SnapStart.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportsSnapStart(java.lang.Boolean supportsSnapStart) {
            this.supportsSnapStart = supportsSnapStart;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaRuntimeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LambdaRuntimeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LambdaRuntimeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaRuntimeProps {
        private final java.lang.String bundlingDockerImage;
        private final java.lang.Boolean isVariable;
        private final java.lang.Boolean supportsCodeGuruProfiling;
        private final java.lang.Boolean supportsInlineCode;
        private final java.lang.Boolean supportsSnapStart;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bundlingDockerImage = software.amazon.jsii.Kernel.get(this, "bundlingDockerImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.isVariable = software.amazon.jsii.Kernel.get(this, "isVariable", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.supportsCodeGuruProfiling = software.amazon.jsii.Kernel.get(this, "supportsCodeGuruProfiling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.supportsInlineCode = software.amazon.jsii.Kernel.get(this, "supportsInlineCode", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.supportsSnapStart = software.amazon.jsii.Kernel.get(this, "supportsSnapStart", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bundlingDockerImage = builder.bundlingDockerImage;
            this.isVariable = builder.isVariable;
            this.supportsCodeGuruProfiling = builder.supportsCodeGuruProfiling;
            this.supportsInlineCode = builder.supportsInlineCode;
            this.supportsSnapStart = builder.supportsSnapStart;
        }

        @Override
        public final java.lang.String getBundlingDockerImage() {
            return this.bundlingDockerImage;
        }

        @Override
        public final java.lang.Boolean getIsVariable() {
            return this.isVariable;
        }

        @Override
        public final java.lang.Boolean getSupportsCodeGuruProfiling() {
            return this.supportsCodeGuruProfiling;
        }

        @Override
        public final java.lang.Boolean getSupportsInlineCode() {
            return this.supportsInlineCode;
        }

        @Override
        public final java.lang.Boolean getSupportsSnapStart() {
            return this.supportsSnapStart;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBundlingDockerImage() != null) {
                data.set("bundlingDockerImage", om.valueToTree(this.getBundlingDockerImage()));
            }
            if (this.getIsVariable() != null) {
                data.set("isVariable", om.valueToTree(this.getIsVariable()));
            }
            if (this.getSupportsCodeGuruProfiling() != null) {
                data.set("supportsCodeGuruProfiling", om.valueToTree(this.getSupportsCodeGuruProfiling()));
            }
            if (this.getSupportsInlineCode() != null) {
                data.set("supportsInlineCode", om.valueToTree(this.getSupportsInlineCode()));
            }
            if (this.getSupportsSnapStart() != null) {
                data.set("supportsSnapStart", om.valueToTree(this.getSupportsSnapStart()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.LambdaRuntimeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaRuntimeProps.Jsii$Proxy that = (LambdaRuntimeProps.Jsii$Proxy) o;

            if (this.bundlingDockerImage != null ? !this.bundlingDockerImage.equals(that.bundlingDockerImage) : that.bundlingDockerImage != null) return false;
            if (this.isVariable != null ? !this.isVariable.equals(that.isVariable) : that.isVariable != null) return false;
            if (this.supportsCodeGuruProfiling != null ? !this.supportsCodeGuruProfiling.equals(that.supportsCodeGuruProfiling) : that.supportsCodeGuruProfiling != null) return false;
            if (this.supportsInlineCode != null ? !this.supportsInlineCode.equals(that.supportsInlineCode) : that.supportsInlineCode != null) return false;
            return this.supportsSnapStart != null ? this.supportsSnapStart.equals(that.supportsSnapStart) : that.supportsSnapStart == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bundlingDockerImage != null ? this.bundlingDockerImage.hashCode() : 0;
            result = 31 * result + (this.isVariable != null ? this.isVariable.hashCode() : 0);
            result = 31 * result + (this.supportsCodeGuruProfiling != null ? this.supportsCodeGuruProfiling.hashCode() : 0);
            result = 31 * result + (this.supportsInlineCode != null ? this.supportsInlineCode.hashCode() : 0);
            result = 31 * result + (this.supportsSnapStart != null ? this.supportsSnapStart.hashCode() : 0);
            return result;
        }
    }
}
