package software.amazon.awscdk.services.licensemanager;

/**
 * Properties for defining a <code>CfnLicense</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.licensemanager.*;
 * CfnLicenseProps cfnLicenseProps = CfnLicenseProps.builder()
 *         .consumptionConfiguration(ConsumptionConfigurationProperty.builder()
 *                 .borrowConfiguration(BorrowConfigurationProperty.builder()
 *                         .allowEarlyCheckIn(false)
 *                         .maxTimeToLiveInMinutes(123)
 *                         .build())
 *                 .provisionalConfiguration(ProvisionalConfigurationProperty.builder()
 *                         .maxTimeToLiveInMinutes(123)
 *                         .build())
 *                 .renewType("renewType")
 *                 .build())
 *         .entitlements(List.of(EntitlementProperty.builder()
 *                 .name("name")
 *                 .unit("unit")
 *                 // the properties below are optional
 *                 .allowCheckIn(false)
 *                 .maxCount(123)
 *                 .overage(false)
 *                 .value("value")
 *                 .build()))
 *         .homeRegion("homeRegion")
 *         .issuer(IssuerDataProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .signKey("signKey")
 *                 .build())
 *         .licenseName("licenseName")
 *         .productName("productName")
 *         .validity(ValidityDateFormatProperty.builder()
 *                 .begin("begin")
 *                 .end("end")
 *                 .build())
 *         // the properties below are optional
 *         .beneficiary("beneficiary")
 *         .licenseMetadata(List.of(MetadataProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .productSku("productSku")
 *         .status("status")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:56.983Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_licensemanager.CfnLicenseProps")
@software.amazon.jsii.Jsii.Proxy(CfnLicenseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLicenseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configuration for consumption of the license.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-consumptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-consumptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConsumptionConfiguration();

    /**
     * License entitlements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-entitlements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-entitlements</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEntitlements();

    /**
     * Home Region of the license.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-homeregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-homeregion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHomeRegion();

    /**
     * License issuer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-issuer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-issuer</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getIssuer();

    /**
     * License name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLicenseName();

    /**
     * Product name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProductName();

    /**
     * Date and time range during which the license is valid, in ISO8601-UTC format.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-validity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-validity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getValidity();

    /**
     * License beneficiary.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-beneficiary">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-beneficiary</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBeneficiary() {
        return null;
    }

    /**
     * License metadata.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensemetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensemetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLicenseMetadata() {
        return null;
    }

    /**
     * Product SKU.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productsku">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productsku</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProductSku() {
        return null;
    }

    /**
     * License status.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLicenseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLicenseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLicenseProps> {
        java.lang.Object consumptionConfiguration;
        java.lang.Object entitlements;
        java.lang.String homeRegion;
        java.lang.Object issuer;
        java.lang.String licenseName;
        java.lang.String productName;
        java.lang.Object validity;
        java.lang.String beneficiary;
        java.lang.Object licenseMetadata;
        java.lang.String productSku;
        java.lang.String status;

        /**
         * Sets the value of {@link CfnLicenseProps#getConsumptionConfiguration}
         * @param consumptionConfiguration Configuration for consumption of the license. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumptionConfiguration(software.amazon.awscdk.IResolvable consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getConsumptionConfiguration}
         * @param consumptionConfiguration Configuration for consumption of the license. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumptionConfiguration(software.amazon.awscdk.services.licensemanager.CfnLicense.ConsumptionConfigurationProperty consumptionConfiguration) {
            this.consumptionConfiguration = consumptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getEntitlements}
         * @param entitlements License entitlements. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entitlements(software.amazon.awscdk.IResolvable entitlements) {
            this.entitlements = entitlements;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getEntitlements}
         * @param entitlements License entitlements. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entitlements(java.util.List<? extends java.lang.Object> entitlements) {
            this.entitlements = entitlements;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getHomeRegion}
         * @param homeRegion Home Region of the license. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder homeRegion(java.lang.String homeRegion) {
            this.homeRegion = homeRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getIssuer}
         * @param issuer License issuer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder issuer(software.amazon.awscdk.IResolvable issuer) {
            this.issuer = issuer;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getIssuer}
         * @param issuer License issuer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder issuer(software.amazon.awscdk.services.licensemanager.CfnLicense.IssuerDataProperty issuer) {
            this.issuer = issuer;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getLicenseName}
         * @param licenseName License name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseName(java.lang.String licenseName) {
            this.licenseName = licenseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getProductName}
         * @param productName Product name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productName(java.lang.String productName) {
            this.productName = productName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getValidity}
         * @param validity Date and time range during which the license is valid, in ISO8601-UTC format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validity(software.amazon.awscdk.IResolvable validity) {
            this.validity = validity;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getValidity}
         * @param validity Date and time range during which the license is valid, in ISO8601-UTC format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validity(software.amazon.awscdk.services.licensemanager.CfnLicense.ValidityDateFormatProperty validity) {
            this.validity = validity;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getBeneficiary}
         * @param beneficiary License beneficiary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder beneficiary(java.lang.String beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getLicenseMetadata}
         * @param licenseMetadata License metadata.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseMetadata(software.amazon.awscdk.IResolvable licenseMetadata) {
            this.licenseMetadata = licenseMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getLicenseMetadata}
         * @param licenseMetadata License metadata.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseMetadata(java.util.List<? extends java.lang.Object> licenseMetadata) {
            this.licenseMetadata = licenseMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getProductSku}
         * @param productSku Product SKU.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productSku(java.lang.String productSku) {
            this.productSku = productSku;
            return this;
        }

        /**
         * Sets the value of {@link CfnLicenseProps#getStatus}
         * @param status License status.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLicenseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLicenseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLicenseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLicenseProps {
        private final java.lang.Object consumptionConfiguration;
        private final java.lang.Object entitlements;
        private final java.lang.String homeRegion;
        private final java.lang.Object issuer;
        private final java.lang.String licenseName;
        private final java.lang.String productName;
        private final java.lang.Object validity;
        private final java.lang.String beneficiary;
        private final java.lang.Object licenseMetadata;
        private final java.lang.String productSku;
        private final java.lang.String status;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.consumptionConfiguration = software.amazon.jsii.Kernel.get(this, "consumptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.entitlements = software.amazon.jsii.Kernel.get(this, "entitlements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.homeRegion = software.amazon.jsii.Kernel.get(this, "homeRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.licenseName = software.amazon.jsii.Kernel.get(this, "licenseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.productName = software.amazon.jsii.Kernel.get(this, "productName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validity = software.amazon.jsii.Kernel.get(this, "validity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.beneficiary = software.amazon.jsii.Kernel.get(this, "beneficiary", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.licenseMetadata = software.amazon.jsii.Kernel.get(this, "licenseMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.productSku = software.amazon.jsii.Kernel.get(this, "productSku", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.consumptionConfiguration = java.util.Objects.requireNonNull(builder.consumptionConfiguration, "consumptionConfiguration is required");
            this.entitlements = java.util.Objects.requireNonNull(builder.entitlements, "entitlements is required");
            this.homeRegion = java.util.Objects.requireNonNull(builder.homeRegion, "homeRegion is required");
            this.issuer = java.util.Objects.requireNonNull(builder.issuer, "issuer is required");
            this.licenseName = java.util.Objects.requireNonNull(builder.licenseName, "licenseName is required");
            this.productName = java.util.Objects.requireNonNull(builder.productName, "productName is required");
            this.validity = java.util.Objects.requireNonNull(builder.validity, "validity is required");
            this.beneficiary = builder.beneficiary;
            this.licenseMetadata = builder.licenseMetadata;
            this.productSku = builder.productSku;
            this.status = builder.status;
        }

        @Override
        public final java.lang.Object getConsumptionConfiguration() {
            return this.consumptionConfiguration;
        }

        @Override
        public final java.lang.Object getEntitlements() {
            return this.entitlements;
        }

        @Override
        public final java.lang.String getHomeRegion() {
            return this.homeRegion;
        }

        @Override
        public final java.lang.Object getIssuer() {
            return this.issuer;
        }

        @Override
        public final java.lang.String getLicenseName() {
            return this.licenseName;
        }

        @Override
        public final java.lang.String getProductName() {
            return this.productName;
        }

        @Override
        public final java.lang.Object getValidity() {
            return this.validity;
        }

        @Override
        public final java.lang.String getBeneficiary() {
            return this.beneficiary;
        }

        @Override
        public final java.lang.Object getLicenseMetadata() {
            return this.licenseMetadata;
        }

        @Override
        public final java.lang.String getProductSku() {
            return this.productSku;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("consumptionConfiguration", om.valueToTree(this.getConsumptionConfiguration()));
            data.set("entitlements", om.valueToTree(this.getEntitlements()));
            data.set("homeRegion", om.valueToTree(this.getHomeRegion()));
            data.set("issuer", om.valueToTree(this.getIssuer()));
            data.set("licenseName", om.valueToTree(this.getLicenseName()));
            data.set("productName", om.valueToTree(this.getProductName()));
            data.set("validity", om.valueToTree(this.getValidity()));
            if (this.getBeneficiary() != null) {
                data.set("beneficiary", om.valueToTree(this.getBeneficiary()));
            }
            if (this.getLicenseMetadata() != null) {
                data.set("licenseMetadata", om.valueToTree(this.getLicenseMetadata()));
            }
            if (this.getProductSku() != null) {
                data.set("productSku", om.valueToTree(this.getProductSku()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_licensemanager.CfnLicenseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLicenseProps.Jsii$Proxy that = (CfnLicenseProps.Jsii$Proxy) o;

            if (!consumptionConfiguration.equals(that.consumptionConfiguration)) return false;
            if (!entitlements.equals(that.entitlements)) return false;
            if (!homeRegion.equals(that.homeRegion)) return false;
            if (!issuer.equals(that.issuer)) return false;
            if (!licenseName.equals(that.licenseName)) return false;
            if (!productName.equals(that.productName)) return false;
            if (!validity.equals(that.validity)) return false;
            if (this.beneficiary != null ? !this.beneficiary.equals(that.beneficiary) : that.beneficiary != null) return false;
            if (this.licenseMetadata != null ? !this.licenseMetadata.equals(that.licenseMetadata) : that.licenseMetadata != null) return false;
            if (this.productSku != null ? !this.productSku.equals(that.productSku) : that.productSku != null) return false;
            return this.status != null ? this.status.equals(that.status) : that.status == null;
        }

        @Override
        public final int hashCode() {
            int result = this.consumptionConfiguration.hashCode();
            result = 31 * result + (this.entitlements.hashCode());
            result = 31 * result + (this.homeRegion.hashCode());
            result = 31 * result + (this.issuer.hashCode());
            result = 31 * result + (this.licenseName.hashCode());
            result = 31 * result + (this.productName.hashCode());
            result = 31 * result + (this.validity.hashCode());
            result = 31 * result + (this.beneficiary != null ? this.beneficiary.hashCode() : 0);
            result = 31 * result + (this.licenseMetadata != null ? this.licenseMetadata.hashCode() : 0);
            result = 31 * result + (this.productSku != null ? this.productSku.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            return result;
        }
    }
}
