package software.amazon.awscdk.services.lightsail;

/**
 * The <code>AWS::Lightsail::Database</code> resource specifies an Amazon Lightsail database.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnDatabase cfnDatabase = CfnDatabase.Builder.create(this, "MyCfnDatabase")
 *         .masterDatabaseName("masterDatabaseName")
 *         .masterUsername("masterUsername")
 *         .relationalDatabaseBlueprintId("relationalDatabaseBlueprintId")
 *         .relationalDatabaseBundleId("relationalDatabaseBundleId")
 *         .relationalDatabaseName("relationalDatabaseName")
 *         // the properties below are optional
 *         .availabilityZone("availabilityZone")
 *         .backupRetention(false)
 *         .caCertificateIdentifier("caCertificateIdentifier")
 *         .masterUserPassword("masterUserPassword")
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .publiclyAccessible(false)
 *         .relationalDatabaseParameters(List.of(RelationalDatabaseParameterProperty.builder()
 *                 .allowedValues("allowedValues")
 *                 .applyMethod("applyMethod")
 *                 .applyType("applyType")
 *                 .dataType("dataType")
 *                 .description("description")
 *                 .isModifiable(false)
 *                 .parameterName("parameterName")
 *                 .parameterValue("parameterValue")
 *                 .build()))
 *         .rotateMasterUserPassword(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:57.012Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDatabase")
public class CfnDatabase extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDatabase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDatabase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lightsail.CfnDatabase.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDatabase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lightsail.CfnDatabaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the database (for example, <code>arn:aws:lightsail:us-east-2:123456789101:RelationalDatabase/244ad76f-8aad-4741-809f-12345EXAMPLE</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatabaseArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDatabaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The meaning of this parameter differs according to the database engine you use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMasterDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "masterDatabaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The meaning of this parameter differs according to the database engine you use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterDatabaseName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterDatabaseName", java.util.Objects.requireNonNull(value, "masterDatabaseName is required"));
    }

    /**
     * The name for the primary user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMasterUsername() {
        return software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the primary user.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUsername(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUsername", java.util.Objects.requireNonNull(value, "masterUsername is required"));
    }

    /**
     * The blueprint ID for the database (for example, <code>mysql_8_0</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRelationalDatabaseBlueprintId() {
        return software.amazon.jsii.Kernel.get(this, "relationalDatabaseBlueprintId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The blueprint ID for the database (for example, <code>mysql_8_0</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRelationalDatabaseBlueprintId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "relationalDatabaseBlueprintId", java.util.Objects.requireNonNull(value, "relationalDatabaseBlueprintId is required"));
    }

    /**
     * The bundle ID for the database (for example, <code>medium_1_0</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRelationalDatabaseBundleId() {
        return software.amazon.jsii.Kernel.get(this, "relationalDatabaseBundleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The bundle ID for the database (for example, <code>medium_1_0</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRelationalDatabaseBundleId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "relationalDatabaseBundleId", java.util.Objects.requireNonNull(value, "relationalDatabaseBundleId is required"));
    }

    /**
     * The name of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRelationalDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "relationalDatabaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRelationalDatabaseName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "relationalDatabaseName", java.util.Objects.requireNonNull(value, "relationalDatabaseName is required"));
    }

    /**
     * The Availability Zone for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Availability Zone for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "availabilityZone", value);
    }

    /**
     * A Boolean value indicating whether automated backup retention is enabled for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBackupRetention() {
        return software.amazon.jsii.Kernel.get(this, "backupRetention", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value indicating whether automated backup retention is enabled for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupRetention(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "backupRetention", value);
    }

    /**
     * A Boolean value indicating whether automated backup retention is enabled for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupRetention(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "backupRetention", value);
    }

    /**
     * The certificate associated with the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCaCertificateIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "caCertificateIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The certificate associated with the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCaCertificateIdentifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "caCertificateIdentifier", value);
    }

    /**
     * The password for the primary user of the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The password for the primary user of the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMasterUserPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "masterUserPassword", value);
    }

    /**
     * The daily time range during which automated backups are created for the database (for example, <code>16:00-16:30</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The daily time range during which automated backups are created for the database (for example, <code>16:00-16:30</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredBackupWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredBackupWindow", value);
    }

    /**
     * The weekly time range during which system maintenance can occur for the database, formatted as follows: <code>ddd:hh24:mi-ddd:hh24:mi</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The weekly time range during which system maintenance can occur for the database, formatted as follows: <code>ddd:hh24:mi-ddd:hh24:mi</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * A Boolean value indicating whether the database is accessible to anyone on the internet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value indicating whether the database is accessible to anyone on the internet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * A Boolean value indicating whether the database is accessible to anyone on the internet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * An array of parameters for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRelationalDatabaseParameters() {
        return software.amazon.jsii.Kernel.get(this, "relationalDatabaseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of parameters for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRelationalDatabaseParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "relationalDatabaseParameters", value);
    }

    /**
     * An array of parameters for the database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRelationalDatabaseParameters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lightsail.CfnDatabase.RelationalDatabaseParameterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lightsail.CfnDatabase.RelationalDatabaseParameterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "relationalDatabaseParameters", value);
    }

    /**
     * A Boolean value indicating whether to change the primary user password to a new, strong password generated by Lightsail .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRotateMasterUserPassword() {
        return software.amazon.jsii.Kernel.get(this, "rotateMasterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value indicating whether to change the primary user password to a new, strong password generated by Lightsail .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotateMasterUserPassword(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "rotateMasterUserPassword", value);
    }

    /**
     * A Boolean value indicating whether to change the primary user password to a new, strong password generated by Lightsail .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRotateMasterUserPassword(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rotateMasterUserPassword", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * <code>RelationalDatabaseParameter</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html">AWS::Lightsail::Database</a> resource. It describes parameters for the database.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lightsail.*;
     * RelationalDatabaseParameterProperty relationalDatabaseParameterProperty = RelationalDatabaseParameterProperty.builder()
     *         .allowedValues("allowedValues")
     *         .applyMethod("applyMethod")
     *         .applyType("applyType")
     *         .dataType("dataType")
     *         .description("description")
     *         .isModifiable(false)
     *         .parameterName("parameterName")
     *         .parameterValue("parameterValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDatabase.RelationalDatabaseParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(RelationalDatabaseParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelationalDatabaseParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The valid range of values for the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-allowedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-allowedvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllowedValues() {
            return null;
        }

        /**
         * Indicates when parameter updates are applied.
         * <p>
         * Can be <code>immediate</code> or <code>pending-reboot</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-applymethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-applymethod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplyMethod() {
            return null;
        }

        /**
         * Specifies the engine-specific parameter type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-applytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-applytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplyType() {
            return null;
        }

        /**
         * The valid data type of the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-datatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataType() {
            return null;
        }

        /**
         * A description of the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A Boolean value indicating whether the parameter can be modified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-ismodifiable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-ismodifiable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsModifiable() {
            return null;
        }

        /**
         * The name of the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-parametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-parametername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParameterName() {
            return null;
        }

        /**
         * The value for the parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-parametervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lightsail-database-relationaldatabaseparameter.html#cfn-lightsail-database-relationaldatabaseparameter-parametervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParameterValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelationalDatabaseParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelationalDatabaseParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelationalDatabaseParameterProperty> {
            java.lang.String allowedValues;
            java.lang.String applyMethod;
            java.lang.String applyType;
            java.lang.String dataType;
            java.lang.String description;
            java.lang.Object isModifiable;
            java.lang.String parameterName;
            java.lang.String parameterValue;

            /**
             * Sets the value of {@link RelationalDatabaseParameterProperty#getAllowedValues}
             * @param allowedValues The valid range of values for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedValues(java.lang.String allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            /**
             * Sets the value of {@link RelationalDatabaseParameterProperty#getApplyMethod}
             * @param applyMethod Indicates when parameter updates are applied.
             *                    Can be <code>immediate</code> or <code>pending-reboot</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applyMethod(java.lang.String applyMethod) {
                this.applyMethod = applyMethod;
                return this;
            }

            /**
             * Sets the value of {@link RelationalDatabaseParameterProperty#getApplyType}
             * @param applyType Specifies the engine-specific parameter type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applyType(java.lang.String applyType) {
                this.applyType = applyType;
                return this;
            }

            /**
             * Sets the value of {@link RelationalDatabaseParameterProperty#getDataType}
             * @param dataType The valid data type of the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(java.lang.String dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link RelationalDatabaseParameterProperty#getDescription}
             * @param description A description of the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link RelationalDatabaseParameterProperty#getIsModifiable}
             * @param isModifiable A Boolean value indicating whether the parameter can be modified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isModifiable(java.lang.Boolean isModifiable) {
                this.isModifiable = isModifiable;
                return this;
            }

            /**
             * Sets the value of {@link RelationalDatabaseParameterProperty#getIsModifiable}
             * @param isModifiable A Boolean value indicating whether the parameter can be modified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isModifiable(software.amazon.awscdk.IResolvable isModifiable) {
                this.isModifiable = isModifiable;
                return this;
            }

            /**
             * Sets the value of {@link RelationalDatabaseParameterProperty#getParameterName}
             * @param parameterName The name of the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterName(java.lang.String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            /**
             * Sets the value of {@link RelationalDatabaseParameterProperty#getParameterValue}
             * @param parameterValue The value for the parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterValue(java.lang.String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelationalDatabaseParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelationalDatabaseParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelationalDatabaseParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelationalDatabaseParameterProperty {
            private final java.lang.String allowedValues;
            private final java.lang.String applyMethod;
            private final java.lang.String applyType;
            private final java.lang.String dataType;
            private final java.lang.String description;
            private final java.lang.Object isModifiable;
            private final java.lang.String parameterName;
            private final java.lang.String parameterValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedValues = software.amazon.jsii.Kernel.get(this, "allowedValues", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applyMethod = software.amazon.jsii.Kernel.get(this, "applyMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applyType = software.amazon.jsii.Kernel.get(this, "applyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isModifiable = software.amazon.jsii.Kernel.get(this, "isModifiable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameterValue = software.amazon.jsii.Kernel.get(this, "parameterValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedValues = builder.allowedValues;
                this.applyMethod = builder.applyMethod;
                this.applyType = builder.applyType;
                this.dataType = builder.dataType;
                this.description = builder.description;
                this.isModifiable = builder.isModifiable;
                this.parameterName = builder.parameterName;
                this.parameterValue = builder.parameterValue;
            }

            @Override
            public final java.lang.String getAllowedValues() {
                return this.allowedValues;
            }

            @Override
            public final java.lang.String getApplyMethod() {
                return this.applyMethod;
            }

            @Override
            public final java.lang.String getApplyType() {
                return this.applyType;
            }

            @Override
            public final java.lang.String getDataType() {
                return this.dataType;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getIsModifiable() {
                return this.isModifiable;
            }

            @Override
            public final java.lang.String getParameterName() {
                return this.parameterName;
            }

            @Override
            public final java.lang.String getParameterValue() {
                return this.parameterValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowedValues() != null) {
                    data.set("allowedValues", om.valueToTree(this.getAllowedValues()));
                }
                if (this.getApplyMethod() != null) {
                    data.set("applyMethod", om.valueToTree(this.getApplyMethod()));
                }
                if (this.getApplyType() != null) {
                    data.set("applyType", om.valueToTree(this.getApplyType()));
                }
                if (this.getDataType() != null) {
                    data.set("dataType", om.valueToTree(this.getDataType()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getIsModifiable() != null) {
                    data.set("isModifiable", om.valueToTree(this.getIsModifiable()));
                }
                if (this.getParameterName() != null) {
                    data.set("parameterName", om.valueToTree(this.getParameterName()));
                }
                if (this.getParameterValue() != null) {
                    data.set("parameterValue", om.valueToTree(this.getParameterValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnDatabase.RelationalDatabaseParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelationalDatabaseParameterProperty.Jsii$Proxy that = (RelationalDatabaseParameterProperty.Jsii$Proxy) o;

                if (this.allowedValues != null ? !this.allowedValues.equals(that.allowedValues) : that.allowedValues != null) return false;
                if (this.applyMethod != null ? !this.applyMethod.equals(that.applyMethod) : that.applyMethod != null) return false;
                if (this.applyType != null ? !this.applyType.equals(that.applyType) : that.applyType != null) return false;
                if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.isModifiable != null ? !this.isModifiable.equals(that.isModifiable) : that.isModifiable != null) return false;
                if (this.parameterName != null ? !this.parameterName.equals(that.parameterName) : that.parameterName != null) return false;
                return this.parameterValue != null ? this.parameterValue.equals(that.parameterValue) : that.parameterValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedValues != null ? this.allowedValues.hashCode() : 0;
                result = 31 * result + (this.applyMethod != null ? this.applyMethod.hashCode() : 0);
                result = 31 * result + (this.applyType != null ? this.applyType.hashCode() : 0);
                result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.isModifiable != null ? this.isModifiable.hashCode() : 0);
                result = 31 * result + (this.parameterName != null ? this.parameterName.hashCode() : 0);
                result = 31 * result + (this.parameterValue != null ? this.parameterValue.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lightsail.CfnDatabase}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lightsail.CfnDatabase> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lightsail.CfnDatabaseProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lightsail.CfnDatabaseProps.Builder();
        }

        /**
         * The meaning of this parameter differs according to the database engine you use.
         * <p>
         * <em>MySQL</em>
         * <p>
         * The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, no database is created in the database resource.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain 1-64 letters or numbers.</li>
         * <li>Must begin with a letter. Subsequent characters can be letters, underscores, or numbers (0-9).</li>
         * <li>Can't be a word reserved by the specified database engine.</li>
         * </ul>
         * <p>
         * For more information about reserved words in MySQL, see the Keywords and Reserved Words articles for <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a> , <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a> , and <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a> .
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, a database named <code>postgres</code> is created in the database resource.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Must contain 1-63 letters or numbers.</li>
         * <li>Must begin with a letter. Subsequent characters can be letters, underscores, or numbers (0-9).</li>
         * <li>Can't be a word reserved by the specified database engine.</li>
         * </ul>
         * <p>
         * For more information about reserved words in PostgreSQL, see the SQL Key Words articles for <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a> , and <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL 12</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masterdatabasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masterdatabasename</a>
         * @param masterDatabaseName The meaning of this parameter differs according to the database engine you use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterDatabaseName(final java.lang.String masterDatabaseName) {
            this.props.masterDatabaseName(masterDatabaseName);
            return this;
        }

        /**
         * The name for the primary user.
         * <p>
         * <em>MySQL</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Required for MySQL.</li>
         * <li>Must be 1-16 letters or numbers. Can contain underscores.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a> , <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a> , or <a href="https://docs.aws.amazon.com/https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a> .
         * <p>
         * <em>PostgreSQL</em>
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>Required for PostgreSQL.</li>
         * <li>Must be 1-63 letters or numbers. Can contain underscores.</li>
         * <li>First character must be a letter.</li>
         * <li>Can't be a reserved word for the chosen database engine.</li>
         * </ul>
         * <p>
         * For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a> , <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a> , and <a href="https://docs.aws.amazon.com/https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL 12</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masterusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masterusername</a>
         * @param masterUsername The name for the primary user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(final java.lang.String masterUsername) {
            this.props.masterUsername(masterUsername);
            return this;
        }

        /**
         * The blueprint ID for the database (for example, <code>mysql_8_0</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabaseblueprintid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabaseblueprintid</a>
         * @param relationalDatabaseBlueprintId The blueprint ID for the database (for example, <code>mysql_8_0</code> ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseBlueprintId(final java.lang.String relationalDatabaseBlueprintId) {
            this.props.relationalDatabaseBlueprintId(relationalDatabaseBlueprintId);
            return this;
        }

        /**
         * The bundle ID for the database (for example, <code>medium_1_0</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabasebundleid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabasebundleid</a>
         * @param relationalDatabaseBundleId The bundle ID for the database (for example, <code>medium_1_0</code> ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseBundleId(final java.lang.String relationalDatabaseBundleId) {
            this.props.relationalDatabaseBundleId(relationalDatabaseBundleId);
            return this;
        }

        /**
         * The name of the instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabasename</a>
         * @param relationalDatabaseName The name of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseName(final java.lang.String relationalDatabaseName) {
            this.props.relationalDatabaseName(relationalDatabaseName);
            return this;
        }

        /**
         * The Availability Zone for the database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-availabilityzone</a>
         * @param availabilityZone The Availability Zone for the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * A Boolean value indicating whether automated backup retention is enabled for the database.
         * <p>
         * Data Import Mode is enabled when <code>BackupRetention</code> is set to <code>false</code> , and is disabled when <code>BackupRetention</code> is set to <code>true</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-backupretention">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-backupretention</a>
         * @param backupRetention A Boolean value indicating whether automated backup retention is enabled for the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetention(final java.lang.Boolean backupRetention) {
            this.props.backupRetention(backupRetention);
            return this;
        }
        /**
         * A Boolean value indicating whether automated backup retention is enabled for the database.
         * <p>
         * Data Import Mode is enabled when <code>BackupRetention</code> is set to <code>false</code> , and is disabled when <code>BackupRetention</code> is set to <code>true</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-backupretention">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-backupretention</a>
         * @param backupRetention A Boolean value indicating whether automated backup retention is enabled for the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetention(final software.amazon.awscdk.IResolvable backupRetention) {
            this.props.backupRetention(backupRetention);
            return this;
        }

        /**
         * The certificate associated with the database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-cacertificateidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-cacertificateidentifier</a>
         * @param caCertificateIdentifier The certificate associated with the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caCertificateIdentifier(final java.lang.String caCertificateIdentifier) {
            this.props.caCertificateIdentifier(caCertificateIdentifier);
            return this;
        }

        /**
         * The password for the primary user of the database.
         * <p>
         * The password can include any printable ASCII character except the following: /, ", or
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-masteruserpassword</a>
         * @param masterUserPassword The password for the primary user of the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(final java.lang.String masterUserPassword) {
            this.props.masterUserPassword(masterUserPassword);
            return this;
        }

        /**
         * The daily time range during which automated backups are created for the database (for example, <code>16:00-16:30</code> ).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-preferredbackupwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-preferredbackupwindow</a>
         * @param preferredBackupWindow The daily time range during which automated backups are created for the database (for example, <code>16:00-16:30</code> ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(final java.lang.String preferredBackupWindow) {
            this.props.preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        /**
         * The weekly time range during which system maintenance can occur for the database, formatted as follows: <code>ddd:hh24:mi-ddd:hh24:mi</code> .
         * <p>
         * For example, <code>Tue:17:00-Tue:17:30</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-preferredmaintenancewindow</a>
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur for the database, formatted as follows: <code>ddd:hh24:mi-ddd:hh24:mi</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * A Boolean value indicating whether the database is accessible to anyone on the internet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-publiclyaccessible</a>
         * @param publiclyAccessible A Boolean value indicating whether the database is accessible to anyone on the internet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final java.lang.Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }
        /**
         * A Boolean value indicating whether the database is accessible to anyone on the internet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-publiclyaccessible</a>
         * @param publiclyAccessible A Boolean value indicating whether the database is accessible to anyone on the internet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        /**
         * An array of parameters for the database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabaseparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabaseparameters</a>
         * @param relationalDatabaseParameters An array of parameters for the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseParameters(final software.amazon.awscdk.IResolvable relationalDatabaseParameters) {
            this.props.relationalDatabaseParameters(relationalDatabaseParameters);
            return this;
        }
        /**
         * An array of parameters for the database.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabaseparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-relationaldatabaseparameters</a>
         * @param relationalDatabaseParameters An array of parameters for the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relationalDatabaseParameters(final java.util.List<? extends java.lang.Object> relationalDatabaseParameters) {
            this.props.relationalDatabaseParameters(relationalDatabaseParameters);
            return this;
        }

        /**
         * A Boolean value indicating whether to change the primary user password to a new, strong password generated by Lightsail .
         * <p>
         * <blockquote>
         * <p>
         * The <code>RotateMasterUserPassword</code> and <code>MasterUserPassword</code> parameters cannot be used together in the same template.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-rotatemasteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-rotatemasteruserpassword</a>
         * @param rotateMasterUserPassword A Boolean value indicating whether to change the primary user password to a new, strong password generated by Lightsail . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateMasterUserPassword(final java.lang.Boolean rotateMasterUserPassword) {
            this.props.rotateMasterUserPassword(rotateMasterUserPassword);
            return this;
        }
        /**
         * A Boolean value indicating whether to change the primary user password to a new, strong password generated by Lightsail .
         * <p>
         * <blockquote>
         * <p>
         * The <code>RotateMasterUserPassword</code> and <code>MasterUserPassword</code> parameters cannot be used together in the same template.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-rotatemasteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-rotatemasteruserpassword</a>
         * @param rotateMasterUserPassword A Boolean value indicating whether to change the primary user password to a new, strong password generated by Lightsail . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rotateMasterUserPassword(final software.amazon.awscdk.IResolvable rotateMasterUserPassword) {
            this.props.rotateMasterUserPassword(rotateMasterUserPassword);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-database.html#cfn-lightsail-database-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lightsail.CfnDatabase}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lightsail.CfnDatabase build() {
            return new software.amazon.awscdk.services.lightsail.CfnDatabase(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
