package software.amazon.awscdk.services.lightsail;

/**
 * Properties for defining a <code>CfnDistribution</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnDistributionProps cfnDistributionProps = CfnDistributionProps.builder()
 *         .bundleId("bundleId")
 *         .defaultCacheBehavior(CacheBehaviorProperty.builder()
 *                 .behavior("behavior")
 *                 .build())
 *         .distributionName("distributionName")
 *         .origin(InputOriginProperty.builder()
 *                 .name("name")
 *                 .protocolPolicy("protocolPolicy")
 *                 .regionName("regionName")
 *                 .build())
 *         // the properties below are optional
 *         .cacheBehaviors(List.of(CacheBehaviorPerPathProperty.builder()
 *                 .behavior("behavior")
 *                 .path("path")
 *                 .build()))
 *         .cacheBehaviorSettings(CacheSettingsProperty.builder()
 *                 .allowedHttpMethods("allowedHttpMethods")
 *                 .cachedHttpMethods("cachedHttpMethods")
 *                 .defaultTtl(123)
 *                 .forwardedCookies(CookieObjectProperty.builder()
 *                         .cookiesAllowList(List.of("cookiesAllowList"))
 *                         .option("option")
 *                         .build())
 *                 .forwardedHeaders(HeaderObjectProperty.builder()
 *                         .headersAllowList(List.of("headersAllowList"))
 *                         .option("option")
 *                         .build())
 *                 .forwardedQueryStrings(QueryStringObjectProperty.builder()
 *                         .option(false)
 *                         .queryStringsAllowList(List.of("queryStringsAllowList"))
 *                         .build())
 *                 .maximumTtl(123)
 *                 .minimumTtl(123)
 *                 .build())
 *         .certificateName("certificateName")
 *         .ipAddressType("ipAddressType")
 *         .isEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:57.039Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnDistributionProps")
@software.amazon.jsii.Jsii.Proxy(CfnDistributionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDistributionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the bundle applied to the distribution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-bundleid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-bundleid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBundleId();

    /**
     * An object that describes the default cache behavior of the distribution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-defaultcachebehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-defaultcachebehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDefaultCacheBehavior();

    /**
     * The name of the distribution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-distributionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-distributionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDistributionName();

    /**
     * An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer.
     * <p>
     * The distribution pulls, caches, and serves content from the origin.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-origin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-origin</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getOrigin();

    /**
     * An array of objects that describe the per-path cache behavior of the distribution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCacheBehaviors() {
        return null;
    }

    /**
     * An object that describes the cache behavior settings of the distribution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviorsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-cachebehaviorsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCacheBehaviorSettings() {
        return null;
    }

    /**
     * The name of the SSL/TLS certificate attached to the distribution.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-certificatename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-certificatename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCertificateName() {
        return null;
    }

    /**
     * The IP address type of the distribution.
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-ipaddresstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return null;
    }

    /**
     * A Boolean value indicating whether the distribution is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-isenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-isenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsEnabled() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-distribution.html#cfn-lightsail-distribution-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDistributionProps> {
        java.lang.String bundleId;
        java.lang.Object defaultCacheBehavior;
        java.lang.String distributionName;
        java.lang.Object origin;
        java.lang.Object cacheBehaviors;
        java.lang.Object cacheBehaviorSettings;
        java.lang.String certificateName;
        java.lang.String ipAddressType;
        java.lang.Object isEnabled;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDistributionProps#getBundleId}
         * @param bundleId The ID of the bundle applied to the distribution. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundleId(java.lang.String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getDefaultCacheBehavior}
         * @param defaultCacheBehavior An object that describes the default cache behavior of the distribution. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCacheBehavior(software.amazon.awscdk.IResolvable defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getDefaultCacheBehavior}
         * @param defaultCacheBehavior An object that describes the default cache behavior of the distribution. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCacheBehavior(software.amazon.awscdk.services.lightsail.CfnDistribution.CacheBehaviorProperty defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getDistributionName}
         * @param distributionName The name of the distribution. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionName(java.lang.String distributionName) {
            this.distributionName = distributionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getOrigin}
         * @param origin An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. This parameter is required.
         *               The distribution pulls, caches, and serves content from the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder origin(software.amazon.awscdk.IResolvable origin) {
            this.origin = origin;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getOrigin}
         * @param origin An object that describes the origin resource of the distribution, such as a Lightsail instance, bucket, or load balancer. This parameter is required.
         *               The distribution pulls, caches, and serves content from the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder origin(software.amazon.awscdk.services.lightsail.CfnDistribution.InputOriginProperty origin) {
            this.origin = origin;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getCacheBehaviors}
         * @param cacheBehaviors An array of objects that describe the per-path cache behavior of the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheBehaviors(software.amazon.awscdk.IResolvable cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getCacheBehaviors}
         * @param cacheBehaviors An array of objects that describe the per-path cache behavior of the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheBehaviors(java.util.List<? extends java.lang.Object> cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getCacheBehaviorSettings}
         * @param cacheBehaviorSettings An object that describes the cache behavior settings of the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheBehaviorSettings(software.amazon.awscdk.IResolvable cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getCacheBehaviorSettings}
         * @param cacheBehaviorSettings An object that describes the cache behavior settings of the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheBehaviorSettings(software.amazon.awscdk.services.lightsail.CfnDistribution.CacheSettingsProperty cacheBehaviorSettings) {
            this.cacheBehaviorSettings = cacheBehaviorSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getCertificateName}
         * @param certificateName The name of the SSL/TLS certificate attached to the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateName(java.lang.String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getIpAddressType}
         * @param ipAddressType The IP address type of the distribution.
         *                      The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(java.lang.String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getIsEnabled}
         * @param isEnabled A Boolean value indicating whether the distribution is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isEnabled(java.lang.Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getIsEnabled}
         * @param isEnabled A Boolean value indicating whether the distribution is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isEnabled(software.amazon.awscdk.IResolvable isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnDistributionProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         *             <p>
         *             <blockquote>
         *             <p>
         *             The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDistributionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDistributionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDistributionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDistributionProps {
        private final java.lang.String bundleId;
        private final java.lang.Object defaultCacheBehavior;
        private final java.lang.String distributionName;
        private final java.lang.Object origin;
        private final java.lang.Object cacheBehaviors;
        private final java.lang.Object cacheBehaviorSettings;
        private final java.lang.String certificateName;
        private final java.lang.String ipAddressType;
        private final java.lang.Object isEnabled;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bundleId = software.amazon.jsii.Kernel.get(this, "bundleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultCacheBehavior = software.amazon.jsii.Kernel.get(this, "defaultCacheBehavior", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.distributionName = software.amazon.jsii.Kernel.get(this, "distributionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.origin = software.amazon.jsii.Kernel.get(this, "origin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cacheBehaviors = software.amazon.jsii.Kernel.get(this, "cacheBehaviors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cacheBehaviorSettings = software.amazon.jsii.Kernel.get(this, "cacheBehaviorSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.certificateName = software.amazon.jsii.Kernel.get(this, "certificateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.isEnabled = software.amazon.jsii.Kernel.get(this, "isEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bundleId = java.util.Objects.requireNonNull(builder.bundleId, "bundleId is required");
            this.defaultCacheBehavior = java.util.Objects.requireNonNull(builder.defaultCacheBehavior, "defaultCacheBehavior is required");
            this.distributionName = java.util.Objects.requireNonNull(builder.distributionName, "distributionName is required");
            this.origin = java.util.Objects.requireNonNull(builder.origin, "origin is required");
            this.cacheBehaviors = builder.cacheBehaviors;
            this.cacheBehaviorSettings = builder.cacheBehaviorSettings;
            this.certificateName = builder.certificateName;
            this.ipAddressType = builder.ipAddressType;
            this.isEnabled = builder.isEnabled;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final java.lang.Object getDefaultCacheBehavior() {
            return this.defaultCacheBehavior;
        }

        @Override
        public final java.lang.String getDistributionName() {
            return this.distributionName;
        }

        @Override
        public final java.lang.Object getOrigin() {
            return this.origin;
        }

        @Override
        public final java.lang.Object getCacheBehaviors() {
            return this.cacheBehaviors;
        }

        @Override
        public final java.lang.Object getCacheBehaviorSettings() {
            return this.cacheBehaviorSettings;
        }

        @Override
        public final java.lang.String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final java.lang.String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.Object getIsEnabled() {
            return this.isEnabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bundleId", om.valueToTree(this.getBundleId()));
            data.set("defaultCacheBehavior", om.valueToTree(this.getDefaultCacheBehavior()));
            data.set("distributionName", om.valueToTree(this.getDistributionName()));
            data.set("origin", om.valueToTree(this.getOrigin()));
            if (this.getCacheBehaviors() != null) {
                data.set("cacheBehaviors", om.valueToTree(this.getCacheBehaviors()));
            }
            if (this.getCacheBehaviorSettings() != null) {
                data.set("cacheBehaviorSettings", om.valueToTree(this.getCacheBehaviorSettings()));
            }
            if (this.getCertificateName() != null) {
                data.set("certificateName", om.valueToTree(this.getCertificateName()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getIsEnabled() != null) {
                data.set("isEnabled", om.valueToTree(this.getIsEnabled()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnDistributionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDistributionProps.Jsii$Proxy that = (CfnDistributionProps.Jsii$Proxy) o;

            if (!bundleId.equals(that.bundleId)) return false;
            if (!defaultCacheBehavior.equals(that.defaultCacheBehavior)) return false;
            if (!distributionName.equals(that.distributionName)) return false;
            if (!origin.equals(that.origin)) return false;
            if (this.cacheBehaviors != null ? !this.cacheBehaviors.equals(that.cacheBehaviors) : that.cacheBehaviors != null) return false;
            if (this.cacheBehaviorSettings != null ? !this.cacheBehaviorSettings.equals(that.cacheBehaviorSettings) : that.cacheBehaviorSettings != null) return false;
            if (this.certificateName != null ? !this.certificateName.equals(that.certificateName) : that.certificateName != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.isEnabled != null ? !this.isEnabled.equals(that.isEnabled) : that.isEnabled != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bundleId.hashCode();
            result = 31 * result + (this.defaultCacheBehavior.hashCode());
            result = 31 * result + (this.distributionName.hashCode());
            result = 31 * result + (this.origin.hashCode());
            result = 31 * result + (this.cacheBehaviors != null ? this.cacheBehaviors.hashCode() : 0);
            result = 31 * result + (this.cacheBehaviorSettings != null ? this.cacheBehaviorSettings.hashCode() : 0);
            result = 31 * result + (this.certificateName != null ? this.certificateName.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.isEnabled != null ? this.isEnabled.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
