package software.amazon.awscdk.services.mediaconnect;

/**
 * The AWS::MediaConnect::FlowEntitlement resource defines the permission that an AWS account grants to another AWS account to allow access to the content in a specific AWS Elemental MediaConnect flow.
 * <p>
 * The content originator grants an entitlement to a specific AWS account (the subscriber). When an entitlement is granted, the subscriber can create a flow using the originator's flow as the source. Each flow can have up to 50 entitlements.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * CfnFlowEntitlement cfnFlowEntitlement = CfnFlowEntitlement.Builder.create(this, "MyCfnFlowEntitlement")
 *         .description("description")
 *         .flowArn("flowArn")
 *         .name("name")
 *         .subscribers(List.of("subscribers"))
 *         // the properties below are optional
 *         .dataTransferSubscriberFeePercent(123)
 *         .encryption(EncryptionProperty.builder()
 *                 .algorithm("algorithm")
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .constantInitializationVector("constantInitializationVector")
 *                 .deviceId("deviceId")
 *                 .keyType("keyType")
 *                 .region("region")
 *                 .resourceId("resourceId")
 *                 .secretArn("secretArn")
 *                 .url("url")
 *                 .build())
 *         .entitlementStatus("entitlementStatus")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:57.282Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowEntitlement")
public class CfnFlowEntitlement extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFlowEntitlement(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowEntitlement(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlement.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlowEntitlement(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlementProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The entitlement ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEntitlementArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEntitlementArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A description of the entitlement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the entitlement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFlowArn() {
        return software.amazon.jsii.Kernel.get(this, "flowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlowArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "flowArn", java.util.Objects.requireNonNull(value, "flowArn is required"));
    }

    /**
     * The name of the entitlement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the entitlement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The AWS account IDs that you want to share your content with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubscribers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "subscribers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The AWS account IDs that you want to share your content with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubscribers(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subscribers", java.util.Objects.requireNonNull(value, "subscribers is required"));
    }

    /**
     * The percentage of the entitlement data transfer fee that you want the subscriber to be responsible for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDataTransferSubscriberFeePercent() {
        return software.amazon.jsii.Kernel.get(this, "dataTransferSubscriberFeePercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The percentage of the entitlement data transfer fee that you want the subscriber to be responsible for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataTransferSubscriberFeePercent(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "dataTransferSubscriberFeePercent", value);
    }

    /**
     * The type of encryption that MediaConnect will use on the output that is associated with the entitlement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
        return software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The type of encryption that MediaConnect will use on the output that is associated with the entitlement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryption", value);
    }

    /**
     * The type of encryption that MediaConnect will use on the output that is associated with the entitlement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryption(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlement.EncryptionProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryption", value);
    }

    /**
     * An indication of whether the new entitlement should be enabled or disabled as soon as it is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEntitlementStatus() {
        return software.amazon.jsii.Kernel.get(this, "entitlementStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An indication of whether the new entitlement should be enabled or disabled as soon as it is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEntitlementStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "entitlementStatus", value);
    }
    /**
     * Information about the encryption of the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediaconnect.*;
     * EncryptionProperty encryptionProperty = EncryptionProperty.builder()
     *         .algorithm("algorithm")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .constantInitializationVector("constantInitializationVector")
     *         .deviceId("deviceId")
     *         .keyType("keyType")
     *         .region("region")
     *         .resourceId("resourceId")
     *         .secretArn("secretArn")
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconnect.CfnFlowEntitlement.EncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of algorithm that is used for static key encryption (such as aes128, aes192, or aes256).
         * <p>
         * If you are using SPEKE or SRT-password encryption, this property must be left blank.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-algorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-algorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlgorithm();

        /**
         * The Amazon Resource Name (ARN) of the role that you created during setup (when you set up MediaConnect as a trusted entity).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content.
         * <p>
         * This parameter is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-constantinitializationvector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-constantinitializationvector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantInitializationVector() {
            return null;
        }

        /**
         * The value of one of the devices that you configured with your digital rights management (DRM) platform key provider.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-deviceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-deviceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeviceId() {
            return null;
        }

        /**
         * The type of key that is used for the encryption.
         * <p>
         * If you don't specify a <code>keyType</code> value, the service uses the default setting ( <code>static-key</code> ). Valid key types are: <code>static-key</code> , <code>speke</code> , and <code>srt-password</code> .
         * <p>
         * Default: - "static-key"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-keytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-keytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyType() {
            return null;
        }

        /**
         * The AWS Region that the API Gateway proxy endpoint was created in.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * An identifier for the content.
         * <p>
         * The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceId() {
            return null;
        }

        /**
         * The ARN of the secret that you created in AWS Secrets Manager to store the encryption key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * The URL from the API Gateway proxy that you set up to talk to your key server.
         * <p>
         * This parameter is required for SPEKE encryption and is not valid for static key encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flowentitlement-encryption.html#cfn-mediaconnect-flowentitlement-encryption-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionProperty> {
            java.lang.String algorithm;
            java.lang.String roleArn;
            java.lang.String constantInitializationVector;
            java.lang.String deviceId;
            java.lang.String keyType;
            java.lang.String region;
            java.lang.String resourceId;
            java.lang.String secretArn;
            java.lang.String url;

            /**
             * Sets the value of {@link EncryptionProperty#getAlgorithm}
             * @param algorithm The type of algorithm that is used for static key encryption (such as aes128, aes192, or aes256). This parameter is required.
             *                  If you are using SPEKE or SRT-password encryption, this property must be left blank.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder algorithm(java.lang.String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the role that you created during setup (when you set up MediaConnect as a trusted entity). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getConstantInitializationVector}
             * @param constantInitializationVector A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content.
             *                                     This parameter is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantInitializationVector(java.lang.String constantInitializationVector) {
                this.constantInitializationVector = constantInitializationVector;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getDeviceId}
             * @param deviceId The value of one of the devices that you configured with your digital rights management (DRM) platform key provider.
             *                 This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deviceId(java.lang.String deviceId) {
                this.deviceId = deviceId;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getKeyType}
             * @param keyType The type of key that is used for the encryption.
             *                If you don't specify a <code>keyType</code> value, the service uses the default setting ( <code>static-key</code> ). Valid key types are: <code>static-key</code> , <code>speke</code> , and <code>srt-password</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyType(java.lang.String keyType) {
                this.keyType = keyType;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getRegion}
             * @param region The AWS Region that the API Gateway proxy endpoint was created in.
             *               This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getResourceId}
             * @param resourceId An identifier for the content.
             *                   The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getSecretArn}
             * @param secretArn The ARN of the secret that you created in AWS Secrets Manager to store the encryption key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionProperty#getUrl}
             * @param url The URL from the API Gateway proxy that you set up to talk to your key server.
             *            This parameter is required for SPEKE encryption and is not valid for static key encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionProperty {
            private final java.lang.String algorithm;
            private final java.lang.String roleArn;
            private final java.lang.String constantInitializationVector;
            private final java.lang.String deviceId;
            private final java.lang.String keyType;
            private final java.lang.String region;
            private final java.lang.String resourceId;
            private final java.lang.String secretArn;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.algorithm = software.amazon.jsii.Kernel.get(this, "algorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.constantInitializationVector = software.amazon.jsii.Kernel.get(this, "constantInitializationVector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deviceId = software.amazon.jsii.Kernel.get(this, "deviceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyType = software.amazon.jsii.Kernel.get(this, "keyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.algorithm = java.util.Objects.requireNonNull(builder.algorithm, "algorithm is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.constantInitializationVector = builder.constantInitializationVector;
                this.deviceId = builder.deviceId;
                this.keyType = builder.keyType;
                this.region = builder.region;
                this.resourceId = builder.resourceId;
                this.secretArn = builder.secretArn;
                this.url = builder.url;
            }

            @Override
            public final java.lang.String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getConstantInitializationVector() {
                return this.constantInitializationVector;
            }

            @Override
            public final java.lang.String getDeviceId() {
                return this.deviceId;
            }

            @Override
            public final java.lang.String getKeyType() {
                return this.keyType;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("algorithm", om.valueToTree(this.getAlgorithm()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getConstantInitializationVector() != null) {
                    data.set("constantInitializationVector", om.valueToTree(this.getConstantInitializationVector()));
                }
                if (this.getDeviceId() != null) {
                    data.set("deviceId", om.valueToTree(this.getDeviceId()));
                }
                if (this.getKeyType() != null) {
                    data.set("keyType", om.valueToTree(this.getKeyType()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getResourceId() != null) {
                    data.set("resourceId", om.valueToTree(this.getResourceId()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconnect.CfnFlowEntitlement.EncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionProperty.Jsii$Proxy that = (EncryptionProperty.Jsii$Proxy) o;

                if (!algorithm.equals(that.algorithm)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.constantInitializationVector != null ? !this.constantInitializationVector.equals(that.constantInitializationVector) : that.constantInitializationVector != null) return false;
                if (this.deviceId != null ? !this.deviceId.equals(that.deviceId) : that.deviceId != null) return false;
                if (this.keyType != null ? !this.keyType.equals(that.keyType) : that.keyType != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) return false;
                if (this.secretArn != null ? !this.secretArn.equals(that.secretArn) : that.secretArn != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.algorithm.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.constantInitializationVector != null ? this.constantInitializationVector.hashCode() : 0);
                result = 31 * result + (this.deviceId != null ? this.deviceId.hashCode() : 0);
                result = 31 * result + (this.keyType != null ? this.keyType.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlement}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlement> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlementProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlementProps.Builder();
        }

        /**
         * A description of the entitlement.
         * <p>
         * This description appears only on the MediaConnect console and is not visible outside of the current AWS account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-description</a>
         * @param description A description of the entitlement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-flowarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-flowarn</a>
         * @param flowArn The Amazon Resource Name (ARN) of the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowArn(final java.lang.String flowArn) {
            this.props.flowArn(flowArn);
            return this;
        }

        /**
         * The name of the entitlement.
         * <p>
         * This value must be unique within the current flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-name</a>
         * @param name The name of the entitlement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The AWS account IDs that you want to share your content with.
         * <p>
         * The receiving accounts (subscribers) will be allowed to create their own flows using your content as the source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-subscribers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-subscribers</a>
         * @param subscribers The AWS account IDs that you want to share your content with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribers(final java.util.List<java.lang.String> subscribers) {
            this.props.subscribers(subscribers);
            return this;
        }

        /**
         * The percentage of the entitlement data transfer fee that you want the subscriber to be responsible for.
         * <p>
         * Default: - 0
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-datatransfersubscriberfeepercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-datatransfersubscriberfeepercent</a>
         * @param dataTransferSubscriberFeePercent The percentage of the entitlement data transfer fee that you want the subscriber to be responsible for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataTransferSubscriberFeePercent(final java.lang.Number dataTransferSubscriberFeePercent) {
            this.props.dataTransferSubscriberFeePercent(dataTransferSubscriberFeePercent);
            return this;
        }

        /**
         * The type of encryption that MediaConnect will use on the output that is associated with the entitlement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-encryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-encryption</a>
         * @param encryption The type of encryption that MediaConnect will use on the output that is associated with the entitlement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.IResolvable encryption) {
            this.props.encryption(encryption);
            return this;
        }
        /**
         * The type of encryption that MediaConnect will use on the output that is associated with the entitlement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-encryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-encryption</a>
         * @param encryption The type of encryption that MediaConnect will use on the output that is associated with the entitlement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlement.EncryptionProperty encryption) {
            this.props.encryption(encryption);
            return this;
        }

        /**
         * An indication of whether the new entitlement should be enabled or disabled as soon as it is created.
         * <p>
         * If you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-entitlementstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconnect-flowentitlement.html#cfn-mediaconnect-flowentitlement-entitlementstatus</a>
         * @param entitlementStatus An indication of whether the new entitlement should be enabled or disabled as soon as it is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entitlementStatus(final java.lang.String entitlementStatus) {
            this.props.entitlementStatus(entitlementStatus);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlement}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlement build() {
            return new software.amazon.awscdk.services.mediaconnect.CfnFlowEntitlement(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
