package software.amazon.awscdk.services.mediaconvert;

/**
 * Properties for defining a <code>CfnJobTemplate</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconvert.*;
 * Object settingsJson;
 * Object tags;
 * CfnJobTemplateProps cfnJobTemplateProps = CfnJobTemplateProps.builder()
 *         .settingsJson(settingsJson)
 *         // the properties below are optional
 *         .accelerationSettings(AccelerationSettingsProperty.builder()
 *                 .mode("mode")
 *                 .build())
 *         .category("category")
 *         .description("description")
 *         .hopDestinations(List.of(HopDestinationProperty.builder()
 *                 .priority(123)
 *                 .queue("queue")
 *                 .waitMinutes(123)
 *                 .build()))
 *         .name("name")
 *         .priority(123)
 *         .queue("queue")
 *         .statusUpdateInterval("statusUpdateInterval")
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:15:57.314Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediaconvert.CfnJobTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnJobTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnJobTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specify, in JSON format, the transcoding job settings for this job template.
     * <p>
     * This specification must conform to the AWS Elemental MediaConvert job validation. For information about forming this specification, see the Remarks section later in this topic.
     * <p>
     * For more information about MediaConvert job templates, see <a href="https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-job-templates.html">Working with AWS Elemental MediaConvert Job Templates</a> in the ** .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-settingsjson">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-settingsjson</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSettingsJson();

    /**
     * Accelerated transcoding can significantly speed up jobs with long, visually complex content.
     * <p>
     * Outputs that use this feature incur pro-tier pricing. For information about feature limitations, For more information, see <a href="https://docs.aws.amazon.com/mediaconvert/latest/ug/job-requirements.html">Job Limitations for Accelerated Transcoding in AWS Elemental MediaConvert</a> in the <em>AWS Elemental MediaConvert User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-accelerationsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-accelerationsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccelerationSettings() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * A category for the job template you are creating
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-category</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCategory() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * A description of the job template you are creating.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * Configuration for a destination queue to which the job can hop once a customer-defined minimum wait time has passed. For more information, see <a href="https://docs.aws.amazon.com/mediaconvert/latest/ug/setting-up-queue-hopping-to-avoid-long-waits.html">Setting Up Queue Hopping to Avoid Long Waits</a> in the <em>AWS Elemental MediaConvert User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-hopdestinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-hopdestinations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHopDestinations() {
        return null;
    }

    /**
     * Name of the output group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Specify the relative priority for this job.
     * <p>
     * In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0. Minimum: -50 Maximum: 50
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-priority</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
        return null;
    }

    /**
     * Optional.
     * <p>
     * The queue that jobs created from this template are assigned to. Specify the Amazon Resource Name (ARN) of the queue. For example, arn:aws:mediaconvert:us-west-2:505474453218:queues/Default. If you don't specify this, jobs will go to the default queue.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-queue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-queue</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getQueue() {
        return null;
    }

    /**
     * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events.
     * <p>
     * Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
     * <p>
     * Specify one of the following enums:
     * <p>
     * SECONDS_10
     * <p>
     * SECONDS_12
     * <p>
     * SECONDS_15
     * <p>
     * SECONDS_20
     * <p>
     * SECONDS_30
     * <p>
     * SECONDS_60
     * <p>
     * SECONDS_120
     * <p>
     * SECONDS_180
     * <p>
     * SECONDS_240
     * <p>
     * SECONDS_300
     * <p>
     * SECONDS_360
     * <p>
     * SECONDS_420
     * <p>
     * SECONDS_480
     * <p>
     * SECONDS_540
     * <p>
     * SECONDS_600
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-statusupdateinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-statusupdateinterval</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatusUpdateInterval() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediaconvert-jobtemplate.html#cfn-mediaconvert-jobtemplate-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnJobTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnJobTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnJobTemplateProps> {
        java.lang.Object settingsJson;
        java.lang.Object accelerationSettings;
        java.lang.String category;
        java.lang.String description;
        java.lang.Object hopDestinations;
        java.lang.String name;
        java.lang.Number priority;
        java.lang.String queue;
        java.lang.String statusUpdateInterval;
        java.lang.Object tags;

        /**
         * Sets the value of {@link CfnJobTemplateProps#getSettingsJson}
         * @param settingsJson Specify, in JSON format, the transcoding job settings for this job template. This parameter is required.
         *                     This specification must conform to the AWS Elemental MediaConvert job validation. For information about forming this specification, see the Remarks section later in this topic.
         *                     <p>
         *                     For more information about MediaConvert job templates, see <a href="https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-job-templates.html">Working with AWS Elemental MediaConvert Job Templates</a> in the ** .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settingsJson(java.lang.Object settingsJson) {
            this.settingsJson = settingsJson;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getAccelerationSettings}
         * @param accelerationSettings Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         *                             Outputs that use this feature incur pro-tier pricing. For information about feature limitations, For more information, see <a href="https://docs.aws.amazon.com/mediaconvert/latest/ug/job-requirements.html">Job Limitations for Accelerated Transcoding in AWS Elemental MediaConvert</a> in the <em>AWS Elemental MediaConvert User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerationSettings(software.amazon.awscdk.IResolvable accelerationSettings) {
            this.accelerationSettings = accelerationSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getAccelerationSettings}
         * @param accelerationSettings Accelerated transcoding can significantly speed up jobs with long, visually complex content.
         *                             Outputs that use this feature incur pro-tier pricing. For information about feature limitations, For more information, see <a href="https://docs.aws.amazon.com/mediaconvert/latest/ug/job-requirements.html">Job Limitations for Accelerated Transcoding in AWS Elemental MediaConvert</a> in the <em>AWS Elemental MediaConvert User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accelerationSettings(software.amazon.awscdk.services.mediaconvert.CfnJobTemplate.AccelerationSettingsProperty accelerationSettings) {
            this.accelerationSettings = accelerationSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getCategory}
         * @param category Optional.
         *                 A category for the job template you are creating
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder category(java.lang.String category) {
            this.category = category;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getDescription}
         * @param description Optional.
         *                    A description of the job template you are creating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getHopDestinations}
         * @param hopDestinations Optional.
         *                        Configuration for a destination queue to which the job can hop once a customer-defined minimum wait time has passed. For more information, see <a href="https://docs.aws.amazon.com/mediaconvert/latest/ug/setting-up-queue-hopping-to-avoid-long-waits.html">Setting Up Queue Hopping to Avoid Long Waits</a> in the <em>AWS Elemental MediaConvert User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hopDestinations(software.amazon.awscdk.IResolvable hopDestinations) {
            this.hopDestinations = hopDestinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getHopDestinations}
         * @param hopDestinations Optional.
         *                        Configuration for a destination queue to which the job can hop once a customer-defined minimum wait time has passed. For more information, see <a href="https://docs.aws.amazon.com/mediaconvert/latest/ug/setting-up-queue-hopping-to-avoid-long-waits.html">Setting Up Queue Hopping to Avoid Long Waits</a> in the <em>AWS Elemental MediaConvert User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hopDestinations(java.util.List<? extends java.lang.Object> hopDestinations) {
            this.hopDestinations = hopDestinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getName}
         * @param name Name of the output group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getPriority}
         * @param priority Specify the relative priority for this job.
         *                 In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0. Minimum: -50 Maximum: 50
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getQueue}
         * @param queue Optional.
         *              The queue that jobs created from this template are assigned to. Specify the Amazon Resource Name (ARN) of the queue. For example, arn:aws:mediaconvert:us-west-2:505474453218:queues/Default. If you don't specify this, jobs will go to the default queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queue(java.lang.String queue) {
            this.queue = queue;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getStatusUpdateInterval}
         * @param statusUpdateInterval Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events.
         *                             Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
         *                             <p>
         *                             Specify one of the following enums:
         *                             <p>
         *                             SECONDS_10
         *                             <p>
         *                             SECONDS_12
         *                             <p>
         *                             SECONDS_15
         *                             <p>
         *                             SECONDS_20
         *                             <p>
         *                             SECONDS_30
         *                             <p>
         *                             SECONDS_60
         *                             <p>
         *                             SECONDS_120
         *                             <p>
         *                             SECONDS_180
         *                             <p>
         *                             SECONDS_240
         *                             <p>
         *                             SECONDS_300
         *                             <p>
         *                             SECONDS_360
         *                             <p>
         *                             SECONDS_420
         *                             <p>
         *                             SECONDS_480
         *                             <p>
         *                             SECONDS_540
         *                             <p>
         *                             SECONDS_600
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusUpdateInterval(java.lang.String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobTemplateProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnJobTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnJobTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnJobTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnJobTemplateProps {
        private final java.lang.Object settingsJson;
        private final java.lang.Object accelerationSettings;
        private final java.lang.String category;
        private final java.lang.String description;
        private final java.lang.Object hopDestinations;
        private final java.lang.String name;
        private final java.lang.Number priority;
        private final java.lang.String queue;
        private final java.lang.String statusUpdateInterval;
        private final java.lang.Object tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.settingsJson = software.amazon.jsii.Kernel.get(this, "settingsJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.accelerationSettings = software.amazon.jsii.Kernel.get(this, "accelerationSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hopDestinations = software.amazon.jsii.Kernel.get(this, "hopDestinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.queue = software.amazon.jsii.Kernel.get(this, "queue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.statusUpdateInterval = software.amazon.jsii.Kernel.get(this, "statusUpdateInterval", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.settingsJson = java.util.Objects.requireNonNull(builder.settingsJson, "settingsJson is required");
            this.accelerationSettings = builder.accelerationSettings;
            this.category = builder.category;
            this.description = builder.description;
            this.hopDestinations = builder.hopDestinations;
            this.name = builder.name;
            this.priority = builder.priority;
            this.queue = builder.queue;
            this.statusUpdateInterval = builder.statusUpdateInterval;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getSettingsJson() {
            return this.settingsJson;
        }

        @Override
        public final java.lang.Object getAccelerationSettings() {
            return this.accelerationSettings;
        }

        @Override
        public final java.lang.String getCategory() {
            return this.category;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getHopDestinations() {
            return this.hopDestinations;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.String getQueue() {
            return this.queue;
        }

        @Override
        public final java.lang.String getStatusUpdateInterval() {
            return this.statusUpdateInterval;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("settingsJson", om.valueToTree(this.getSettingsJson()));
            if (this.getAccelerationSettings() != null) {
                data.set("accelerationSettings", om.valueToTree(this.getAccelerationSettings()));
            }
            if (this.getCategory() != null) {
                data.set("category", om.valueToTree(this.getCategory()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHopDestinations() != null) {
                data.set("hopDestinations", om.valueToTree(this.getHopDestinations()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPriority() != null) {
                data.set("priority", om.valueToTree(this.getPriority()));
            }
            if (this.getQueue() != null) {
                data.set("queue", om.valueToTree(this.getQueue()));
            }
            if (this.getStatusUpdateInterval() != null) {
                data.set("statusUpdateInterval", om.valueToTree(this.getStatusUpdateInterval()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediaconvert.CfnJobTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnJobTemplateProps.Jsii$Proxy that = (CfnJobTemplateProps.Jsii$Proxy) o;

            if (!settingsJson.equals(that.settingsJson)) return false;
            if (this.accelerationSettings != null ? !this.accelerationSettings.equals(that.accelerationSettings) : that.accelerationSettings != null) return false;
            if (this.category != null ? !this.category.equals(that.category) : that.category != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.hopDestinations != null ? !this.hopDestinations.equals(that.hopDestinations) : that.hopDestinations != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
            if (this.queue != null ? !this.queue.equals(that.queue) : that.queue != null) return false;
            if (this.statusUpdateInterval != null ? !this.statusUpdateInterval.equals(that.statusUpdateInterval) : that.statusUpdateInterval != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.settingsJson.hashCode();
            result = 31 * result + (this.accelerationSettings != null ? this.accelerationSettings.hashCode() : 0);
            result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.hopDestinations != null ? this.hopDestinations.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
            result = 31 * result + (this.queue != null ? this.queue.hashCode() : 0);
            result = 31 * result + (this.statusUpdateInterval != null ? this.statusUpdateInterval.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
