package software.amazon.awscdk.services.quicksight;

/**
 * Properties for defining a <code>CfnTopic</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnTopicProps cfnTopicProps = CfnTopicProps.builder()
 *         .awsAccountId("awsAccountId")
 *         .configOptions(TopicConfigOptionsProperty.builder()
 *                 .qBusinessInsightsEnabled(false)
 *                 .build())
 *         .dataSets(List.of(DatasetMetadataProperty.builder()
 *                 .datasetArn("datasetArn")
 *                 // the properties below are optional
 *                 .calculatedFields(List.of(TopicCalculatedFieldProperty.builder()
 *                         .calculatedFieldName("calculatedFieldName")
 *                         .expression("expression")
 *                         // the properties below are optional
 *                         .aggregation("aggregation")
 *                         .allowedAggregations(List.of("allowedAggregations"))
 *                         .calculatedFieldDescription("calculatedFieldDescription")
 *                         .calculatedFieldSynonyms(List.of("calculatedFieldSynonyms"))
 *                         .cellValueSynonyms(List.of(CellValueSynonymProperty.builder()
 *                                 .cellValue("cellValue")
 *                                 .synonyms(List.of("synonyms"))
 *                                 .build()))
 *                         .columnDataRole("columnDataRole")
 *                         .comparativeOrder(ComparativeOrderProperty.builder()
 *                                 .specifedOrder(List.of("specifedOrder"))
 *                                 .treatUndefinedSpecifiedValues("treatUndefinedSpecifiedValues")
 *                                 .useOrdering("useOrdering")
 *                                 .build())
 *                         .defaultFormatting(DefaultFormattingProperty.builder()
 *                                 .displayFormat("displayFormat")
 *                                 .displayFormatOptions(DisplayFormatOptionsProperty.builder()
 *                                         .blankCellFormat("blankCellFormat")
 *                                         .currencySymbol("currencySymbol")
 *                                         .dateFormat("dateFormat")
 *                                         .decimalSeparator("decimalSeparator")
 *                                         .fractionDigits(123)
 *                                         .groupingSeparator("groupingSeparator")
 *                                         .negativeFormat(NegativeFormatProperty.builder()
 *                                                 .prefix("prefix")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .prefix("prefix")
 *                                         .suffix("suffix")
 *                                         .unitScaler("unitScaler")
 *                                         .useBlankCellFormat(false)
 *                                         .useGrouping(false)
 *                                         .build())
 *                                 .build())
 *                         .disableIndexing(false)
 *                         .isIncludedInTopic(false)
 *                         .neverAggregateInFilter(false)
 *                         .nonAdditive(false)
 *                         .notAllowedAggregations(List.of("notAllowedAggregations"))
 *                         .semanticType(SemanticTypeProperty.builder()
 *                                 .falseyCellValue("falseyCellValue")
 *                                 .falseyCellValueSynonyms(List.of("falseyCellValueSynonyms"))
 *                                 .subTypeName("subTypeName")
 *                                 .truthyCellValue("truthyCellValue")
 *                                 .truthyCellValueSynonyms(List.of("truthyCellValueSynonyms"))
 *                                 .typeName("typeName")
 *                                 .typeParameters(Map.of(
 *                                         "typeParametersKey", "typeParameters"))
 *                                 .build())
 *                         .timeGranularity("timeGranularity")
 *                         .build()))
 *                 .columns(List.of(TopicColumnProperty.builder()
 *                         .columnName("columnName")
 *                         // the properties below are optional
 *                         .aggregation("aggregation")
 *                         .allowedAggregations(List.of("allowedAggregations"))
 *                         .cellValueSynonyms(List.of(CellValueSynonymProperty.builder()
 *                                 .cellValue("cellValue")
 *                                 .synonyms(List.of("synonyms"))
 *                                 .build()))
 *                         .columnDataRole("columnDataRole")
 *                         .columnDescription("columnDescription")
 *                         .columnFriendlyName("columnFriendlyName")
 *                         .columnSynonyms(List.of("columnSynonyms"))
 *                         .comparativeOrder(ComparativeOrderProperty.builder()
 *                                 .specifedOrder(List.of("specifedOrder"))
 *                                 .treatUndefinedSpecifiedValues("treatUndefinedSpecifiedValues")
 *                                 .useOrdering("useOrdering")
 *                                 .build())
 *                         .defaultFormatting(DefaultFormattingProperty.builder()
 *                                 .displayFormat("displayFormat")
 *                                 .displayFormatOptions(DisplayFormatOptionsProperty.builder()
 *                                         .blankCellFormat("blankCellFormat")
 *                                         .currencySymbol("currencySymbol")
 *                                         .dateFormat("dateFormat")
 *                                         .decimalSeparator("decimalSeparator")
 *                                         .fractionDigits(123)
 *                                         .groupingSeparator("groupingSeparator")
 *                                         .negativeFormat(NegativeFormatProperty.builder()
 *                                                 .prefix("prefix")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .prefix("prefix")
 *                                         .suffix("suffix")
 *                                         .unitScaler("unitScaler")
 *                                         .useBlankCellFormat(false)
 *                                         .useGrouping(false)
 *                                         .build())
 *                                 .build())
 *                         .disableIndexing(false)
 *                         .isIncludedInTopic(false)
 *                         .neverAggregateInFilter(false)
 *                         .nonAdditive(false)
 *                         .notAllowedAggregations(List.of("notAllowedAggregations"))
 *                         .semanticType(SemanticTypeProperty.builder()
 *                                 .falseyCellValue("falseyCellValue")
 *                                 .falseyCellValueSynonyms(List.of("falseyCellValueSynonyms"))
 *                                 .subTypeName("subTypeName")
 *                                 .truthyCellValue("truthyCellValue")
 *                                 .truthyCellValueSynonyms(List.of("truthyCellValueSynonyms"))
 *                                 .typeName("typeName")
 *                                 .typeParameters(Map.of(
 *                                         "typeParametersKey", "typeParameters"))
 *                                 .build())
 *                         .timeGranularity("timeGranularity")
 *                         .build()))
 *                 .dataAggregation(DataAggregationProperty.builder()
 *                         .datasetRowDateGranularity("datasetRowDateGranularity")
 *                         .defaultDateColumnName("defaultDateColumnName")
 *                         .build())
 *                 .datasetDescription("datasetDescription")
 *                 .datasetName("datasetName")
 *                 .filters(List.of(TopicFilterProperty.builder()
 *                         .filterName("filterName")
 *                         .operandFieldName("operandFieldName")
 *                         // the properties below are optional
 *                         .categoryFilter(TopicCategoryFilterProperty.builder()
 *                                 .categoryFilterFunction("categoryFilterFunction")
 *                                 .categoryFilterType("categoryFilterType")
 *                                 .constant(TopicCategoryFilterConstantProperty.builder()
 *                                         .collectiveConstant(CollectiveConstantProperty.builder()
 *                                                 .valueList(List.of("valueList"))
 *                                                 .build())
 *                                         .constantType("constantType")
 *                                         .singularConstant("singularConstant")
 *                                         .build())
 *                                 .inverse(false)
 *                                 .build())
 *                         .dateRangeFilter(TopicDateRangeFilterProperty.builder()
 *                                 .constant(TopicRangeFilterConstantProperty.builder()
 *                                         .constantType("constantType")
 *                                         .rangeConstant(RangeConstantProperty.builder()
 *                                                 .maximum("maximum")
 *                                                 .minimum("minimum")
 *                                                 .build())
 *                                         .build())
 *                                 .inclusive(false)
 *                                 .build())
 *                         .filterClass("filterClass")
 *                         .filterDescription("filterDescription")
 *                         .filterSynonyms(List.of("filterSynonyms"))
 *                         .filterType("filterType")
 *                         .numericEqualityFilter(TopicNumericEqualityFilterProperty.builder()
 *                                 .aggregation("aggregation")
 *                                 .constant(TopicSingularFilterConstantProperty.builder()
 *                                         .constantType("constantType")
 *                                         .singularConstant("singularConstant")
 *                                         .build())
 *                                 .build())
 *                         .numericRangeFilter(TopicNumericRangeFilterProperty.builder()
 *                                 .aggregation("aggregation")
 *                                 .constant(TopicRangeFilterConstantProperty.builder()
 *                                         .constantType("constantType")
 *                                         .rangeConstant(RangeConstantProperty.builder()
 *                                                 .maximum("maximum")
 *                                                 .minimum("minimum")
 *                                                 .build())
 *                                         .build())
 *                                 .inclusive(false)
 *                                 .build())
 *                         .relativeDateFilter(TopicRelativeDateFilterProperty.builder()
 *                                 .constant(TopicSingularFilterConstantProperty.builder()
 *                                         .constantType("constantType")
 *                                         .singularConstant("singularConstant")
 *                                         .build())
 *                                 .relativeDateFilterFunction("relativeDateFilterFunction")
 *                                 .timeGranularity("timeGranularity")
 *                                 .build())
 *                         .build()))
 *                 .namedEntities(List.of(TopicNamedEntityProperty.builder()
 *                         .entityName("entityName")
 *                         // the properties below are optional
 *                         .definition(List.of(NamedEntityDefinitionProperty.builder()
 *                                 .fieldName("fieldName")
 *                                 .metric(NamedEntityDefinitionMetricProperty.builder()
 *                                         .aggregation("aggregation")
 *                                         .aggregationFunctionParameters(Map.of(
 *                                                 "aggregationFunctionParametersKey", "aggregationFunctionParameters"))
 *                                         .build())
 *                                 .propertyName("propertyName")
 *                                 .propertyRole("propertyRole")
 *                                 .propertyUsage("propertyUsage")
 *                                 .build()))
 *                         .entityDescription("entityDescription")
 *                         .entitySynonyms(List.of("entitySynonyms"))
 *                         .semanticEntityType(SemanticEntityTypeProperty.builder()
 *                                 .subTypeName("subTypeName")
 *                                 .typeName("typeName")
 *                                 .typeParameters(Map.of(
 *                                         "typeParametersKey", "typeParameters"))
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         .description("description")
 *         .folderArns(List.of("folderArns"))
 *         .name("name")
 *         .topicId("topicId")
 *         .userExperienceVersion("userExperienceVersion")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:01.273Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopicProps")
@software.amazon.jsii.Jsii.Proxy(CfnTopicProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTopicProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the AWS account that you want to create a topic in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-awsaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
        return null;
    }

    /**
     * Configuration options for a <code>Topic</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-configoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-configoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfigOptions() {
        return null;
    }

    /**
     * The data sets that the topic is associated with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-datasets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-datasets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataSets() {
        return null;
    }

    /**
     * The description of the topic.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-folderarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-folderarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFolderArns() {
        return null;
    }

    /**
     * The name of the topic.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The ID for the topic.
     * <p>
     * This ID is unique per AWS Region for each AWS account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-topicid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-topicid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTopicId() {
        return null;
    }

    /**
     * The user experience version of the topic.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-userexperienceversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-userexperienceversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserExperienceVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTopicProps> {
        java.lang.String awsAccountId;
        java.lang.Object configOptions;
        java.lang.Object dataSets;
        java.lang.String description;
        java.util.List<java.lang.String> folderArns;
        java.lang.String name;
        java.lang.String topicId;
        java.lang.String userExperienceVersion;

        /**
         * Sets the value of {@link CfnTopicProps#getAwsAccountId}
         * @param awsAccountId The ID of the AWS account that you want to create a topic in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getConfigOptions}
         * @param configOptions Configuration options for a <code>Topic</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configOptions(software.amazon.awscdk.IResolvable configOptions) {
            this.configOptions = configOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getConfigOptions}
         * @param configOptions Configuration options for a <code>Topic</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configOptions(software.amazon.awscdk.services.quicksight.CfnTopic.TopicConfigOptionsProperty configOptions) {
            this.configOptions = configOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getDataSets}
         * @param dataSets The data sets that the topic is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSets(software.amazon.awscdk.IResolvable dataSets) {
            this.dataSets = dataSets;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getDataSets}
         * @param dataSets The data sets that the topic is associated with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSets(java.util.List<? extends java.lang.Object> dataSets) {
            this.dataSets = dataSets;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getDescription}
         * @param description The description of the topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getFolderArns}
         * @param folderArns the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder folderArns(java.util.List<java.lang.String> folderArns) {
            this.folderArns = folderArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getName}
         * @param name The name of the topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getTopicId}
         * @param topicId The ID for the topic.
         *                This ID is unique per AWS Region for each AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicId(java.lang.String topicId) {
            this.topicId = topicId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTopicProps#getUserExperienceVersion}
         * @param userExperienceVersion The user experience version of the topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userExperienceVersion(java.lang.String userExperienceVersion) {
            this.userExperienceVersion = userExperienceVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTopicProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTopicProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTopicProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTopicProps {
        private final java.lang.String awsAccountId;
        private final java.lang.Object configOptions;
        private final java.lang.Object dataSets;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> folderArns;
        private final java.lang.String name;
        private final java.lang.String topicId;
        private final java.lang.String userExperienceVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configOptions = software.amazon.jsii.Kernel.get(this, "configOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataSets = software.amazon.jsii.Kernel.get(this, "dataSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.folderArns = software.amazon.jsii.Kernel.get(this, "folderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.topicId = software.amazon.jsii.Kernel.get(this, "topicId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userExperienceVersion = software.amazon.jsii.Kernel.get(this, "userExperienceVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = builder.awsAccountId;
            this.configOptions = builder.configOptions;
            this.dataSets = builder.dataSets;
            this.description = builder.description;
            this.folderArns = builder.folderArns;
            this.name = builder.name;
            this.topicId = builder.topicId;
            this.userExperienceVersion = builder.userExperienceVersion;
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.Object getConfigOptions() {
            return this.configOptions;
        }

        @Override
        public final java.lang.Object getDataSets() {
            return this.dataSets;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getFolderArns() {
            return this.folderArns;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getTopicId() {
            return this.topicId;
        }

        @Override
        public final java.lang.String getUserExperienceVersion() {
            return this.userExperienceVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAwsAccountId() != null) {
                data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            }
            if (this.getConfigOptions() != null) {
                data.set("configOptions", om.valueToTree(this.getConfigOptions()));
            }
            if (this.getDataSets() != null) {
                data.set("dataSets", om.valueToTree(this.getDataSets()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFolderArns() != null) {
                data.set("folderArns", om.valueToTree(this.getFolderArns()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTopicId() != null) {
                data.set("topicId", om.valueToTree(this.getTopicId()));
            }
            if (this.getUserExperienceVersion() != null) {
                data.set("userExperienceVersion", om.valueToTree(this.getUserExperienceVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopicProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTopicProps.Jsii$Proxy that = (CfnTopicProps.Jsii$Proxy) o;

            if (this.awsAccountId != null ? !this.awsAccountId.equals(that.awsAccountId) : that.awsAccountId != null) return false;
            if (this.configOptions != null ? !this.configOptions.equals(that.configOptions) : that.configOptions != null) return false;
            if (this.dataSets != null ? !this.dataSets.equals(that.dataSets) : that.dataSets != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.folderArns != null ? !this.folderArns.equals(that.folderArns) : that.folderArns != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.topicId != null ? !this.topicId.equals(that.topicId) : that.topicId != null) return false;
            return this.userExperienceVersion != null ? this.userExperienceVersion.equals(that.userExperienceVersion) : that.userExperienceVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId != null ? this.awsAccountId.hashCode() : 0;
            result = 31 * result + (this.configOptions != null ? this.configOptions.hashCode() : 0);
            result = 31 * result + (this.dataSets != null ? this.dataSets.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.folderArns != null ? this.folderArns.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.topicId != null ? this.topicId.hashCode() : 0);
            result = 31 * result + (this.userExperienceVersion != null ? this.userExperienceVersion.hashCode() : 0);
            return result;
        }
    }
}
