package software.amazon.awscdk.services.rds;

/**
 * A database instance engine.
 * <p>
 * Provides mapping to DatabaseEngine used for
 * secret rotation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseInstance iopsInstance = DatabaseInstance.Builder.create(this, "IopsInstance")
 *         .engine(DatabaseInstanceEngine.mysql(MySqlInstanceEngineProps.builder().version(MysqlEngineVersion.VER_8_0_39).build()))
 *         .vpc(vpc)
 *         .storageType(StorageType.IO1)
 *         .iops(5000)
 *         .build();
 * DatabaseInstance gp3Instance = DatabaseInstance.Builder.create(this, "Gp3Instance")
 *         .engine(DatabaseInstanceEngine.mysql(MySqlInstanceEngineProps.builder().version(MysqlEngineVersion.VER_8_0_39).build()))
 *         .vpc(vpc)
 *         .allocatedStorage(500)
 *         .storageType(StorageType.GP3)
 *         .storageThroughput(500)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:01.489Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseInstanceEngine")
public class DatabaseInstanceEngine extends software.amazon.jsii.JsiiObject {

    protected DatabaseInstanceEngine(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseInstanceEngine(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        MARIADB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "MARIADB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        MYSQL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "MYSQL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        ORACLE_EE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "ORACLE_EE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        ORACLE_EE_CDB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "ORACLE_EE_CDB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        ORACLE_SE2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "ORACLE_SE2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        ORACLE_SE2_CDB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "ORACLE_SE2_CDB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        POSTGRES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "POSTGRES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        SQL_SERVER_EE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "SQL_SERVER_EE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        SQL_SERVER_EX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "SQL_SERVER_EX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        SQL_SERVER_SE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "SQL_SERVER_SE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        SQL_SERVER_WEB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "SQL_SERVER_WEB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseInstanceEngine() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a new MariaDB instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine mariaDb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.MariaDbInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "mariaDb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new MySQL instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine mysql(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.MySqlInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "mysql", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new Oracle Enterprise Edition instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine oracleEe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OracleEeInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "oracleEe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new Oracle Enterprise Edition (CDB) instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine oracleEeCdb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OracleEeCdbInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "oracleEeCdb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new Oracle Standard Edition 2 instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine oracleSe2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OracleSe2InstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "oracleSe2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new Oracle Standard Edition 2 (CDB) instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine oracleSe2Cdb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OracleSe2CdbInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "oracleSe2Cdb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new PostgreSQL instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine postgres(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.PostgresInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "postgres", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new SQL Server Enterprise Edition instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine sqlServerEe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SqlServerEeInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "sqlServerEe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new SQL Server Express Edition instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine sqlServerEx(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SqlServerExInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "sqlServerEx", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new SQL Server Standard Edition instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine sqlServerSe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SqlServerSeInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "sqlServerSe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new SQL Server Web Edition instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine sqlServerWeb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SqlServerWebInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "sqlServerWeb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The unversioned 'mariadb' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>mariaDb()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine MARIADB;

    /**
     * The unversioned 'mysql' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>mysql()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine MYSQL;

    /**
     * The unversioned 'oracle-ee' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>oracleEe()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine ORACLE_EE;

    /**
     * The unversioned 'oracle-ee-cdb' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>oracleEeCdb()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine ORACLE_EE_CDB;

    /**
     * The unversioned 'oracle-se2' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>oracleSe2()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine ORACLE_SE2;

    /**
     * The unversioned 'oracle-se2-cdb' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>oracleSe2Cdb()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine ORACLE_SE2_CDB;

    /**
     * The unversioned 'postgres' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>postgres()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine POSTGRES;

    /**
     * The unversioned 'sqlserver-ee' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>sqlServerEe()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine SQL_SERVER_EE;

    /**
     * The unversioned 'sqlserver-ex' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>sqlServerEx()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine SQL_SERVER_EX;

    /**
     * The unversioned 'sqlserver-se' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>sqlServerSe()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine SQL_SERVER_SE;

    /**
     * The unversioned 'sqlserver-web' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the <code>sqlServerWeb()</code> method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine SQL_SERVER_WEB;
}
