package software.amazon.awscdk.services.rds;

/**
 * The orchestration of updates of multiple instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder().version(AuroraMysqlEngineVersion.VER_3_01_0).build()))
 *         .writer(ClusterInstance.provisioned("Instance", ProvisionedClusterInstanceProps.builder()
 *                 .instanceType(InstanceType.of(InstanceClass.BURSTABLE3, InstanceSize.SMALL))
 *                 .build()))
 *         .readers(List.of(ClusterInstance.provisioned("reader")))
 *         .instanceUpdateBehaviour(InstanceUpdateBehaviour.ROLLING) // Optional - defaults to rds.InstanceUpdateBehaviour.BULK
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:01.547Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.InstanceUpdateBehaviour")
public enum InstanceUpdateBehaviour {
    /**
     * In a bulk update, all instances of the cluster are updated at the same time.
     * <p>
     * This results in a faster update procedure.
     * During the update, however, all instances might be unavailable at the same time and thus a downtime might occur.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BULK,
    /**
     * In a rolling update, one instance after another is updated.
     * <p>
     * This results in at most one instance being unavailable during the update.
     * If your cluster consists of more than 1 instance, the downtime periods are limited to the time a primary switch needs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ROLLING,
}
