package software.amazon.awscdk.services.s3tables;

/**
 * Creates a table bucket.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-buckets-create.html">Creating a table bucket</a> in the <em>Amazon Simple Storage Service User Guide</em> .
 * <p>
 * <ul>
 * <li><strong>Permissions</strong> - You must have the <code>s3tables:CreateTableBucket</code> permission to use this operation.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3tables.*;
 * CfnTableBucket cfnTableBucket = CfnTableBucket.Builder.create(this, "MyCfnTableBucket")
 *         .tableBucketName("tableBucketName")
 *         // the properties below are optional
 *         .unreferencedFileRemoval(UnreferencedFileRemovalProperty.builder()
 *                 .noncurrentDays(123)
 *                 .status("status")
 *                 .unreferencedDays(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:02.197Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3tables.CfnTableBucket")
public class CfnTableBucket extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnTableBucket(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTableBucket(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3tables.CfnTableBucket.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTableBucket(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3tables.CfnTableBucketProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the table bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTableBucketArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTableBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name for the table bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableBucketName() {
        return software.amazon.jsii.Kernel.get(this, "tableBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the table bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableBucketName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableBucketName", java.util.Objects.requireNonNull(value, "tableBucketName is required"));
    }

    /**
     * The unreferenced file removal settings for your table bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUnreferencedFileRemoval() {
        return software.amazon.jsii.Kernel.get(this, "unreferencedFileRemoval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The unreferenced file removal settings for your table bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUnreferencedFileRemoval(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "unreferencedFileRemoval", value);
    }

    /**
     * The unreferenced file removal settings for your table bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUnreferencedFileRemoval(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3tables.CfnTableBucket.UnreferencedFileRemovalProperty value) {
        software.amazon.jsii.Kernel.set(this, "unreferencedFileRemoval", value);
    }
    /**
     * The unreferenced file removal settings for your table bucket.
     * <p>
     * Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html"><em>Amazon S3 User Guide</em></a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3tables.*;
     * UnreferencedFileRemovalProperty unreferencedFileRemovalProperty = UnreferencedFileRemovalProperty.builder()
     *         .noncurrentDays(123)
     *         .status("status")
     *         .unreferencedDays(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3tables-tablebucket-unreferencedfileremoval.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3tables-tablebucket-unreferencedfileremoval.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3tables.CfnTableBucket.UnreferencedFileRemovalProperty")
    @software.amazon.jsii.Jsii.Proxy(UnreferencedFileRemovalProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UnreferencedFileRemovalProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of days an object can be noncurrent before Amazon S3 deletes it.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3tables-tablebucket-unreferencedfileremoval.html#cfn-s3tables-tablebucket-unreferencedfileremoval-noncurrentdays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3tables-tablebucket-unreferencedfileremoval.html#cfn-s3tables-tablebucket-unreferencedfileremoval-noncurrentdays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNoncurrentDays() {
            return null;
        }

        /**
         * The status of the unreferenced file removal configuration for your table bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3tables-tablebucket-unreferencedfileremoval.html#cfn-s3tables-tablebucket-unreferencedfileremoval-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3tables-tablebucket-unreferencedfileremoval.html#cfn-s3tables-tablebucket-unreferencedfileremoval-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The number of days an object must be unreferenced by your table before Amazon S3 marks the object as noncurrent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3tables-tablebucket-unreferencedfileremoval.html#cfn-s3tables-tablebucket-unreferencedfileremoval-unreferenceddays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3tables-tablebucket-unreferencedfileremoval.html#cfn-s3tables-tablebucket-unreferencedfileremoval-unreferenceddays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUnreferencedDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UnreferencedFileRemovalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UnreferencedFileRemovalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UnreferencedFileRemovalProperty> {
            java.lang.Number noncurrentDays;
            java.lang.String status;
            java.lang.Number unreferencedDays;

            /**
             * Sets the value of {@link UnreferencedFileRemovalProperty#getNoncurrentDays}
             * @param noncurrentDays The number of days an object can be noncurrent before Amazon S3 deletes it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noncurrentDays(java.lang.Number noncurrentDays) {
                this.noncurrentDays = noncurrentDays;
                return this;
            }

            /**
             * Sets the value of {@link UnreferencedFileRemovalProperty#getStatus}
             * @param status The status of the unreferenced file removal configuration for your table bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link UnreferencedFileRemovalProperty#getUnreferencedDays}
             * @param unreferencedDays The number of days an object must be unreferenced by your table before Amazon S3 marks the object as noncurrent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unreferencedDays(java.lang.Number unreferencedDays) {
                this.unreferencedDays = unreferencedDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UnreferencedFileRemovalProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UnreferencedFileRemovalProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UnreferencedFileRemovalProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UnreferencedFileRemovalProperty {
            private final java.lang.Number noncurrentDays;
            private final java.lang.String status;
            private final java.lang.Number unreferencedDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.noncurrentDays = software.amazon.jsii.Kernel.get(this, "noncurrentDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unreferencedDays = software.amazon.jsii.Kernel.get(this, "unreferencedDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.noncurrentDays = builder.noncurrentDays;
                this.status = builder.status;
                this.unreferencedDays = builder.unreferencedDays;
            }

            @Override
            public final java.lang.Number getNoncurrentDays() {
                return this.noncurrentDays;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Number getUnreferencedDays() {
                return this.unreferencedDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNoncurrentDays() != null) {
                    data.set("noncurrentDays", om.valueToTree(this.getNoncurrentDays()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getUnreferencedDays() != null) {
                    data.set("unreferencedDays", om.valueToTree(this.getUnreferencedDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3tables.CfnTableBucket.UnreferencedFileRemovalProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UnreferencedFileRemovalProperty.Jsii$Proxy that = (UnreferencedFileRemovalProperty.Jsii$Proxy) o;

                if (this.noncurrentDays != null ? !this.noncurrentDays.equals(that.noncurrentDays) : that.noncurrentDays != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                return this.unreferencedDays != null ? this.unreferencedDays.equals(that.unreferencedDays) : that.unreferencedDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.noncurrentDays != null ? this.noncurrentDays.hashCode() : 0;
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.unreferencedDays != null ? this.unreferencedDays.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3tables.CfnTableBucket}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3tables.CfnTableBucket> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3tables.CfnTableBucketProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3tables.CfnTableBucketProps.Builder();
        }

        /**
         * The name for the table bucket.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html#cfn-s3tables-tablebucket-tablebucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html#cfn-s3tables-tablebucket-tablebucketname</a>
         * @param tableBucketName The name for the table bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableBucketName(final java.lang.String tableBucketName) {
            this.props.tableBucketName(tableBucketName);
            return this;
        }

        /**
         * The unreferenced file removal settings for your table bucket.
         * <p>
         * Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html"><em>Amazon S3 User Guide</em></a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html#cfn-s3tables-tablebucket-unreferencedfileremoval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html#cfn-s3tables-tablebucket-unreferencedfileremoval</a>
         * @param unreferencedFileRemoval The unreferenced file removal settings for your table bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unreferencedFileRemoval(final software.amazon.awscdk.IResolvable unreferencedFileRemoval) {
            this.props.unreferencedFileRemoval(unreferencedFileRemoval);
            return this;
        }
        /**
         * The unreferenced file removal settings for your table bucket.
         * <p>
         * Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html"><em>Amazon S3 User Guide</em></a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html#cfn-s3tables-tablebucket-unreferencedfileremoval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-tablebucket.html#cfn-s3tables-tablebucket-unreferencedfileremoval</a>
         * @param unreferencedFileRemoval The unreferenced file removal settings for your table bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unreferencedFileRemoval(final software.amazon.awscdk.services.s3tables.CfnTableBucket.UnreferencedFileRemovalProperty unreferencedFileRemoval) {
            this.props.unreferencedFileRemoval(unreferencedFileRemoval);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3tables.CfnTableBucket}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3tables.CfnTableBucket build() {
            return new software.amazon.awscdk.services.s3tables.CfnTableBucket(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
