package software.amazon.awscdk.services.ses;

/**
 * Options for a configuration set event destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ConfigurationSet myConfigurationSet;
 * Topic myTopic;
 * myConfigurationSet.addEventDestination("ToSns", ConfigurationSetEventDestinationOptions.builder()
 *         .destination(EventDestination.snsTopic(myTopic))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.032Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ConfigurationSetEventDestinationOptions")
@software.amazon.jsii.Jsii.Proxy(ConfigurationSetEventDestinationOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConfigurationSetEventDestinationOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The event destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EventDestination getDestination();

    /**
     * A name for the configuration set event destination.
     * <p>
     * Default: - a CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationSetEventDestinationName() {
        return null;
    }

    /**
     * Whether Amazon SES publishes events to this destination.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The type of email sending events to publish to the event destination.
     * <p>
     * Default: - send all event types
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent> getEvents() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ConfigurationSetEventDestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConfigurationSetEventDestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConfigurationSetEventDestinationOptions> {
        software.amazon.awscdk.services.ses.EventDestination destination;
        java.lang.String configurationSetEventDestinationName;
        java.lang.Boolean enabled;
        java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent> events;

        /**
         * Sets the value of {@link ConfigurationSetEventDestinationOptions#getDestination}
         * @param destination The event destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.ses.EventDestination destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetEventDestinationOptions#getConfigurationSetEventDestinationName}
         * @param configurationSetEventDestinationName A name for the configuration set event destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetEventDestinationName(java.lang.String configurationSetEventDestinationName) {
            this.configurationSetEventDestinationName = configurationSetEventDestinationName;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetEventDestinationOptions#getEnabled}
         * @param enabled Whether Amazon SES publishes events to this destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetEventDestinationOptions#getEvents}
         * @param events The type of email sending events to publish to the event destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder events(java.util.List<? extends software.amazon.awscdk.services.ses.EmailSendingEvent> events) {
            this.events = (java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent>)events;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConfigurationSetEventDestinationOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConfigurationSetEventDestinationOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConfigurationSetEventDestinationOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationSetEventDestinationOptions {
        private final software.amazon.awscdk.services.ses.EventDestination destination;
        private final java.lang.String configurationSetEventDestinationName;
        private final java.lang.Boolean enabled;
        private final java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent> events;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EventDestination.class));
            this.configurationSetEventDestinationName = software.amazon.jsii.Kernel.get(this, "configurationSetEventDestinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.EmailSendingEvent.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
            this.configurationSetEventDestinationName = builder.configurationSetEventDestinationName;
            this.enabled = builder.enabled;
            this.events = (java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent>)builder.events;
        }

        @Override
        public final software.amazon.awscdk.services.ses.EventDestination getDestination() {
            return this.destination;
        }

        @Override
        public final java.lang.String getConfigurationSetEventDestinationName() {
            return this.configurationSetEventDestinationName;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ses.EmailSendingEvent> getEvents() {
            return this.events;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destination", om.valueToTree(this.getDestination()));
            if (this.getConfigurationSetEventDestinationName() != null) {
                data.set("configurationSetEventDestinationName", om.valueToTree(this.getConfigurationSetEventDestinationName()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEvents() != null) {
                data.set("events", om.valueToTree(this.getEvents()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.ConfigurationSetEventDestinationOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConfigurationSetEventDestinationOptions.Jsii$Proxy that = (ConfigurationSetEventDestinationOptions.Jsii$Proxy) o;

            if (!destination.equals(that.destination)) return false;
            if (this.configurationSetEventDestinationName != null ? !this.configurationSetEventDestinationName.equals(that.configurationSetEventDestinationName) : that.configurationSetEventDestinationName != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            return this.events != null ? this.events.equals(that.events) : that.events == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + (this.configurationSetEventDestinationName != null ? this.configurationSetEventDestinationName.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
            return result;
        }
    }
}
