package software.amazon.awscdk.services.ses;

/**
 * Properties for a configuration set.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ConfigurationSet.Builder.create(this, "ConfigurationSetWithVdmOptions")
 *         .vdmOptions(VdmOptions.builder()
 *                 .engagementMetrics(true)
 *                 .optimizedSharedDelivery(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.033Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ConfigurationSetProps")
@software.amazon.jsii.Jsii.Proxy(ConfigurationSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConfigurationSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the configuration set.
     * <p>
     * Default: - a CloudFormation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationSetName() {
        return null;
    }

    /**
     * The custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
     * <p>
     * Default: - use the default awstrack.me domain
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomTrackingRedirectDomain() {
        return null;
    }

    /**
     * The dedicated IP pool to associate with the configuration set.
     * <p>
     * Default: - do not use a dedicated IP pool
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.IDedicatedIpPool getDedicatedIpPool() {
        return null;
    }

    /**
     * If true, account-level suppression list is disabled;
     * <p>
     * email sent with this configuration set
     * will not use any suppression settings at all
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableSuppressionList() {
        return null;
    }

    /**
     * The maximum amount of time that Amazon SES API v2 will attempt delivery of email.
     * <p>
     * This value must be greater than or equal to 5 minutes and less than or equal to 14 hours.
     * <p>
     * Default: undefined - SES defaults to 14 hours
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxDeliveryDuration() {
        return null;
    }

    /**
     * Whether to publish reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReputationMetrics() {
        return null;
    }

    /**
     * Whether email sending is enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSendingEnabled() {
        return null;
    }

    /**
     * The reasons for which recipient email addresses should be automatically added to your account's suppression list.
     * <p>
     * Default: - use account level settings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.SuppressionReasons getSuppressionReasons() {
        return null;
    }

    /**
     * Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
     * <p>
     * Default: ConfigurationSetTlsPolicy.OPTIONAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy getTlsPolicy() {
        return null;
    }

    /**
     * The Virtual Deliverability Manager (VDM) options that apply to the configuration set.
     * <p>
     * Default: - VDM options not configured at the configuration set level. In this case, use account level settings. (To set the account level settings using CDK, use the `VdmAttributes` Construct.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.VdmOptions getVdmOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConfigurationSetProps> {
        java.lang.String configurationSetName;
        java.lang.String customTrackingRedirectDomain;
        software.amazon.awscdk.services.ses.IDedicatedIpPool dedicatedIpPool;
        java.lang.Boolean disableSuppressionList;
        software.amazon.awscdk.Duration maxDeliveryDuration;
        java.lang.Boolean reputationMetrics;
        java.lang.Boolean sendingEnabled;
        software.amazon.awscdk.services.ses.SuppressionReasons suppressionReasons;
        software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy tlsPolicy;
        software.amazon.awscdk.services.ses.VdmOptions vdmOptions;

        /**
         * Sets the value of {@link ConfigurationSetProps#getConfigurationSetName}
         * @param configurationSetName A name for the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetName(java.lang.String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetProps#getCustomTrackingRedirectDomain}
         * @param customTrackingRedirectDomain The custom subdomain that is used to redirect email recipients to the Amazon SES event tracking domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customTrackingRedirectDomain(java.lang.String customTrackingRedirectDomain) {
            this.customTrackingRedirectDomain = customTrackingRedirectDomain;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetProps#getDedicatedIpPool}
         * @param dedicatedIpPool The dedicated IP pool to associate with the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dedicatedIpPool(software.amazon.awscdk.services.ses.IDedicatedIpPool dedicatedIpPool) {
            this.dedicatedIpPool = dedicatedIpPool;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetProps#getDisableSuppressionList}
         * @param disableSuppressionList If true, account-level suppression list is disabled;.
         *                               email sent with this configuration set
         *                               will not use any suppression settings at all
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableSuppressionList(java.lang.Boolean disableSuppressionList) {
            this.disableSuppressionList = disableSuppressionList;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetProps#getMaxDeliveryDuration}
         * @param maxDeliveryDuration The maximum amount of time that Amazon SES API v2 will attempt delivery of email.
         *                            This value must be greater than or equal to 5 minutes and less than or equal to 14 hours.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxDeliveryDuration(software.amazon.awscdk.Duration maxDeliveryDuration) {
            this.maxDeliveryDuration = maxDeliveryDuration;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetProps#getReputationMetrics}
         * @param reputationMetrics Whether to publish reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reputationMetrics(java.lang.Boolean reputationMetrics) {
            this.reputationMetrics = reputationMetrics;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetProps#getSendingEnabled}
         * @param sendingEnabled Whether email sending is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sendingEnabled(java.lang.Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetProps#getSuppressionReasons}
         * @param suppressionReasons The reasons for which recipient email addresses should be automatically added to your account's suppression list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suppressionReasons(software.amazon.awscdk.services.ses.SuppressionReasons suppressionReasons) {
            this.suppressionReasons = suppressionReasons;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetProps#getTlsPolicy}
         * @param tlsPolicy Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsPolicy(software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ConfigurationSetProps#getVdmOptions}
         * @param vdmOptions The Virtual Deliverability Manager (VDM) options that apply to the configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vdmOptions(software.amazon.awscdk.services.ses.VdmOptions vdmOptions) {
            this.vdmOptions = vdmOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConfigurationSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConfigurationSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationSetProps {
        private final java.lang.String configurationSetName;
        private final java.lang.String customTrackingRedirectDomain;
        private final software.amazon.awscdk.services.ses.IDedicatedIpPool dedicatedIpPool;
        private final java.lang.Boolean disableSuppressionList;
        private final software.amazon.awscdk.Duration maxDeliveryDuration;
        private final java.lang.Boolean reputationMetrics;
        private final java.lang.Boolean sendingEnabled;
        private final software.amazon.awscdk.services.ses.SuppressionReasons suppressionReasons;
        private final software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy tlsPolicy;
        private final software.amazon.awscdk.services.ses.VdmOptions vdmOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configurationSetName = software.amazon.jsii.Kernel.get(this, "configurationSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customTrackingRedirectDomain = software.amazon.jsii.Kernel.get(this, "customTrackingRedirectDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dedicatedIpPool = software.amazon.jsii.Kernel.get(this, "dedicatedIpPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.IDedicatedIpPool.class));
            this.disableSuppressionList = software.amazon.jsii.Kernel.get(this, "disableSuppressionList", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.maxDeliveryDuration = software.amazon.jsii.Kernel.get(this, "maxDeliveryDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.reputationMetrics = software.amazon.jsii.Kernel.get(this, "reputationMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.sendingEnabled = software.amazon.jsii.Kernel.get(this, "sendingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.suppressionReasons = software.amazon.jsii.Kernel.get(this, "suppressionReasons", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.SuppressionReasons.class));
            this.tlsPolicy = software.amazon.jsii.Kernel.get(this, "tlsPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy.class));
            this.vdmOptions = software.amazon.jsii.Kernel.get(this, "vdmOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.VdmOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configurationSetName = builder.configurationSetName;
            this.customTrackingRedirectDomain = builder.customTrackingRedirectDomain;
            this.dedicatedIpPool = builder.dedicatedIpPool;
            this.disableSuppressionList = builder.disableSuppressionList;
            this.maxDeliveryDuration = builder.maxDeliveryDuration;
            this.reputationMetrics = builder.reputationMetrics;
            this.sendingEnabled = builder.sendingEnabled;
            this.suppressionReasons = builder.suppressionReasons;
            this.tlsPolicy = builder.tlsPolicy;
            this.vdmOptions = builder.vdmOptions;
        }

        @Override
        public final java.lang.String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final java.lang.String getCustomTrackingRedirectDomain() {
            return this.customTrackingRedirectDomain;
        }

        @Override
        public final software.amazon.awscdk.services.ses.IDedicatedIpPool getDedicatedIpPool() {
            return this.dedicatedIpPool;
        }

        @Override
        public final java.lang.Boolean getDisableSuppressionList() {
            return this.disableSuppressionList;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxDeliveryDuration() {
            return this.maxDeliveryDuration;
        }

        @Override
        public final java.lang.Boolean getReputationMetrics() {
            return this.reputationMetrics;
        }

        @Override
        public final java.lang.Boolean getSendingEnabled() {
            return this.sendingEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.ses.SuppressionReasons getSuppressionReasons() {
            return this.suppressionReasons;
        }

        @Override
        public final software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy getTlsPolicy() {
            return this.tlsPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.ses.VdmOptions getVdmOptions() {
            return this.vdmOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConfigurationSetName() != null) {
                data.set("configurationSetName", om.valueToTree(this.getConfigurationSetName()));
            }
            if (this.getCustomTrackingRedirectDomain() != null) {
                data.set("customTrackingRedirectDomain", om.valueToTree(this.getCustomTrackingRedirectDomain()));
            }
            if (this.getDedicatedIpPool() != null) {
                data.set("dedicatedIpPool", om.valueToTree(this.getDedicatedIpPool()));
            }
            if (this.getDisableSuppressionList() != null) {
                data.set("disableSuppressionList", om.valueToTree(this.getDisableSuppressionList()));
            }
            if (this.getMaxDeliveryDuration() != null) {
                data.set("maxDeliveryDuration", om.valueToTree(this.getMaxDeliveryDuration()));
            }
            if (this.getReputationMetrics() != null) {
                data.set("reputationMetrics", om.valueToTree(this.getReputationMetrics()));
            }
            if (this.getSendingEnabled() != null) {
                data.set("sendingEnabled", om.valueToTree(this.getSendingEnabled()));
            }
            if (this.getSuppressionReasons() != null) {
                data.set("suppressionReasons", om.valueToTree(this.getSuppressionReasons()));
            }
            if (this.getTlsPolicy() != null) {
                data.set("tlsPolicy", om.valueToTree(this.getTlsPolicy()));
            }
            if (this.getVdmOptions() != null) {
                data.set("vdmOptions", om.valueToTree(this.getVdmOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.ConfigurationSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConfigurationSetProps.Jsii$Proxy that = (ConfigurationSetProps.Jsii$Proxy) o;

            if (this.configurationSetName != null ? !this.configurationSetName.equals(that.configurationSetName) : that.configurationSetName != null) return false;
            if (this.customTrackingRedirectDomain != null ? !this.customTrackingRedirectDomain.equals(that.customTrackingRedirectDomain) : that.customTrackingRedirectDomain != null) return false;
            if (this.dedicatedIpPool != null ? !this.dedicatedIpPool.equals(that.dedicatedIpPool) : that.dedicatedIpPool != null) return false;
            if (this.disableSuppressionList != null ? !this.disableSuppressionList.equals(that.disableSuppressionList) : that.disableSuppressionList != null) return false;
            if (this.maxDeliveryDuration != null ? !this.maxDeliveryDuration.equals(that.maxDeliveryDuration) : that.maxDeliveryDuration != null) return false;
            if (this.reputationMetrics != null ? !this.reputationMetrics.equals(that.reputationMetrics) : that.reputationMetrics != null) return false;
            if (this.sendingEnabled != null ? !this.sendingEnabled.equals(that.sendingEnabled) : that.sendingEnabled != null) return false;
            if (this.suppressionReasons != null ? !this.suppressionReasons.equals(that.suppressionReasons) : that.suppressionReasons != null) return false;
            if (this.tlsPolicy != null ? !this.tlsPolicy.equals(that.tlsPolicy) : that.tlsPolicy != null) return false;
            return this.vdmOptions != null ? this.vdmOptions.equals(that.vdmOptions) : that.vdmOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configurationSetName != null ? this.configurationSetName.hashCode() : 0;
            result = 31 * result + (this.customTrackingRedirectDomain != null ? this.customTrackingRedirectDomain.hashCode() : 0);
            result = 31 * result + (this.dedicatedIpPool != null ? this.dedicatedIpPool.hashCode() : 0);
            result = 31 * result + (this.disableSuppressionList != null ? this.disableSuppressionList.hashCode() : 0);
            result = 31 * result + (this.maxDeliveryDuration != null ? this.maxDeliveryDuration.hashCode() : 0);
            result = 31 * result + (this.reputationMetrics != null ? this.reputationMetrics.hashCode() : 0);
            result = 31 * result + (this.sendingEnabled != null ? this.sendingEnabled.hashCode() : 0);
            result = 31 * result + (this.suppressionReasons != null ? this.suppressionReasons.hashCode() : 0);
            result = 31 * result + (this.tlsPolicy != null ? this.tlsPolicy.hashCode() : 0);
            result = 31 * result + (this.vdmOptions != null ? this.vdmOptions.hashCode() : 0);
            return result;
        }
    }
}
