package software.amazon.awscdk.services.ses;

/**
 * Identity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * User user;
 * EmailIdentity identity = EmailIdentity.Builder.create(this, "Identity")
 *         .identity(Identity.domain("cdk.dev"))
 *         .build();
 * identity.grantSendEmail(user);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.043Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.Identity")
public abstract class Identity extends software.amazon.jsii.JsiiObject {

    protected Identity(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Identity(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Identity() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Verify a domain name.
     * <p>
     * DKIM records will have to be added manually to complete the verification
     * process
     * <p>
     * @param domain This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.Identity domain(final @org.jetbrains.annotations.NotNull java.lang.String domain) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.Identity.class, "domain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.Identity.class), new Object[] { java.util.Objects.requireNonNull(domain, "domain is required") });
    }

    /**
     * Verify an email address.
     * <p>
     * To complete the verification process look for an email from
     * no-reply-aws&#64;amazon.com, open it and click the link.
     * <p>
     * @param email This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.Identity email(final @org.jetbrains.annotations.NotNull java.lang.String email) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.Identity.class, "email", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.Identity.class), new Object[] { java.util.Objects.requireNonNull(email, "email is required") });
    }

    /**
     * Verify a public hosted zone.
     * <p>
     * DKIM and MAIL FROM records will be added automatically to the hosted
     * zone
     * <p>
     * @param hostedZone This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.Identity publicHostedZone(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IPublicHostedZone hostedZone) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.Identity.class, "publicHostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.Identity.class), new Object[] { java.util.Objects.requireNonNull(hostedZone, "hostedZone is required") });
    }

    /**
     * The value of the identity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getValue();

    /**
     * The hosted zone associated with this identity.
     * <p>
     * Default: - no hosted zone is associated and no records are created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IPublicHostedZone getHostedZone();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ses.Identity {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The value of the identity.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getValue() {
            return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The hosted zone associated with this identity.
         * <p>
         * Default: - no hosted zone is associated and no records are created
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IPublicHostedZone getHostedZone() {
            return software.amazon.jsii.Kernel.get(this, "hostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IPublicHostedZone.class));
        }
    }
}
