package software.amazon.awscdk.services.shield;

/**
 * Properties for defining a <code>CfnProactiveEngagement</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.shield.*;
 * CfnProactiveEngagementProps cfnProactiveEngagementProps = CfnProactiveEngagementProps.builder()
 *         .emergencyContactList(List.of(EmergencyContactProperty.builder()
 *                 .emailAddress("emailAddress")
 *                 // the properties below are optional
 *                 .contactNotes("contactNotes")
 *                 .phoneNumber("phoneNumber")
 *                 .build()))
 *         .proactiveEngagementStatus("proactiveEngagementStatus")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.079Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_shield.CfnProactiveEngagementProps")
@software.amazon.jsii.Jsii.Proxy(CfnProactiveEngagementProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProactiveEngagementProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support, plus any relevant notes.
     * <p>
     * To enable proactive engagement, the contact list must include at least one phone number.
     * <p>
     * If you provide more than one contact, in the notes, indicate the circumstances under which each contact should be used. Include primary and secondary contact designations, and provide the hours of availability and time zones for each contact.
     * <p>
     * Example contact notes:
     * <p>
     * <ul>
     * <li>This is a hotline that's staffed 24x7x365. Please work with the responding analyst and they will get the appropriate person on the call.</li>
     * <li>Please contact the secondary phone number if the hotline doesn't respond within 5 minutes.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html#cfn-shield-proactiveengagement-emergencycontactlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html#cfn-shield-proactiveengagement-emergencycontactlist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getEmergencyContactList();

    /**
     * Specifies whether proactive engagement is enabled or disabled.
     * <p>
     * Valid values:
     * <p>
     * <code>ENABLED</code> - The Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
     * <p>
     * <code>DISABLED</code> - The SRT will not proactively notify contacts about escalations or to initiate proactive customer support.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html#cfn-shield-proactiveengagement-proactiveengagementstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-shield-proactiveengagement.html#cfn-shield-proactiveengagement-proactiveengagementstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProactiveEngagementStatus();

    /**
     * @return a {@link Builder} of {@link CfnProactiveEngagementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProactiveEngagementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProactiveEngagementProps> {
        java.lang.Object emergencyContactList;
        java.lang.String proactiveEngagementStatus;

        /**
         * Sets the value of {@link CfnProactiveEngagementProps#getEmergencyContactList}
         * @param emergencyContactList The list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support, plus any relevant notes. This parameter is required.
         *                             To enable proactive engagement, the contact list must include at least one phone number.
         *                             <p>
         *                             If you provide more than one contact, in the notes, indicate the circumstances under which each contact should be used. Include primary and secondary contact designations, and provide the hours of availability and time zones for each contact.
         *                             <p>
         *                             Example contact notes:
         *                             <p>
         *                             <ul>
         *                             <li>This is a hotline that's staffed 24x7x365. Please work with the responding analyst and they will get the appropriate person on the call.</li>
         *                             <li>Please contact the secondary phone number if the hotline doesn't respond within 5 minutes.</li>
         *                             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emergencyContactList(software.amazon.awscdk.IResolvable emergencyContactList) {
            this.emergencyContactList = emergencyContactList;
            return this;
        }

        /**
         * Sets the value of {@link CfnProactiveEngagementProps#getEmergencyContactList}
         * @param emergencyContactList The list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you for escalations to the SRT and to initiate proactive customer support, plus any relevant notes. This parameter is required.
         *                             To enable proactive engagement, the contact list must include at least one phone number.
         *                             <p>
         *                             If you provide more than one contact, in the notes, indicate the circumstances under which each contact should be used. Include primary and secondary contact designations, and provide the hours of availability and time zones for each contact.
         *                             <p>
         *                             Example contact notes:
         *                             <p>
         *                             <ul>
         *                             <li>This is a hotline that's staffed 24x7x365. Please work with the responding analyst and they will get the appropriate person on the call.</li>
         *                             <li>Please contact the secondary phone number if the hotline doesn't respond within 5 minutes.</li>
         *                             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emergencyContactList(java.util.List<? extends java.lang.Object> emergencyContactList) {
            this.emergencyContactList = emergencyContactList;
            return this;
        }

        /**
         * Sets the value of {@link CfnProactiveEngagementProps#getProactiveEngagementStatus}
         * @param proactiveEngagementStatus Specifies whether proactive engagement is enabled or disabled. This parameter is required.
         *                                  Valid values:
         *                                  <p>
         *                                  <code>ENABLED</code> - The Shield Response Team (SRT) will use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
         *                                  <p>
         *                                  <code>DISABLED</code> - The SRT will not proactively notify contacts about escalations or to initiate proactive customer support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proactiveEngagementStatus(java.lang.String proactiveEngagementStatus) {
            this.proactiveEngagementStatus = proactiveEngagementStatus;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProactiveEngagementProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProactiveEngagementProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProactiveEngagementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProactiveEngagementProps {
        private final java.lang.Object emergencyContactList;
        private final java.lang.String proactiveEngagementStatus;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.emergencyContactList = software.amazon.jsii.Kernel.get(this, "emergencyContactList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.proactiveEngagementStatus = software.amazon.jsii.Kernel.get(this, "proactiveEngagementStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.emergencyContactList = java.util.Objects.requireNonNull(builder.emergencyContactList, "emergencyContactList is required");
            this.proactiveEngagementStatus = java.util.Objects.requireNonNull(builder.proactiveEngagementStatus, "proactiveEngagementStatus is required");
        }

        @Override
        public final java.lang.Object getEmergencyContactList() {
            return this.emergencyContactList;
        }

        @Override
        public final java.lang.String getProactiveEngagementStatus() {
            return this.proactiveEngagementStatus;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("emergencyContactList", om.valueToTree(this.getEmergencyContactList()));
            data.set("proactiveEngagementStatus", om.valueToTree(this.getProactiveEngagementStatus()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_shield.CfnProactiveEngagementProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProactiveEngagementProps.Jsii$Proxy that = (CfnProactiveEngagementProps.Jsii$Proxy) o;

            if (!emergencyContactList.equals(that.emergencyContactList)) return false;
            return this.proactiveEngagementStatus.equals(that.proactiveEngagementStatus);
        }

        @Override
        public final int hashCode() {
            int result = this.emergencyContactList.hashCode();
            result = 31 * result + (this.proactiveEngagementStatus.hashCode());
            return result;
        }
    }
}
