package software.amazon.awscdk.services.sns;

/**
 * Algorithms which can be used by SNS to calculate the delays associated with all of the retry attempts between the first and last retries in the backoff phase.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic myTopic = new Topic(this, "MyTopic");
 * myTopic.addSubscription(
 * UrlSubscription.Builder.create("https://foobar.com/")
 *         .deliveryPolicy(DeliveryPolicy.builder()
 *                 .healthyRetryPolicy(HealthyRetryPolicy.builder()
 *                         .minDelayTarget(Duration.seconds(5))
 *                         .maxDelayTarget(Duration.seconds(10))
 *                         .numRetries(6)
 *                         .backoffFunction(BackoffFunction.EXPONENTIAL)
 *                         .build())
 *                 .throttlePolicy(ThrottlePolicy.builder()
 *                         .maxReceivesPerSecond(10)
 *                         .build())
 *                 .requestPolicy(RequestPolicy.builder()
 *                         .headerContentType("application/json")
 *                         .build())
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.110Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.BackoffFunction")
public enum BackoffFunction {
    /**
     * Arithmetic, see {@link https://docs.aws.amazon.com/images/sns/latest/dg/images/backoff-graph.png this image} for how this function compares to others.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARITHMETIC,
    /**
     * Exponential, see {@link https://docs.aws.amazon.com/images/sns/latest/dg/images/backoff-graph.png this image} for how this function compares to others.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXPONENTIAL,
    /**
     * Geometric, see {@link https://docs.aws.amazon.com/images/sns/latest/dg/images/backoff-graph.png this image} for how this function compares to others.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GEOMETRIC,
    /**
     * Linear, see {@link https://docs.aws.amazon.com/images/sns/latest/dg/images/backoff-graph.png this image} for how this function compares to others.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINEAR,
}
