package software.amazon.awscdk.services.sns;

/**
 * A logging configuration for delivery status of messages sent from SNS topic to subscribed endpoints.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role role;
 * Topic topic = new Topic(this, "MyTopic");
 * topic.addLoggingConfig(LoggingConfig.builder()
 *         .protocol(LoggingProtocol.SQS)
 *         .failureFeedbackRole(role)
 *         .successFeedbackRole(role)
 *         .successFeedbackSampleRate(50)
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-topic-attributes.html.">https://docs.aws.amazon.com/sns/latest/dg/sns-topic-attributes.html.</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.125Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.LoggingConfig")
@software.amazon.jsii.Jsii.Proxy(LoggingConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoggingConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates one of the supported protocols for the SNS topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.LoggingProtocol getProtocol();

    /**
     * The IAM role to be used when logging failed message deliveries in Amazon CloudWatch.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getFailureFeedbackRole() {
        return null;
    }

    /**
     * The IAM role to be used when logging successful message deliveries in Amazon CloudWatch.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getSuccessFeedbackRole() {
        return null;
    }

    /**
     * The percentage of successful message deliveries to be logged in Amazon CloudWatch.
     * <p>
     * Valid values are integer between 0-100
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSuccessFeedbackSampleRate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoggingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoggingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoggingConfig> {
        software.amazon.awscdk.services.sns.LoggingProtocol protocol;
        software.amazon.awscdk.services.iam.IRole failureFeedbackRole;
        software.amazon.awscdk.services.iam.IRole successFeedbackRole;
        java.lang.Number successFeedbackSampleRate;

        /**
         * Sets the value of {@link LoggingConfig#getProtocol}
         * @param protocol Indicates one of the supported protocols for the SNS topic. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.sns.LoggingProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link LoggingConfig#getFailureFeedbackRole}
         * @param failureFeedbackRole The IAM role to be used when logging failed message deliveries in Amazon CloudWatch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureFeedbackRole(software.amazon.awscdk.services.iam.IRole failureFeedbackRole) {
            this.failureFeedbackRole = failureFeedbackRole;
            return this;
        }

        /**
         * Sets the value of {@link LoggingConfig#getSuccessFeedbackRole}
         * @param successFeedbackRole The IAM role to be used when logging successful message deliveries in Amazon CloudWatch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder successFeedbackRole(software.amazon.awscdk.services.iam.IRole successFeedbackRole) {
            this.successFeedbackRole = successFeedbackRole;
            return this;
        }

        /**
         * Sets the value of {@link LoggingConfig#getSuccessFeedbackSampleRate}
         * @param successFeedbackSampleRate The percentage of successful message deliveries to be logged in Amazon CloudWatch.
         *                                  Valid values are integer between 0-100
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder successFeedbackSampleRate(java.lang.Number successFeedbackSampleRate) {
            this.successFeedbackSampleRate = successFeedbackSampleRate;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoggingConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoggingConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoggingConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingConfig {
        private final software.amazon.awscdk.services.sns.LoggingProtocol protocol;
        private final software.amazon.awscdk.services.iam.IRole failureFeedbackRole;
        private final software.amazon.awscdk.services.iam.IRole successFeedbackRole;
        private final java.lang.Number successFeedbackSampleRate;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.LoggingProtocol.class));
            this.failureFeedbackRole = software.amazon.jsii.Kernel.get(this, "failureFeedbackRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.successFeedbackRole = software.amazon.jsii.Kernel.get(this, "successFeedbackRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.successFeedbackSampleRate = software.amazon.jsii.Kernel.get(this, "successFeedbackSampleRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            this.failureFeedbackRole = builder.failureFeedbackRole;
            this.successFeedbackRole = builder.successFeedbackRole;
            this.successFeedbackSampleRate = builder.successFeedbackSampleRate;
        }

        @Override
        public final software.amazon.awscdk.services.sns.LoggingProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getFailureFeedbackRole() {
            return this.failureFeedbackRole;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getSuccessFeedbackRole() {
            return this.successFeedbackRole;
        }

        @Override
        public final java.lang.Number getSuccessFeedbackSampleRate() {
            return this.successFeedbackSampleRate;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("protocol", om.valueToTree(this.getProtocol()));
            if (this.getFailureFeedbackRole() != null) {
                data.set("failureFeedbackRole", om.valueToTree(this.getFailureFeedbackRole()));
            }
            if (this.getSuccessFeedbackRole() != null) {
                data.set("successFeedbackRole", om.valueToTree(this.getSuccessFeedbackRole()));
            }
            if (this.getSuccessFeedbackSampleRate() != null) {
                data.set("successFeedbackSampleRate", om.valueToTree(this.getSuccessFeedbackSampleRate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.LoggingConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoggingConfig.Jsii$Proxy that = (LoggingConfig.Jsii$Proxy) o;

            if (!protocol.equals(that.protocol)) return false;
            if (this.failureFeedbackRole != null ? !this.failureFeedbackRole.equals(that.failureFeedbackRole) : that.failureFeedbackRole != null) return false;
            if (this.successFeedbackRole != null ? !this.successFeedbackRole.equals(that.successFeedbackRole) : that.successFeedbackRole != null) return false;
            return this.successFeedbackSampleRate != null ? this.successFeedbackSampleRate.equals(that.successFeedbackSampleRate) : that.successFeedbackSampleRate == null;
        }

        @Override
        public final int hashCode() {
            int result = this.protocol.hashCode();
            result = 31 * result + (this.failureFeedbackRole != null ? this.failureFeedbackRole.hashCode() : 0);
            result = 31 * result + (this.successFeedbackRole != null ? this.successFeedbackRole.hashCode() : 0);
            result = 31 * result + (this.successFeedbackSampleRate != null ? this.successFeedbackSampleRate.hashCode() : 0);
            return result;
        }
    }
}
