package software.amazon.awscdk.services.ssmincidents;

/**
 * Properties for defining a <code>CfnReplicationSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmincidents.*;
 * CfnReplicationSetProps cfnReplicationSetProps = CfnReplicationSetProps.builder()
 *         .regions(List.of(ReplicationRegionProperty.builder()
 *                 .regionConfiguration(RegionConfigurationProperty.builder()
 *                         .sseKmsKeyId("sseKmsKeyId")
 *                         .build())
 *                 .regionName("regionName")
 *                 .build()))
 *         // the properties below are optional
 *         .deletionProtected(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-replicationset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-replicationset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.284Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnReplicationSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnReplicationSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnReplicationSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the Regions of the replication set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-replicationset.html#cfn-ssmincidents-replicationset-regions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-replicationset.html#cfn-ssmincidents-replicationset-regions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRegions();

    /**
     * Determines if the replication set deletion protection is enabled or not.
     * <p>
     * If deletion protection is enabled, you can't delete the last Region in the replication set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-replicationset.html#cfn-ssmincidents-replicationset-deletionprotected">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-replicationset.html#cfn-ssmincidents-replicationset-deletionprotected</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtected() {
        return null;
    }

    /**
     * A list of tags to add to the replication set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-replicationset.html#cfn-ssmincidents-replicationset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-replicationset.html#cfn-ssmincidents-replicationset-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnReplicationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnReplicationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnReplicationSetProps> {
        java.lang.Object regions;
        java.lang.Object deletionProtected;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnReplicationSetProps#getRegions}
         * @param regions Specifies the Regions of the replication set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(software.amazon.awscdk.IResolvable regions) {
            this.regions = regions;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationSetProps#getRegions}
         * @param regions Specifies the Regions of the replication set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(java.util.List<? extends java.lang.Object> regions) {
            this.regions = regions;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationSetProps#getDeletionProtected}
         * @param deletionProtected Determines if the replication set deletion protection is enabled or not.
         *                          If deletion protection is enabled, you can't delete the last Region in the replication set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtected(java.lang.Boolean deletionProtected) {
            this.deletionProtected = deletionProtected;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationSetProps#getDeletionProtected}
         * @param deletionProtected Determines if the replication set deletion protection is enabled or not.
         *                          If deletion protection is enabled, you can't delete the last Region in the replication set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtected(software.amazon.awscdk.IResolvable deletionProtected) {
            this.deletionProtected = deletionProtected;
            return this;
        }

        /**
         * Sets the value of {@link CfnReplicationSetProps#getTags}
         * @param tags A list of tags to add to the replication set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnReplicationSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnReplicationSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnReplicationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnReplicationSetProps {
        private final java.lang.Object regions;
        private final java.lang.Object deletionProtected;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deletionProtected = software.amazon.jsii.Kernel.get(this, "deletionProtected", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.regions = java.util.Objects.requireNonNull(builder.regions, "regions is required");
            this.deletionProtected = builder.deletionProtected;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getRegions() {
            return this.regions;
        }

        @Override
        public final java.lang.Object getDeletionProtected() {
            return this.deletionProtected;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("regions", om.valueToTree(this.getRegions()));
            if (this.getDeletionProtected() != null) {
                data.set("deletionProtected", om.valueToTree(this.getDeletionProtected()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmincidents.CfnReplicationSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnReplicationSetProps.Jsii$Proxy that = (CfnReplicationSetProps.Jsii$Proxy) o;

            if (!regions.equals(that.regions)) return false;
            if (this.deletionProtected != null ? !this.deletionProtected.equals(that.deletionProtected) : that.deletionProtected != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.regions.hashCode();
            result = 31 * result + (this.deletionProtected != null ? this.deletionProtected.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
