package software.amazon.awscdk.services.stepfunctions;

/**
 * Option properties for state that can assign variables.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object assign;
 * AssignableStateOptions assignableStateOptions = AssignableStateOptions.builder()
 *         .assign(Map.of(
 *                 "assignKey", assign))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.346Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.AssignableStateOptions")
@software.amazon.jsii.Jsii.Proxy(AssignableStateOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssignableStateOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Workflow variables to store in this step.
     * <p>
     * Using workflow variables, you can store data in a step and retrieve that data in future steps.
     * <p>
     * Default: - Not assign variables
     * <p>
     * @see <a href="https://docs.aws.amazon.com/ja_jp/step-functions/latest/dg/workflow-variables.html">https://docs.aws.amazon.com/ja_jp/step-functions/latest/dg/workflow-variables.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getAssign() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AssignableStateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssignableStateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssignableStateOptions> {
        java.util.Map<java.lang.String, java.lang.Object> assign;

        /**
         * Sets the value of {@link AssignableStateOptions#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssignableStateOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssignableStateOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssignableStateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssignableStateOptions {
        private final java.util.Map<java.lang.String, java.lang.Object> assign;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.AssignableStateOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssignableStateOptions.Jsii$Proxy that = (AssignableStateOptions.Jsii$Proxy) o;

            return this.assign != null ? this.assign.equals(that.assign) : that.assign == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assign != null ? this.assign.hashCode() : 0;
            return result;
        }
    }
}
