package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a new CustomerManagedEncryptionConfiguration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.*;
 * Key kmsKey = new Key(this, "Key");
 * StateMachine stateMachine = StateMachine.Builder.create(this, "StateMachineWithCMKEncryptionConfiguration")
 *         .stateMachineName("StateMachineWithCMKEncryptionConfiguration")
 *         .definitionBody(DefinitionBody.fromChainable(Chain.start(new Pass(this, "Pass"))))
 *         .stateMachineType(StateMachineType.STANDARD)
 *         .encryptionConfiguration(new CustomerManagedEncryptionConfiguration(kmsKey, Duration.seconds(60)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.380Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CustomerManagedEncryptionConfiguration")
public class CustomerManagedEncryptionConfiguration extends software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration {

    protected CustomerManagedEncryptionConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CustomerManagedEncryptionConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param kmsKey This parameter is required.
     * @param kmsDataKeyReusePeriodSeconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CustomerManagedEncryptionConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey kmsKey, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration kmsDataKeyReusePeriodSeconds) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(kmsKey, "kmsKey is required"), kmsDataKeyReusePeriodSeconds });
    }

    /**
     * @param kmsKey This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CustomerManagedEncryptionConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey kmsKey) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(kmsKey, "kmsKey is required") });
    }

    /**
     * The symmetric customer managed KMS key for server-side encryption of the state machine definition, and execution history or activity inputs.
     * <p>
     * Step Functions will reuse the key for a maximum of <code>kmsDataKeyReusePeriodSeconds</code>.
     * <p>
     * Default: - data is transparently encrypted using an AWS owned key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey getKmsKey() {
        return software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * Maximum duration that Step Functions will reuse customer managed data keys. When the period expires, Step Functions will call GenerateDataKey.
     * <p>
     * Must be between 60 and 900 seconds.
     * <p>
     * Default: Duration.seconds(300)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getKmsDataKeyReusePeriodSeconds() {
        return software.amazon.jsii.Kernel.get(this, "kmsDataKeyReusePeriodSeconds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }
}
