package software.amazon.awscdk.services.stepfunctions;

/**
 * Predefined error strings Error names in Amazon States Language - https://states-language.net/spec.html#appendix-a Error handling in Step Functions - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.dynamodb.*;
 * // create a table
 * Table table = Table.Builder.create(this, "montable")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .build();
 * Pass finalStatus = new Pass(this, "final step");
 * // States language JSON to put an item into DynamoDB
 * // snippet generated from https://docs.aws.amazon.com/step-functions/latest/dg/tutorial-code-snippet.html#tutorial-code-snippet-1
 * Map&lt;String, Object&gt; stateJson = Map.of(
 *         "Type", "Task",
 *         "Resource", "arn:aws:states:::dynamodb:putItem",
 *         "Parameters", Map.of(
 *                 "TableName", table.getTableName(),
 *                 "Item", Map.of(
 *                         "id", Map.of(
 *                                 "S", "MyEntry"))),
 *         "ResultPath", null);
 * // custom state which represents a task to insert data into DynamoDB
 * CustomState custom = CustomState.Builder.create(this, "my custom task")
 *         .stateJson(stateJson)
 *         .build();
 * // catch errors with addCatch
 * Pass errorHandler = new Pass(this, "handle failure");
 * custom.addCatch(errorHandler);
 * // retry the task if something goes wrong
 * custom.addRetry(RetryProps.builder()
 *         .errors(List.of(Errors.ALL))
 *         .interval(Duration.seconds(10))
 *         .maxAttempts(5)
 *         .build());
 * Chain chain = Chain.start(custom).next(finalStatus);
 * StateMachine sm = StateMachine.Builder.create(this, "StateMachine")
 *         .definitionBody(DefinitionBody.fromChainable(chain))
 *         .timeout(Duration.seconds(30))
 *         .comment("a super cool state machine")
 *         .build();
 * // don't forget permissions. You need to assign them
 * table.grantWriteData(sm);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.400Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Errors")
public class Errors extends software.amazon.jsii.JsiiObject {

    protected Errors(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Errors(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ALL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "ALL", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        BRANCH_FAILED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "BRANCH_FAILED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        HEARTBEAT_TIMEOUT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "HEARTBEAT_TIMEOUT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        NO_CHOICE_MATCHED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "NO_CHOICE_MATCHED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        PARAMETER_PATH_FAILURE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "PARAMETER_PATH_FAILURE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        PERMISSIONS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "PERMISSIONS", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        RESULT_PATH_MATCH_FAILURE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "RESULT_PATH_MATCH_FAILURE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        TASKS_FAILED = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "TASKS_FAILED", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        TIMEOUT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.Errors.class, "TIMEOUT", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Errors() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Matches any Error.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String ALL;

    /**
     * A branch of a Parallel state failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String BRANCH_FAILED;

    /**
     * A Task State failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String HEARTBEAT_TIMEOUT;

    /**
     * A Choice state failed to find a match for the condition field extracted from its input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String NO_CHOICE_MATCHED;

    /**
     * Within a state’s “Parameters” field, the attempt to replace a field whose name ends in “.$” using a Path failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PARAMETER_PATH_FAILURE;

    /**
     * A Task State failed because it had insufficient privileges to execute the specified code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PERMISSIONS;

    /**
     * A Task State’s “ResultPath” field cannot be applied to the input the state received.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RESULT_PATH_MATCH_FAILURE;

    /**
     * A Task State failed during the execution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String TASKS_FAILED;

    /**
     * A Task State either ran longer than the “TimeoutSeconds” value, or failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String TIMEOUT;
}
