package software.amazon.awscdk.services.stepfunctions;

/**
 * Item Reader configuration for iterating over items in a JSON array stored in a S3 file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * /**
 *  * Tree view of bucket:
 *  *  my-bucket
 *  *  |
 *  *  +--input.json
 *  *  |
 *  *  ...
 *  *
 *  * File content of input.json:
 *  *  [
 *  *    "item1",
 *  *    "item2"
 *  *  ]
 *  *&#47;
 * Bucket bucket = Bucket.Builder.create(this, "Bucket")
 *         .bucketName("my-bucket")
 *         .build();
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "DistributedMap")
 *         .itemReader(S3JsonItemReader.Builder.create()
 *                 .bucket(bucket)
 *                 .key("input.json")
 *                 .build())
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.446Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.S3JsonItemReader")
public class S3JsonItemReader extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IItemReader {

    protected S3JsonItemReader(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3JsonItemReader(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public S3JsonItemReader(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.S3FileItemReaderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Compile policy statements to provide relevent permissions to the state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> providePolicyStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "providePolicyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }

    /**
     * Renders the ItemReader configuration as JSON object.
     * <p>
     * @return <ul>
     * <li>JSON object</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Object render() {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Validate that ItemReader contains exactly either.
     * <p>
     * @see <a href="bucketNamePath">bucketNamePath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateItemReader() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateItemReader", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * S3 Bucket containing a file with a list to iterate over.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getInputType() {
        return software.amazon.jsii.Kernel.get(this, "inputType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * S3 key of a file with a list to iterate over.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKey() {
        return software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ARN for the <code>getObject</code> method of the S3 API This API method is used to iterate all objects in the S3 bucket/prefix.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * S3 bucket name containing objects to iterate over or a file with a list to iterate over, as JsonPath.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBucketNamePath() {
        return software.amazon.jsii.Kernel.get(this, "bucketNamePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Limits the number of items passed to the Distributed Map state.
     * <p>
     * Default: - No maxItems
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxItems() {
        return software.amazon.jsii.Kernel.get(this, "maxItems", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.S3JsonItemReader}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.S3JsonItemReader> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.S3FileItemReaderProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.S3FileItemReaderProps.Builder();
        }

        /**
         * S3 Bucket containing objects to iterate over or a file with a list to iterate over.
         * <p>
         * Default: - S3 bucket will be determined from
         * <p>
         * @return {@code this}
         * @see <a href="bucketNamePath">bucketNamePath</a>
         * @param bucket S3 Bucket containing objects to iterate over or a file with a list to iterate over. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * S3 bucket name containing objects to iterate over or a file with a list to iterate over, as JsonPath.
         * <p>
         * Default: - S3 bucket will be determined from
         * <p>
         * @return {@code this}
         * @see <a href="bucket">bucket</a>
         * @param bucketNamePath S3 bucket name containing objects to iterate over or a file with a list to iterate over, as JsonPath. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketNamePath(final java.lang.String bucketNamePath) {
            this.props.bucketNamePath(bucketNamePath);
            return this;
        }

        /**
         * Limits the number of items passed to the Distributed Map state.
         * <p>
         * Default: - Distributed Map state will iterate over all items provided by the ItemReader
         * <p>
         * @return {@code this}
         * @param maxItems Limits the number of items passed to the Distributed Map state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItems(final java.lang.Number maxItems) {
            this.props.maxItems(maxItems);
            return this;
        }

        /**
         * Key of file stored in S3 bucket containing an array to iterate over.
         * <p>
         * @return {@code this}
         * @param key Key of file stored in S3 bucket containing an array to iterate over. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(final java.lang.String key) {
            this.props.key(key);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.S3JsonItemReader}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.S3JsonItemReader build() {
            return new software.amazon.awscdk.services.stepfunctions.S3JsonItemReader(
                this.props.build()
            );
        }
    }
}
