package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for configuring an Item Reader that iterates over objects in an S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * /**
 *  * Tree view of bucket:
 *  *  my-bucket
 *  *  |
 *  *  +--item1
 *  *  |
 *  *  +--otherItem
 *  *  |
 *  *  +--item2
 *  *  |
 *  *  ...
 *  *&#47;
 * Bucket bucket = Bucket.Builder.create(this, "Bucket")
 *         .bucketName("my-bucket")
 *         .build();
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "DistributedMap")
 *         .itemReader(S3ObjectsItemReader.Builder.create()
 *                 .bucket(bucket)
 *                 .prefix("item")
 *                 .build())
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.447Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.S3ObjectsItemReaderProps")
@software.amazon.jsii.Jsii.Proxy(S3ObjectsItemReaderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3ObjectsItemReaderProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.ItemReaderProps {

    /**
     * S3 prefix used to limit objects to iterate over.
     * <p>
     * Default: - No prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3ObjectsItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3ObjectsItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3ObjectsItemReaderProps> {
        java.lang.String prefix;
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.String bucketNamePath;
        java.lang.Number maxItems;

        /**
         * Sets the value of {@link S3ObjectsItemReaderProps#getPrefix}
         * @param prefix S3 prefix used to limit objects to iterate over.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(java.lang.String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Sets the value of {@link S3ObjectsItemReaderProps#getBucket}
         * @param bucket S3 Bucket containing objects to iterate over or a file with a list to iterate over.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link S3ObjectsItemReaderProps#getBucketNamePath}
         * @param bucketNamePath S3 bucket name containing objects to iterate over or a file with a list to iterate over, as JsonPath.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketNamePath(java.lang.String bucketNamePath) {
            this.bucketNamePath = bucketNamePath;
            return this;
        }

        /**
         * Sets the value of {@link S3ObjectsItemReaderProps#getMaxItems}
         * @param maxItems Limits the number of items passed to the Distributed Map state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItems(java.lang.Number maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3ObjectsItemReaderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3ObjectsItemReaderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3ObjectsItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ObjectsItemReaderProps {
        private final java.lang.String prefix;
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String bucketNamePath;
        private final java.lang.Number maxItems;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.bucketNamePath = software.amazon.jsii.Kernel.get(this, "bucketNamePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxItems = software.amazon.jsii.Kernel.get(this, "maxItems", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.prefix = builder.prefix;
            this.bucket = builder.bucket;
            this.bucketNamePath = builder.bucketNamePath;
            this.maxItems = builder.maxItems;
        }

        @Override
        public final java.lang.String getPrefix() {
            return this.prefix;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getBucketNamePath() {
            return this.bucketNamePath;
        }

        @Override
        public final java.lang.Number getMaxItems() {
            return this.maxItems;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPrefix() != null) {
                data.set("prefix", om.valueToTree(this.getPrefix()));
            }
            if (this.getBucket() != null) {
                data.set("bucket", om.valueToTree(this.getBucket()));
            }
            if (this.getBucketNamePath() != null) {
                data.set("bucketNamePath", om.valueToTree(this.getBucketNamePath()));
            }
            if (this.getMaxItems() != null) {
                data.set("maxItems", om.valueToTree(this.getMaxItems()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.S3ObjectsItemReaderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3ObjectsItemReaderProps.Jsii$Proxy that = (S3ObjectsItemReaderProps.Jsii$Proxy) o;

            if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
            if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
            if (this.bucketNamePath != null ? !this.bucketNamePath.equals(that.bucketNamePath) : that.bucketNamePath != null) return false;
            return this.maxItems != null ? this.maxItems.equals(that.maxItems) : that.maxItems == null;
        }

        @Override
        public final int hashCode() {
            int result = this.prefix != null ? this.prefix.hashCode() : 0;
            result = 31 * result + (this.bucket != null ? this.bucket.hashCode() : 0);
            result = 31 * result + (this.bucketNamePath != null ? this.bucketNamePath.hashCode() : 0);
            result = 31 * result + (this.maxItems != null ? this.maxItems.hashCode() : 0);
            return result;
        }
    }
}
