package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties to define an ECS service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * EcsFargateLaunchTargetOptions ecsFargateLaunchTargetOptions = EcsFargateLaunchTargetOptions.builder()
 *         .platformVersion(FargatePlatformVersion.LATEST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:03.675Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EcsFargateLaunchTargetOptions")
@software.amazon.jsii.Jsii.Proxy(EcsFargateLaunchTargetOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsFargateLaunchTargetOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Refers to a specific runtime environment for Fargate task infrastructure.
     * <p>
     * Fargate platform version is a combination of the kernel and container runtime versions.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion();

    /**
     * @return a {@link Builder} of {@link EcsFargateLaunchTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsFargateLaunchTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsFargateLaunchTargetOptions> {
        software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;

        /**
         * Sets the value of {@link EcsFargateLaunchTargetOptions#getPlatformVersion}
         * @param platformVersion Refers to a specific runtime environment for Fargate task infrastructure. This parameter is required.
         *                        Fargate platform version is a combination of the kernel and container runtime versions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsFargateLaunchTargetOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsFargateLaunchTargetOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsFargateLaunchTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsFargateLaunchTargetOptions {
        private final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargatePlatformVersion.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.platformVersion = java.util.Objects.requireNonNull(builder.platformVersion, "platformVersion is required");
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EcsFargateLaunchTargetOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsFargateLaunchTargetOptions.Jsii$Proxy that = (EcsFargateLaunchTargetOptions.Jsii$Proxy) o;

            return this.platformVersion.equals(that.platformVersion);
        }

        @Override
        public final int hashCode() {
            int result = this.platformVersion.hashCode();
            return result;
        }
    }
}
