package software.amazon.awscdk.services.vpclattice;

/**
 * Properties for defining a <code>CfnServiceNetworkServiceAssociation</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.vpclattice.*;
 * CfnServiceNetworkServiceAssociationProps cfnServiceNetworkServiceAssociationProps = CfnServiceNetworkServiceAssociationProps.builder()
 *         .dnsEntry(DnsEntryProperty.builder()
 *                 .domainName("domainName")
 *                 .hostedZoneId("hostedZoneId")
 *                 .build())
 *         .serviceIdentifier("serviceIdentifier")
 *         .serviceNetworkIdentifier("serviceNetworkIdentifier")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-servicenetworkserviceassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-servicenetworkserviceassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-06T22:16:04.157Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_vpclattice.CfnServiceNetworkServiceAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnServiceNetworkServiceAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnServiceNetworkServiceAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DNS information of the service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-servicenetworkserviceassociation.html#cfn-vpclattice-servicenetworkserviceassociation-dnsentry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-servicenetworkserviceassociation.html#cfn-vpclattice-servicenetworkserviceassociation-dnsentry</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDnsEntry() {
        return null;
    }

    /**
     * The ID or ARN of the service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-servicenetworkserviceassociation.html#cfn-vpclattice-servicenetworkserviceassociation-serviceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-servicenetworkserviceassociation.html#cfn-vpclattice-servicenetworkserviceassociation-serviceidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceIdentifier() {
        return null;
    }

    /**
     * The ID or ARN of the service network.
     * <p>
     * You must use an ARN if the resources are in different accounts.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-servicenetworkserviceassociation.html#cfn-vpclattice-servicenetworkserviceassociation-servicenetworkidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-servicenetworkserviceassociation.html#cfn-vpclattice-servicenetworkserviceassociation-servicenetworkidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceNetworkIdentifier() {
        return null;
    }

    /**
     * The tags for the association.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-servicenetworkserviceassociation.html#cfn-vpclattice-servicenetworkserviceassociation-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-servicenetworkserviceassociation.html#cfn-vpclattice-servicenetworkserviceassociation-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnServiceNetworkServiceAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnServiceNetworkServiceAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnServiceNetworkServiceAssociationProps> {
        java.lang.Object dnsEntry;
        java.lang.String serviceIdentifier;
        java.lang.String serviceNetworkIdentifier;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnServiceNetworkServiceAssociationProps#getDnsEntry}
         * @param dnsEntry The DNS information of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsEntry(software.amazon.awscdk.IResolvable dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceNetworkServiceAssociationProps#getDnsEntry}
         * @param dnsEntry The DNS information of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsEntry(software.amazon.awscdk.services.vpclattice.CfnServiceNetworkServiceAssociation.DnsEntryProperty dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceNetworkServiceAssociationProps#getServiceIdentifier}
         * @param serviceIdentifier The ID or ARN of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceIdentifier(java.lang.String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceNetworkServiceAssociationProps#getServiceNetworkIdentifier}
         * @param serviceNetworkIdentifier The ID or ARN of the service network.
         *                                 You must use an ARN if the resources are in different accounts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceNetworkIdentifier(java.lang.String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnServiceNetworkServiceAssociationProps#getTags}
         * @param tags The tags for the association.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnServiceNetworkServiceAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnServiceNetworkServiceAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnServiceNetworkServiceAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnServiceNetworkServiceAssociationProps {
        private final java.lang.Object dnsEntry;
        private final java.lang.String serviceIdentifier;
        private final java.lang.String serviceNetworkIdentifier;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dnsEntry = software.amazon.jsii.Kernel.get(this, "dnsEntry", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceIdentifier = software.amazon.jsii.Kernel.get(this, "serviceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceNetworkIdentifier = software.amazon.jsii.Kernel.get(this, "serviceNetworkIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dnsEntry = builder.dnsEntry;
            this.serviceIdentifier = builder.serviceIdentifier;
            this.serviceNetworkIdentifier = builder.serviceNetworkIdentifier;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDnsEntry() {
            return this.dnsEntry;
        }

        @Override
        public final java.lang.String getServiceIdentifier() {
            return this.serviceIdentifier;
        }

        @Override
        public final java.lang.String getServiceNetworkIdentifier() {
            return this.serviceNetworkIdentifier;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDnsEntry() != null) {
                data.set("dnsEntry", om.valueToTree(this.getDnsEntry()));
            }
            if (this.getServiceIdentifier() != null) {
                data.set("serviceIdentifier", om.valueToTree(this.getServiceIdentifier()));
            }
            if (this.getServiceNetworkIdentifier() != null) {
                data.set("serviceNetworkIdentifier", om.valueToTree(this.getServiceNetworkIdentifier()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_vpclattice.CfnServiceNetworkServiceAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnServiceNetworkServiceAssociationProps.Jsii$Proxy that = (CfnServiceNetworkServiceAssociationProps.Jsii$Proxy) o;

            if (this.dnsEntry != null ? !this.dnsEntry.equals(that.dnsEntry) : that.dnsEntry != null) return false;
            if (this.serviceIdentifier != null ? !this.serviceIdentifier.equals(that.serviceIdentifier) : that.serviceIdentifier != null) return false;
            if (this.serviceNetworkIdentifier != null ? !this.serviceNetworkIdentifier.equals(that.serviceNetworkIdentifier) : that.serviceNetworkIdentifier != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dnsEntry != null ? this.dnsEntry.hashCode() : 0;
            result = 31 * result + (this.serviceIdentifier != null ? this.serviceIdentifier.hashCode() : 0);
            result = 31 * result + (this.serviceNetworkIdentifier != null ? this.serviceNetworkIdentifier.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
