/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.appsync.AppsyncFunctionAttributes;
import software.amazon.awscdk.services.appsync.AppsyncFunctionProps;
import software.amazon.awscdk.services.appsync.BaseDataSource;
import software.amazon.awscdk.services.appsync.Code;
import software.amazon.awscdk.services.appsync.FunctionRuntime;
import software.amazon.awscdk.services.appsync.IAppsyncFunction;
import software.amazon.awscdk.services.appsync.IGraphqlApi;
import software.amazon.awscdk.services.appsync.MappingTemplate;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_appsync.AppsyncFunction")
public class AppsyncFunction
extends Resource
implements IAppsyncFunction {
    protected AppsyncFunction(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppsyncFunction(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AppsyncFunction(@NotNull Construct scope, @NotNull String id, @NotNull AppsyncFunctionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IAppsyncFunction fromAppsyncFunctionAttributes(@NotNull Construct scope, @NotNull String id, @NotNull AppsyncFunctionAttributes attrs) {
        return (IAppsyncFunction)JsiiObject.jsiiStaticCall(AppsyncFunction.class, (String)"fromAppsyncFunctionAttributes", (NativeType)NativeType.forClass(IAppsyncFunction.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public BaseDataSource getDataSource() {
        return (BaseDataSource)((Object)Kernel.get((Object)this, (String)"dataSource", (NativeType)NativeType.forClass(BaseDataSource.class)));
    }

    @Override
    @NotNull
    public String getFunctionArn() {
        return (String)Kernel.get((Object)this, (String)"functionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getFunctionId() {
        return (String)Kernel.get((Object)this, (String)"functionId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getFunctionName() {
        return (String)Kernel.get((Object)this, (String)"functionName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AppsyncFunction> {
        private final Construct scope;
        private final String id;
        private final AppsyncFunctionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new AppsyncFunctionProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder code(Code code) {
            this.props.code(code);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder maxBatchSize(Number maxBatchSize) {
            this.props.maxBatchSize(maxBatchSize);
            return this;
        }

        public Builder requestMappingTemplate(MappingTemplate requestMappingTemplate) {
            this.props.requestMappingTemplate(requestMappingTemplate);
            return this;
        }

        public Builder responseMappingTemplate(MappingTemplate responseMappingTemplate) {
            this.props.responseMappingTemplate(responseMappingTemplate);
            return this;
        }

        public Builder runtime(FunctionRuntime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        public Builder api(IGraphqlApi api) {
            this.props.api(api);
            return this;
        }

        public Builder dataSource(BaseDataSource dataSource) {
            this.props.dataSource(dataSource);
            return this;
        }

        public AppsyncFunction build() {
            return new AppsyncFunction(this.scope, this.id, this.props.build());
        }
    }
}

