/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.Billing;
import software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2;
import software.amazon.awscdk.services.dynamodb.ITableV2;
import software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification;
import software.amazon.awscdk.services.dynamodb.ReplicaTableProps;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.awscdk.services.dynamodb.TableAttributesV2;
import software.amazon.awscdk.services.dynamodb.TableBaseV2;
import software.amazon.awscdk.services.dynamodb.TableClass;
import software.amazon.awscdk.services.dynamodb.TableEncryptionV2;
import software.amazon.awscdk.services.dynamodb.TablePropsV2;
import software.amazon.awscdk.services.dynamodb.WarmThroughput;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_dynamodb.TableV2")
public class TableV2
extends TableBaseV2 {
    protected TableV2(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TableV2(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public TableV2(@NotNull Construct scope, @NotNull String id, @NotNull TablePropsV2 props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ITableV2 fromTableArn(@NotNull Construct scope, @NotNull String id, @NotNull String tableArn) {
        return (ITableV2)JsiiObject.jsiiStaticCall(TableV2.class, (String)"fromTableArn", (NativeType)NativeType.forClass(ITableV2.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(tableArn, "tableArn is required")});
    }

    @NotNull
    public static ITableV2 fromTableAttributes(@NotNull Construct scope, @NotNull String id, @NotNull TableAttributesV2 attrs) {
        return (ITableV2)JsiiObject.jsiiStaticCall(TableV2.class, (String)"fromTableAttributes", (NativeType)NativeType.forClass(ITableV2.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static ITableV2 fromTableName(@NotNull Construct scope, @NotNull String id, @NotNull String tableName) {
        return (ITableV2)JsiiObject.jsiiStaticCall(TableV2.class, (String)"fromTableName", (NativeType)NativeType.forClass(ITableV2.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(tableName, "tableName is required")});
    }

    public void addGlobalSecondaryIndex(@NotNull GlobalSecondaryIndexPropsV2 props) {
        Kernel.call((Object)this, (String)"addGlobalSecondaryIndex", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addLocalSecondaryIndex(@NotNull LocalSecondaryIndexProps props) {
        Kernel.call((Object)this, (String)"addLocalSecondaryIndex", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addReplica(@NotNull ReplicaTableProps props) {
        Kernel.call((Object)this, (String)"addReplica", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public ITableV2 replica(@NotNull String region) {
        return (ITableV2)Kernel.call((Object)this, (String)"replica", (NativeType)NativeType.forClass(ITableV2.class), (Object[])new Object[]{Objects.requireNonNull(region, "region is required")});
    }

    @Override
    @NotNull
    protected Boolean getHasIndex() {
        return (Boolean)Kernel.get((Object)this, (String)"hasIndex", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @NotNull
    protected String getRegion() {
        return (String)Kernel.get((Object)this, (String)"region", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getTableArn() {
        return (String)Kernel.get((Object)this, (String)"tableArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getTableName() {
        return (String)Kernel.get((Object)this, (String)"tableName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)Kernel.get((Object)this, (String)"encryptionKey", (NativeType)NativeType.forClass(IKey.class));
    }

    @Override
    @Nullable
    public String getTableId() {
        return (String)Kernel.get((Object)this, (String)"tableId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public String getTableStreamArn() {
        return (String)Kernel.get((Object)this, (String)"tableStreamArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public PolicyDocument getResourcePolicy() {
        return (PolicyDocument)Kernel.get((Object)this, (String)"resourcePolicy", (NativeType)NativeType.forClass(PolicyDocument.class));
    }

    @Override
    public void setResourcePolicy(@Nullable PolicyDocument value) {
        Kernel.set((Object)this, (String)"resourcePolicy", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TableV2> {
        private final Construct scope;
        private final String id;
        private final TablePropsV2.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new TablePropsV2.Builder();
        }

        public Builder contributorInsights(Boolean contributorInsights) {
            this.props.contributorInsights(contributorInsights);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder kinesisStream(IStream kinesisStream) {
            this.props.kinesisStream(kinesisStream);
            return this;
        }

        @Deprecated
        public Builder pointInTimeRecovery(Boolean pointInTimeRecovery) {
            this.props.pointInTimeRecovery(pointInTimeRecovery);
            return this;
        }

        public Builder pointInTimeRecoverySpecification(PointInTimeRecoverySpecification pointInTimeRecoverySpecification) {
            this.props.pointInTimeRecoverySpecification(pointInTimeRecoverySpecification);
            return this;
        }

        public Builder resourcePolicy(PolicyDocument resourcePolicy) {
            this.props.resourcePolicy(resourcePolicy);
            return this;
        }

        public Builder tableClass(TableClass tableClass) {
            this.props.tableClass(tableClass);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder partitionKey(Attribute partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        public Builder billing(Billing billing) {
            this.props.billing(billing);
            return this;
        }

        public Builder dynamoStream(StreamViewType dynamoStream) {
            this.props.dynamoStream(dynamoStream);
            return this;
        }

        public Builder encryption(TableEncryptionV2 encryption) {
            this.props.encryption(encryption);
            return this;
        }

        public Builder globalSecondaryIndexes(List<? extends GlobalSecondaryIndexPropsV2> globalSecondaryIndexes) {
            this.props.globalSecondaryIndexes(globalSecondaryIndexes);
            return this;
        }

        public Builder localSecondaryIndexes(List<? extends LocalSecondaryIndexProps> localSecondaryIndexes) {
            this.props.localSecondaryIndexes(localSecondaryIndexes);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder replicas(List<? extends ReplicaTableProps> replicas) {
            this.props.replicas(replicas);
            return this;
        }

        public Builder sortKey(Attribute sortKey) {
            this.props.sortKey(sortKey);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Builder timeToLiveAttribute(String timeToLiveAttribute) {
            this.props.timeToLiveAttribute(timeToLiveAttribute);
            return this;
        }

        public Builder warmThroughput(WarmThroughput warmThroughput) {
            this.props.warmThroughput(warmThroughput);
            return this;
        }

        public TableV2 build() {
            return new TableV2(this.scope, this.id, this.props.build());
        }
    }
}

