/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.stepfunctions.Credentials;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.QueryLanguage;
import software.amazon.awscdk.services.stepfunctions.TaskStateJsonataBaseProps;
import software.amazon.awscdk.services.stepfunctions.Timeout;
import software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride;
import software.amazon.awscdk.services.stepfunctions.tasks.EcsRunTaskJsonataProps;
import software.amazon.awscdk.services.stepfunctions.tasks.IEcsLaunchTarget;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.EcsRunTaskJsonataProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface EcsRunTaskJsonataProps
extends JsiiSerializable,
TaskStateJsonataBaseProps {
    @NotNull
    public ICluster getCluster();

    @NotNull
    public IEcsLaunchTarget getLaunchTarget();

    @NotNull
    public TaskDefinition getTaskDefinition();

    @Nullable
    default public Boolean getAssignPublicIp() {
        return null;
    }

    @Nullable
    default public List<ContainerOverride> getContainerOverrides() {
        return null;
    }

    @Nullable
    default public String getCpu() {
        return null;
    }

    @Nullable
    default public Boolean getEnableExecuteCommand() {
        return null;
    }

    @Nullable
    default public String getMemoryMiB() {
        return null;
    }

    @Nullable
    default public PropagatedTagSource getPropagatedTagSource() {
        return null;
    }

    @Nullable
    default public Number getRevisionNumber() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public SubnetSelection getSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EcsRunTaskJsonataProps> {
        ICluster cluster;
        IEcsLaunchTarget launchTarget;
        TaskDefinition taskDefinition;
        Boolean assignPublicIp;
        List<ContainerOverride> containerOverrides;
        String cpu;
        Boolean enableExecuteCommand;
        String memoryMiB;
        PropagatedTagSource propagatedTagSource;
        Number revisionNumber;
        List<ISecurityGroup> securityGroups;
        SubnetSelection subnets;
        String comment;
        QueryLanguage queryLanguage;
        String stateName;
        Credentials credentials;
        Duration heartbeat;
        Timeout heartbeatTimeout;
        IntegrationPattern integrationPattern;
        Timeout taskTimeout;
        Duration timeout;
        Map<String, Object> assign;
        Object outputs;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder launchTarget(IEcsLaunchTarget launchTarget) {
            this.launchTarget = launchTarget;
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder assignPublicIp(Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        public Builder containerOverrides(List<? extends ContainerOverride> containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public Builder memoryMiB(String memoryMiB) {
            this.memoryMiB = memoryMiB;
            return this;
        }

        public Builder propagatedTagSource(PropagatedTagSource propagatedTagSource) {
            this.propagatedTagSource = propagatedTagSource;
            return this;
        }

        public Builder revisionNumber(Number revisionNumber) {
            this.revisionNumber = revisionNumber;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder subnets(SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder queryLanguage(QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        public Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Deprecated
        public Builder heartbeat(Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder heartbeatTimeout(Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public Builder taskTimeout(Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        @Deprecated
        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder assign(Map<String, ? extends Object> assign) {
            this.assign = assign;
            return this;
        }

        public Builder outputs(Object outputs) {
            this.outputs = outputs;
            return this;
        }

        public EcsRunTaskJsonataProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

