package software.amazon.awscdk;

/**
 * Properties for defining a <code>CfnCustomResource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnCustomResourceProps cfnCustomResourceProps = CfnCustomResourceProps.builder()
 *         .serviceToken("serviceToken")
 *         // the properties below are optional
 *         .serviceTimeout(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-customresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-customresource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:21.964Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnCustomResourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnCustomResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCustomResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The service token, such as an Amazon SNS topic ARN or Lambda function ARN.
     * <p>
     * The service token must be from the same Region as the stack.
     * <p>
     * Updates aren't supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-customresource.html#cfn-cloudformation-customresource-servicetoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-customresource.html#cfn-cloudformation-customresource-servicetoken</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceToken();

    /**
     * The maximum time, in seconds, that can elapse before a custom resource operation times out.
     * <p>
     * The value must be an integer from 1 to 3600. The default value is 3600 seconds (1 hour).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-customresource.html#cfn-cloudformation-customresource-servicetimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-customresource.html#cfn-cloudformation-customresource-servicetimeout</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getServiceTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCustomResourceProps> {
        java.lang.String serviceToken;
        java.lang.Number serviceTimeout;

        /**
         * Sets the value of {@link CfnCustomResourceProps#getServiceToken}
         * @param serviceToken The service token, such as an Amazon SNS topic ARN or Lambda function ARN. This parameter is required.
         *                     The service token must be from the same Region as the stack.
         *                     <p>
         *                     Updates aren't supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceToken(java.lang.String serviceToken) {
            this.serviceToken = serviceToken;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomResourceProps#getServiceTimeout}
         * @param serviceTimeout The maximum time, in seconds, that can elapse before a custom resource operation times out.
         *                       The value must be an integer from 1 to 3600. The default value is 3600 seconds (1 hour).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceTimeout(java.lang.Number serviceTimeout) {
            this.serviceTimeout = serviceTimeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCustomResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCustomResourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCustomResourceProps {
        private final java.lang.String serviceToken;
        private final java.lang.Number serviceTimeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceToken = software.amazon.jsii.Kernel.get(this, "serviceToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceTimeout = software.amazon.jsii.Kernel.get(this, "serviceTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceToken = java.util.Objects.requireNonNull(builder.serviceToken, "serviceToken is required");
            this.serviceTimeout = builder.serviceTimeout;
        }

        @Override
        public final java.lang.String getServiceToken() {
            return this.serviceToken;
        }

        @Override
        public final java.lang.Number getServiceTimeout() {
            return this.serviceTimeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceToken", om.valueToTree(this.getServiceToken()));
            if (this.getServiceTimeout() != null) {
                data.set("serviceTimeout", om.valueToTree(this.getServiceTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnCustomResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCustomResourceProps.Jsii$Proxy that = (CfnCustomResourceProps.Jsii$Proxy) o;

            if (!serviceToken.equals(that.serviceToken)) return false;
            return this.serviceTimeout != null ? this.serviceTimeout.equals(that.serviceTimeout) : that.serviceTimeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.serviceToken.hashCode();
            result = 31 * result + (this.serviceTimeout != null ? this.serviceTimeout.hashCode() : 0);
            return result;
        }
    }
}
