package software.amazon.awscdk;

/**
 * Initialization props for the <code>NestedStack</code> construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.constructs.Construct;
 * import software.amazon.awscdk.App;
 * import software.amazon.awscdk.CfnOutput;
 * import software.amazon.awscdk.NestedStack;
 * import software.amazon.awscdk.NestedStackProps;
 * import software.amazon.awscdk.Stack;
 * import software.amazon.awscdk.services.apigateway.Deployment;
 * import software.amazon.awscdk.services.apigateway.Method;
 * import software.amazon.awscdk.services.apigateway.MockIntegration;
 * import software.amazon.awscdk.services.apigateway.PassthroughBehavior;
 * import software.amazon.awscdk.services.apigateway.RestApi;
 * import software.amazon.awscdk.services.apigateway.Stage;
 * /**
 *  * This file showcases how to split up a RestApi's Resources and Methods across nested stacks.
 *  *
 *  * The root stack 'RootStack' first defines a RestApi.
 *  * Two nested stacks BooksStack and PetsStack, create corresponding Resources '/books' and '/pets'.
 *  * They are then deployed to a 'prod' Stage via a third nested stack - DeployStack.
 *  *
 *  * To verify this worked, go to the APIGateway
 *  *&#47;
 * public class RootStack extends Stack {
 *     public RootStack(Construct scope) {
 *         super(scope, "integ-restapi-import-RootStack");
 *         RestApi restApi = RestApi.Builder.create(this, "RestApi")
 *                 .cloudWatchRole(true)
 *                 .deploy(false)
 *                 .build();
 *         restApi.root.addMethod("ANY");
 *         PetsStack petsStack = new PetsStack(this, new ResourceNestedStackProps()
 *                 .restApiId(restApi.getRestApiId())
 *                 .rootResourceId(restApi.getRestApiRootResourceId())
 *                 );
 *         BooksStack booksStack = new BooksStack(this, new ResourceNestedStackProps()
 *                 .restApiId(restApi.getRestApiId())
 *                 .rootResourceId(restApi.getRestApiRootResourceId())
 *                 );
 *         new DeployStack(this, new DeployStackProps()
 *                 .restApiId(restApi.getRestApiId())
 *                 .methods(petsStack.methods.concat(booksStack.getMethods()))
 *                 );
 *         CfnOutput.Builder.create(this, "PetsURL")
 *                 .value(String.format("https://%s.execute-api.%s.amazonaws.com/prod/pets", restApi.getRestApiId(), this.region))
 *                 .build();
 *         CfnOutput.Builder.create(this, "BooksURL")
 *                 .value(String.format("https://%s.execute-api.%s.amazonaws.com/prod/books", restApi.getRestApiId(), this.region))
 *                 .build();
 *     }
 * }
 * public class ResourceNestedStackProps extends NestedStackProps {
 *     private String restApiId;
 *     public String getRestApiId() {
 *         return this.restApiId;
 *     }
 *     public ResourceNestedStackProps restApiId(String restApiId) {
 *         this.restApiId = restApiId;
 *         return this;
 *     }
 *     private String rootResourceId;
 *     public String getRootResourceId() {
 *         return this.rootResourceId;
 *     }
 *     public ResourceNestedStackProps rootResourceId(String rootResourceId) {
 *         this.rootResourceId = rootResourceId;
 *         return this;
 *     }
 * }
 * public class PetsStack extends NestedStack {
 *     public final Method[] methods;
 *     public PetsStack(Construct scope, ResourceNestedStackProps props) {
 *         super(scope, "integ-restapi-import-PetsStack", props);
 *         IRestApi api = RestApi.fromRestApiAttributes(this, "RestApi", RestApiAttributes.builder()
 *                 .restApiId(props.getRestApiId())
 *                 .rootResourceId(props.getRootResourceId())
 *                 .build());
 *         Method method = api.root.addResource("pets").addMethod("GET", MockIntegration.Builder.create()
 *                 .integrationResponses(List.of(IntegrationResponse.builder()
 *                         .statusCode("200")
 *                         .build()))
 *                 .passthroughBehavior(PassthroughBehavior.NEVER)
 *                 .requestTemplates(Map.of(
 *                         "application/json", "{ \"statusCode\": 200 }"))
 *                 .build(), MethodOptions.builder()
 *                 .methodResponses(List.of(MethodResponse.builder().statusCode("200").build()))
 *                 .build());
 *         this.methods.push(method);
 *     }
 * }
 * public class BooksStack extends NestedStack {
 *     public final Method[] methods;
 *     public BooksStack(Construct scope, ResourceNestedStackProps props) {
 *         super(scope, "integ-restapi-import-BooksStack", props);
 *         IRestApi api = RestApi.fromRestApiAttributes(this, "RestApi", RestApiAttributes.builder()
 *                 .restApiId(props.getRestApiId())
 *                 .rootResourceId(props.getRootResourceId())
 *                 .build());
 *         Method method = api.root.addResource("books").addMethod("GET", MockIntegration.Builder.create()
 *                 .integrationResponses(List.of(IntegrationResponse.builder()
 *                         .statusCode("200")
 *                         .build()))
 *                 .passthroughBehavior(PassthroughBehavior.NEVER)
 *                 .requestTemplates(Map.of(
 *                         "application/json", "{ \"statusCode\": 200 }"))
 *                 .build(), MethodOptions.builder()
 *                 .methodResponses(List.of(MethodResponse.builder().statusCode("200").build()))
 *                 .build());
 *         this.methods.push(method);
 *     }
 * }
 * public class DeployStackProps extends NestedStackProps {
 *     private String restApiId;
 *     public String getRestApiId() {
 *         return this.restApiId;
 *     }
 *     public DeployStackProps restApiId(String restApiId) {
 *         this.restApiId = restApiId;
 *         return this;
 *     }
 *     private Method[] methods;
 *     public Method[] getMethods() {
 *         return this.methods;
 *     }
 *     public DeployStackProps methods(Method[] methods) {
 *         this.methods = methods;
 *         return this;
 *     }
 * }
 * public class DeployStack extends NestedStack {
 *     public DeployStack(Construct scope, DeployStackProps props) {
 *         super(scope, "integ-restapi-import-DeployStack", props);
 *         Deployment deployment = Deployment.Builder.create(this, "Deployment")
 *                 .api(RestApi.fromRestApiId(this, "RestApi", props.getRestApiId()))
 *                 .build();
 *         if (props.getMethods()) {
 *             for (Object method : props.getMethods()) {
 *                 deployment.node.addDependency(method);
 *             }
 *         }
 *         Stage.Builder.create(this, "Stage").deployment(deployment).build();
 *     }
 * }
 * new RootStack(new App());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:22.141Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.NestedStackProps")
@software.amazon.jsii.Jsii.Proxy(NestedStackProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NestedStackProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the stack.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The Simple Notification Service (SNS) topics to publish stack related events.
     * <p>
     * Default: - notifications are not sent for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationArns() {
        return null;
    }

    /**
     * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
     * <p>
     * Each parameter has a name corresponding
     * to a parameter defined in the embedded template and a value representing
     * the value that you want to set for the parameter.
     * <p>
     * The nested stack construct will automatically synthesize parameters in order
     * to bind references from the parent stack(s) into the nested stack.
     * <p>
     * Default: - no user-defined parameters are passed to the nested stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getParameters() {
        return null;
    }

    /**
     * Policy to apply when the nested stack is removed.
     * <p>
     * The default is <code>Destroy</code>, because all Removal Policies of resources inside the
     * Nested Stack should already have been set correctly. You normally should
     * not need to set this value.
     * <p>
     * Default: RemovalPolicy.DESTROY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * The length of time that CloudFormation waits for the nested stack to reach the CREATE_COMPLETE state.
     * <p>
     * When CloudFormation detects that the nested stack has reached the
     * CREATE_COMPLETE state, it marks the nested stack resource as
     * CREATE_COMPLETE in the parent stack and resumes creating the parent stack.
     * If the timeout period expires before the nested stack reaches
     * CREATE_COMPLETE, CloudFormation marks the nested stack as failed and rolls
     * back both the nested stack and parent stack.
     * <p>
     * Default: - no timeout
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NestedStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NestedStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NestedStackProps> {
        java.lang.String description;
        java.util.List<java.lang.String> notificationArns;
        java.util.Map<java.lang.String, java.lang.String> parameters;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link NestedStackProps#getDescription}
         * @param description A description of the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link NestedStackProps#getNotificationArns}
         * @param notificationArns The Simple Notification Service (SNS) topics to publish stack related events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationArns(java.util.List<java.lang.String> notificationArns) {
            this.notificationArns = notificationArns;
            return this;
        }

        /**
         * Sets the value of {@link NestedStackProps#getParameters}
         * @param parameters The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
         *                   Each parameter has a name corresponding
         *                   to a parameter defined in the embedded template and a value representing
         *                   the value that you want to set for the parameter.
         *                   <p>
         *                   The nested stack construct will automatically synthesize parameters in order
         *                   to bind references from the parent stack(s) into the nested stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link NestedStackProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the nested stack is removed.
         *                      The default is <code>Destroy</code>, because all Removal Policies of resources inside the
         *                      Nested Stack should already have been set correctly. You normally should
         *                      not need to set this value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link NestedStackProps#getTimeout}
         * @param timeout The length of time that CloudFormation waits for the nested stack to reach the CREATE_COMPLETE state.
         *                When CloudFormation detects that the nested stack has reached the
         *                CREATE_COMPLETE state, it marks the nested stack resource as
         *                CREATE_COMPLETE in the parent stack and resumes creating the parent stack.
         *                If the timeout period expires before the nested stack reaches
         *                CREATE_COMPLETE, CloudFormation marks the nested stack as failed and rolls
         *                back both the nested stack and parent stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NestedStackProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NestedStackProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NestedStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NestedStackProps {
        private final java.lang.String description;
        private final java.util.List<java.lang.String> notificationArns;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notificationArns = software.amazon.jsii.Kernel.get(this, "notificationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.notificationArns = builder.notificationArns;
            this.parameters = builder.parameters;
            this.removalPolicy = builder.removalPolicy;
            this.timeout = builder.timeout;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getNotificationArns() {
            return this.notificationArns;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getNotificationArns() != null) {
                data.set("notificationArns", om.valueToTree(this.getNotificationArns()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.NestedStackProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NestedStackProps.Jsii$Proxy that = (NestedStackProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.notificationArns != null ? !this.notificationArns.equals(that.notificationArns) : that.notificationArns != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.notificationArns != null ? this.notificationArns.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
