package software.amazon.awscdk;

/**
 * Apply a permissions boundary to all IAM Roles and Users within a specific scope.
 * <p>
 * A permissions boundary is typically applied at the <code>Stage</code> scope.
 * This allows setting different permissions boundaries per Stage. For
 * example, you may <em>not</em> apply a boundary to the <code>Dev</code> stage which deploys
 * to a personal dev account, but you <em>do</em> apply the default boundary to the
 * <code>Prod</code> stage.
 * <p>
 * It is possible to apply different permissions boundaries to different scopes
 * within your app. In this case the most specifically applied one wins
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // no permissions boundary for dev stage
 * // no permissions boundary for dev stage
 * new Stage(app, "DevStage");
 * // default boundary for prod stage
 * Stage prodStage = Stage.Builder.create(app, "ProdStage")
 *         .permissionsBoundary(PermissionsBoundary.fromName("prod-pb"))
 *         .build();
 * // overriding the pb applied for this stack
 * // overriding the pb applied for this stack
 * Stack.Builder.create(prodStage, "ProdStack1")
 *         .permissionsBoundary(PermissionsBoundary.fromName("stack-pb"))
 *         .build();
 * // will inherit the permissions boundary from the stage
 * // will inherit the permissions boundary from the stage
 * new Stack(prodStage, "ProdStack2");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:22.142Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.PermissionsBoundary")
public class PermissionsBoundary extends software.amazon.jsii.JsiiObject {

    protected PermissionsBoundary(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PermissionsBoundary(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Apply a permissions boundary with the given ARN to all IAM Roles and Users created within a scope.
     * <p>
     * The arn can include placeholders for the partition, region, qualifier, and account
     * These placeholders will be replaced with the actual values if available. This requires
     * that the Stack has the environment specified, it does not work with environment
     * agnostic stacks.
     * <p>
     * <ul>
     * <li>'${AWS::Partition}'</li>
     * <li>'${AWS::Region}'</li>
     * <li>'${AWS::AccountId}'</li>
     * <li>'${Qualifier}'</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Stage.Builder.create(app, "ProdStage")
     *         .permissionsBoundary(PermissionsBoundary.fromArn("arn:aws:iam::${AWS::AccountId}:policy/my-custom-permissions-boundary"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @param arn the ARN of the permissions boundary policy. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.PermissionsBoundary fromArn(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.PermissionsBoundary.class, "fromArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.PermissionsBoundary.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Apply a permissions boundary with the given name to all IAM Roles and Users created within a scope.
     * <p>
     * The name can include placeholders for the partition, region, qualifier, and account
     * These placeholders will be replaced with the actual values if available. This requires
     * that the Stack has the environment specified, it does not work with environment
     * agnostic stacks.
     * <p>
     * <ul>
     * <li>'${AWS::Partition}'</li>
     * <li>'${AWS::Region}'</li>
     * <li>'${AWS::AccountId}'</li>
     * <li>'${Qualifier}'</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Stage.Builder.create(app, "ProdStage")
     *         .permissionsBoundary(PermissionsBoundary.fromName("my-custom-permissions-boundary"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @param name the name of the permissions boundary policy. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.PermissionsBoundary fromName(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.PermissionsBoundary.class, "fromName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.PermissionsBoundary.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }
}
