package software.amazon.awscdk;

/**
 * Violation produced by the validation plugin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * PolicyViolationBeta1 policyViolationBeta1 = PolicyViolationBeta1.builder()
 *         .description("description")
 *         .ruleName("ruleName")
 *         .violatingResources(List.of(PolicyViolatingResourceBeta1.builder()
 *                 .locations(List.of("locations"))
 *                 .resourceLogicalId("resourceLogicalId")
 *                 .templatePath("templatePath")
 *                 .build()))
 *         // the properties below are optional
 *         .fix("fix")
 *         .ruleMetadata(Map.of(
 *                 "ruleMetadataKey", "ruleMetadata"))
 *         .severity("severity")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:22.144Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.PolicyViolationBeta1")
@software.amazon.jsii.Jsii.Proxy(PolicyViolationBeta1.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PolicyViolationBeta1 extends software.amazon.jsii.JsiiSerializable {

    /**
     * The description of the violation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleName();

    /**
     * The resources violating this rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.PolicyViolatingResourceBeta1> getViolatingResources();

    /**
     * How to fix the violation.
     * <p>
     * Default: - no fix is provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFix() {
        return null;
    }

    /**
     * Additional metadata to include with the rule results.
     * <p>
     * This can be used to provide additional information that is
     * plugin specific. The data provided here will be rendered as is.
     * <p>
     * Default: - no rule metadata
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getRuleMetadata() {
        return null;
    }

    /**
     * The severity of the violation, only used for reporting purposes.
     * <p>
     * This is useful for helping the user discriminate between warnings,
     * errors, information, etc.
     * <p>
     * Default: - no severity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSeverity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PolicyViolationBeta1}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PolicyViolationBeta1}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PolicyViolationBeta1> {
        java.lang.String description;
        java.lang.String ruleName;
        java.util.List<software.amazon.awscdk.PolicyViolatingResourceBeta1> violatingResources;
        java.lang.String fix;
        java.util.Map<java.lang.String, java.lang.String> ruleMetadata;
        java.lang.String severity;

        /**
         * Sets the value of {@link PolicyViolationBeta1#getDescription}
         * @param description The description of the violation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link PolicyViolationBeta1#getRuleName}
         * @param ruleName The name of the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link PolicyViolationBeta1#getViolatingResources}
         * @param violatingResources The resources violating this rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder violatingResources(java.util.List<? extends software.amazon.awscdk.PolicyViolatingResourceBeta1> violatingResources) {
            this.violatingResources = (java.util.List<software.amazon.awscdk.PolicyViolatingResourceBeta1>)violatingResources;
            return this;
        }

        /**
         * Sets the value of {@link PolicyViolationBeta1#getFix}
         * @param fix How to fix the violation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fix(java.lang.String fix) {
            this.fix = fix;
            return this;
        }

        /**
         * Sets the value of {@link PolicyViolationBeta1#getRuleMetadata}
         * @param ruleMetadata Additional metadata to include with the rule results.
         *                     This can be used to provide additional information that is
         *                     plugin specific. The data provided here will be rendered as is.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleMetadata(java.util.Map<java.lang.String, java.lang.String> ruleMetadata) {
            this.ruleMetadata = ruleMetadata;
            return this;
        }

        /**
         * Sets the value of {@link PolicyViolationBeta1#getSeverity}
         * @param severity The severity of the violation, only used for reporting purposes.
         *                 This is useful for helping the user discriminate between warnings,
         *                 errors, information, etc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder severity(java.lang.String severity) {
            this.severity = severity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyViolationBeta1}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PolicyViolationBeta1 build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PolicyViolationBeta1}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyViolationBeta1 {
        private final java.lang.String description;
        private final java.lang.String ruleName;
        private final java.util.List<software.amazon.awscdk.PolicyViolatingResourceBeta1> violatingResources;
        private final java.lang.String fix;
        private final java.util.Map<java.lang.String, java.lang.String> ruleMetadata;
        private final java.lang.String severity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.violatingResources = software.amazon.jsii.Kernel.get(this, "violatingResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.PolicyViolatingResourceBeta1.class)));
            this.fix = software.amazon.jsii.Kernel.get(this, "fix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleMetadata = software.amazon.jsii.Kernel.get(this, "ruleMetadata", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.severity = software.amazon.jsii.Kernel.get(this, "severity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.ruleName = java.util.Objects.requireNonNull(builder.ruleName, "ruleName is required");
            this.violatingResources = (java.util.List<software.amazon.awscdk.PolicyViolatingResourceBeta1>)java.util.Objects.requireNonNull(builder.violatingResources, "violatingResources is required");
            this.fix = builder.fix;
            this.ruleMetadata = builder.ruleMetadata;
            this.severity = builder.severity;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.PolicyViolatingResourceBeta1> getViolatingResources() {
            return this.violatingResources;
        }

        @Override
        public final java.lang.String getFix() {
            return this.fix;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRuleMetadata() {
            return this.ruleMetadata;
        }

        @Override
        public final java.lang.String getSeverity() {
            return this.severity;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("description", om.valueToTree(this.getDescription()));
            data.set("ruleName", om.valueToTree(this.getRuleName()));
            data.set("violatingResources", om.valueToTree(this.getViolatingResources()));
            if (this.getFix() != null) {
                data.set("fix", om.valueToTree(this.getFix()));
            }
            if (this.getRuleMetadata() != null) {
                data.set("ruleMetadata", om.valueToTree(this.getRuleMetadata()));
            }
            if (this.getSeverity() != null) {
                data.set("severity", om.valueToTree(this.getSeverity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.PolicyViolationBeta1"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PolicyViolationBeta1.Jsii$Proxy that = (PolicyViolationBeta1.Jsii$Proxy) o;

            if (!description.equals(that.description)) return false;
            if (!ruleName.equals(that.ruleName)) return false;
            if (!violatingResources.equals(that.violatingResources)) return false;
            if (this.fix != null ? !this.fix.equals(that.fix) : that.fix != null) return false;
            if (this.ruleMetadata != null ? !this.ruleMetadata.equals(that.ruleMetadata) : that.ruleMetadata != null) return false;
            return this.severity != null ? this.severity.equals(that.severity) : that.severity == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + (this.ruleName.hashCode());
            result = 31 * result + (this.violatingResources.hashCode());
            result = 31 * result + (this.fix != null ? this.fix.hashCode() : 0);
            result = 31 * result + (this.ruleMetadata != null ? this.ruleMetadata.hashCode() : 0);
            result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
            return result;
        }
    }
}
