package software.amazon.awscdk.cloudformation.include;

/**
 * The type returned from <code>CfnInclude.getNestedStack</code>. Contains both the NestedStack object and CfnInclude representations of the child stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnInclude parentTemplate;
 * IncludedNestedStack includedChildStack = parentTemplate.getNestedStack("ChildStack");
 * NestedStack childStack = includedChildStack.getStack();
 * CfnInclude childTemplate = includedChildStack.getIncludedTemplate();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:38.962Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloudformation_include.IncludedNestedStack")
@software.amazon.jsii.Jsii.Proxy(IncludedNestedStack.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IncludedNestedStack extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CfnInclude that represents the template, which can be used to access Resources and other template elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudformation.include.CfnInclude getIncludedTemplate();

    /**
     * The NestedStack object which represents the scope of the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.NestedStack getStack();

    /**
     * @return a {@link Builder} of {@link IncludedNestedStack}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IncludedNestedStack}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IncludedNestedStack> {
        software.amazon.awscdk.cloudformation.include.CfnInclude includedTemplate;
        software.amazon.awscdk.NestedStack stack;

        /**
         * Sets the value of {@link IncludedNestedStack#getIncludedTemplate}
         * @param includedTemplate The CfnInclude that represents the template, which can be used to access Resources and other template elements. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includedTemplate(software.amazon.awscdk.cloudformation.include.CfnInclude includedTemplate) {
            this.includedTemplate = includedTemplate;
            return this;
        }

        /**
         * Sets the value of {@link IncludedNestedStack#getStack}
         * @param stack The NestedStack object which represents the scope of the template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stack(software.amazon.awscdk.NestedStack stack) {
            this.stack = stack;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IncludedNestedStack}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IncludedNestedStack build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IncludedNestedStack}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IncludedNestedStack {
        private final software.amazon.awscdk.cloudformation.include.CfnInclude includedTemplate;
        private final software.amazon.awscdk.NestedStack stack;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.includedTemplate = software.amazon.jsii.Kernel.get(this, "includedTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudformation.include.CfnInclude.class));
            this.stack = software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.NestedStack.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.includedTemplate = java.util.Objects.requireNonNull(builder.includedTemplate, "includedTemplate is required");
            this.stack = java.util.Objects.requireNonNull(builder.stack, "stack is required");
        }

        @Override
        public final software.amazon.awscdk.cloudformation.include.CfnInclude getIncludedTemplate() {
            return this.includedTemplate;
        }

        @Override
        public final software.amazon.awscdk.NestedStack getStack() {
            return this.stack;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("includedTemplate", om.valueToTree(this.getIncludedTemplate()));
            data.set("stack", om.valueToTree(this.getStack()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloudformation_include.IncludedNestedStack"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IncludedNestedStack.Jsii$Proxy that = (IncludedNestedStack.Jsii$Proxy) o;

            if (!includedTemplate.equals(that.includedTemplate)) return false;
            return this.stack.equals(that.stack);
        }

        @Override
        public final int hashCode() {
            int result = this.includedTemplate.hashCode();
            result = 31 * result + (this.stack.hashCode());
            return result;
        }
    }
}
