package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties to initialize an instance of <code>HttpApi</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpAlbIntegration;
 * ApplicationLoadBalancer lb;
 * ApplicationListener listener = lb.addListener("listener", BaseApplicationListenerProps.builder().port(80).build());
 * listener.addTargets("target", AddApplicationTargetsProps.builder()
 *         .port(80)
 *         .build());
 * HttpApi httpEndpoint = HttpApi.Builder.create(this, "HttpProxyPrivateApi")
 *         .defaultIntegration(HttpAlbIntegration.Builder.create("DefaultIntegration", listener)
 *                 .parameterMapping(new ParameterMapping().custom("myKey", "myValue"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:22.724Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpApiProps")
@software.amazon.jsii.Jsii.Proxy(HttpApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name for the HTTP API resource.
     * <p>
     * Default: - id of the HttpApi construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiName() {
        return null;
    }

    /**
     * Specifies a CORS configuration for an API.
     * <p>
     * Default: - CORS disabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.CorsPreflightOptions getCorsPreflight() {
        return null;
    }

    /**
     * Whether a default stage and deployment should be automatically created.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCreateDefaultStage() {
        return null;
    }

    /**
     * Default OIDC scopes attached to all routes in the gateway, unless explicitly configured on the route.
     * <p>
     * The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation.
     * <p>
     * Default: - no default authorization scopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDefaultAuthorizationScopes() {
        return null;
    }

    /**
     * Default Authorizer applied to all routes in the gateway.
     * <p>
     * Default: - no default authorizer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer getDefaultAuthorizer() {
        return null;
    }

    /**
     * Configure a custom domain with the API mapping resource to the HTTP API.
     * <p>
     * Default: - no default domain mapping configured. meaningless if `createDefaultStage` is `false`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions getDefaultDomainMapping() {
        return null;
    }

    /**
     * An integration that will be configured on the catch-all route ($default).
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration getDefaultIntegration() {
        return null;
    }

    /**
     * The description of the API.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies whether clients can invoke your API using the default endpoint.
     * <p>
     * By default, clients can invoke your API with the default
     * <code>https://{api_id}.execute-api.{region}.amazonaws.com</code> endpoint. Set this to
     * true if you would like clients to use your custom domain name.
     * <p>
     * Default: false execute-api endpoint enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableExecuteApiEndpoint() {
        return null;
    }

    /**
     * Whether to set the default route selection expression for the API.
     * <p>
     * When enabled, "${request.method} ${request.path}" is set as the default route selection expression.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRouteSelectionExpression() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpApiProps> {
        java.lang.String apiName;
        software.amazon.awscdk.services.apigatewayv2.CorsPreflightOptions corsPreflight;
        java.lang.Boolean createDefaultStage;
        java.util.List<java.lang.String> defaultAuthorizationScopes;
        software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer defaultAuthorizer;
        software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions defaultDomainMapping;
        software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration defaultIntegration;
        java.lang.String description;
        java.lang.Boolean disableExecuteApiEndpoint;
        java.lang.Boolean routeSelectionExpression;

        /**
         * Sets the value of {@link HttpApiProps#getApiName}
         * @param apiName Name for the HTTP API resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiName(java.lang.String apiName) {
            this.apiName = apiName;
            return this;
        }

        /**
         * Sets the value of {@link HttpApiProps#getCorsPreflight}
         * @param corsPreflight Specifies a CORS configuration for an API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsPreflight(software.amazon.awscdk.services.apigatewayv2.CorsPreflightOptions corsPreflight) {
            this.corsPreflight = corsPreflight;
            return this;
        }

        /**
         * Sets the value of {@link HttpApiProps#getCreateDefaultStage}
         * @param createDefaultStage Whether a default stage and deployment should be automatically created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createDefaultStage(java.lang.Boolean createDefaultStage) {
            this.createDefaultStage = createDefaultStage;
            return this;
        }

        /**
         * Sets the value of {@link HttpApiProps#getDefaultAuthorizationScopes}
         * @param defaultAuthorizationScopes Default OIDC scopes attached to all routes in the gateway, unless explicitly configured on the route.
         *                                   The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAuthorizationScopes(java.util.List<java.lang.String> defaultAuthorizationScopes) {
            this.defaultAuthorizationScopes = defaultAuthorizationScopes;
            return this;
        }

        /**
         * Sets the value of {@link HttpApiProps#getDefaultAuthorizer}
         * @param defaultAuthorizer Default Authorizer applied to all routes in the gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAuthorizer(software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer defaultAuthorizer) {
            this.defaultAuthorizer = defaultAuthorizer;
            return this;
        }

        /**
         * Sets the value of {@link HttpApiProps#getDefaultDomainMapping}
         * @param defaultDomainMapping Configure a custom domain with the API mapping resource to the HTTP API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultDomainMapping(software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions defaultDomainMapping) {
            this.defaultDomainMapping = defaultDomainMapping;
            return this;
        }

        /**
         * Sets the value of {@link HttpApiProps#getDefaultIntegration}
         * @param defaultIntegration An integration that will be configured on the catch-all route ($default).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration defaultIntegration) {
            this.defaultIntegration = defaultIntegration;
            return this;
        }

        /**
         * Sets the value of {@link HttpApiProps#getDescription}
         * @param description The description of the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link HttpApiProps#getDisableExecuteApiEndpoint}
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke your API using the default endpoint.
         *                                  By default, clients can invoke your API with the default
         *                                  <code>https://{api_id}.execute-api.{region}.amazonaws.com</code> endpoint. Set this to
         *                                  true if you would like clients to use your custom domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(java.lang.Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link HttpApiProps#getRouteSelectionExpression}
         * @param routeSelectionExpression Whether to set the default route selection expression for the API.
         *                                 When enabled, "${request.method} ${request.path}" is set as the default route selection expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSelectionExpression(java.lang.Boolean routeSelectionExpression) {
            this.routeSelectionExpression = routeSelectionExpression;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpApiProps {
        private final java.lang.String apiName;
        private final software.amazon.awscdk.services.apigatewayv2.CorsPreflightOptions corsPreflight;
        private final java.lang.Boolean createDefaultStage;
        private final java.util.List<java.lang.String> defaultAuthorizationScopes;
        private final software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer defaultAuthorizer;
        private final software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions defaultDomainMapping;
        private final software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration defaultIntegration;
        private final java.lang.String description;
        private final java.lang.Boolean disableExecuteApiEndpoint;
        private final java.lang.Boolean routeSelectionExpression;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiName = software.amazon.jsii.Kernel.get(this, "apiName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.corsPreflight = software.amazon.jsii.Kernel.get(this, "corsPreflight", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.CorsPreflightOptions.class));
            this.createDefaultStage = software.amazon.jsii.Kernel.get(this, "createDefaultStage", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.defaultAuthorizationScopes = software.amazon.jsii.Kernel.get(this, "defaultAuthorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.defaultAuthorizer = software.amazon.jsii.Kernel.get(this, "defaultAuthorizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer.class));
            this.defaultDomainMapping = software.amazon.jsii.Kernel.get(this, "defaultDomainMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions.class));
            this.defaultIntegration = software.amazon.jsii.Kernel.get(this, "defaultIntegration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableExecuteApiEndpoint = software.amazon.jsii.Kernel.get(this, "disableExecuteApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.routeSelectionExpression = software.amazon.jsii.Kernel.get(this, "routeSelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiName = builder.apiName;
            this.corsPreflight = builder.corsPreflight;
            this.createDefaultStage = builder.createDefaultStage;
            this.defaultAuthorizationScopes = builder.defaultAuthorizationScopes;
            this.defaultAuthorizer = builder.defaultAuthorizer;
            this.defaultDomainMapping = builder.defaultDomainMapping;
            this.defaultIntegration = builder.defaultIntegration;
            this.description = builder.description;
            this.disableExecuteApiEndpoint = builder.disableExecuteApiEndpoint;
            this.routeSelectionExpression = builder.routeSelectionExpression;
        }

        @Override
        public final java.lang.String getApiName() {
            return this.apiName;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.CorsPreflightOptions getCorsPreflight() {
            return this.corsPreflight;
        }

        @Override
        public final java.lang.Boolean getCreateDefaultStage() {
            return this.createDefaultStage;
        }

        @Override
        public final java.util.List<java.lang.String> getDefaultAuthorizationScopes() {
            return this.defaultAuthorizationScopes;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer getDefaultAuthorizer() {
            return this.defaultAuthorizer;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions getDefaultDomainMapping() {
            return this.defaultDomainMapping;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration getDefaultIntegration() {
            return this.defaultIntegration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getDisableExecuteApiEndpoint() {
            return this.disableExecuteApiEndpoint;
        }

        @Override
        public final java.lang.Boolean getRouteSelectionExpression() {
            return this.routeSelectionExpression;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiName() != null) {
                data.set("apiName", om.valueToTree(this.getApiName()));
            }
            if (this.getCorsPreflight() != null) {
                data.set("corsPreflight", om.valueToTree(this.getCorsPreflight()));
            }
            if (this.getCreateDefaultStage() != null) {
                data.set("createDefaultStage", om.valueToTree(this.getCreateDefaultStage()));
            }
            if (this.getDefaultAuthorizationScopes() != null) {
                data.set("defaultAuthorizationScopes", om.valueToTree(this.getDefaultAuthorizationScopes()));
            }
            if (this.getDefaultAuthorizer() != null) {
                data.set("defaultAuthorizer", om.valueToTree(this.getDefaultAuthorizer()));
            }
            if (this.getDefaultDomainMapping() != null) {
                data.set("defaultDomainMapping", om.valueToTree(this.getDefaultDomainMapping()));
            }
            if (this.getDefaultIntegration() != null) {
                data.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisableExecuteApiEndpoint() != null) {
                data.set("disableExecuteApiEndpoint", om.valueToTree(this.getDisableExecuteApiEndpoint()));
            }
            if (this.getRouteSelectionExpression() != null) {
                data.set("routeSelectionExpression", om.valueToTree(this.getRouteSelectionExpression()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.HttpApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpApiProps.Jsii$Proxy that = (HttpApiProps.Jsii$Proxy) o;

            if (this.apiName != null ? !this.apiName.equals(that.apiName) : that.apiName != null) return false;
            if (this.corsPreflight != null ? !this.corsPreflight.equals(that.corsPreflight) : that.corsPreflight != null) return false;
            if (this.createDefaultStage != null ? !this.createDefaultStage.equals(that.createDefaultStage) : that.createDefaultStage != null) return false;
            if (this.defaultAuthorizationScopes != null ? !this.defaultAuthorizationScopes.equals(that.defaultAuthorizationScopes) : that.defaultAuthorizationScopes != null) return false;
            if (this.defaultAuthorizer != null ? !this.defaultAuthorizer.equals(that.defaultAuthorizer) : that.defaultAuthorizer != null) return false;
            if (this.defaultDomainMapping != null ? !this.defaultDomainMapping.equals(that.defaultDomainMapping) : that.defaultDomainMapping != null) return false;
            if (this.defaultIntegration != null ? !this.defaultIntegration.equals(that.defaultIntegration) : that.defaultIntegration != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disableExecuteApiEndpoint != null ? !this.disableExecuteApiEndpoint.equals(that.disableExecuteApiEndpoint) : that.disableExecuteApiEndpoint != null) return false;
            return this.routeSelectionExpression != null ? this.routeSelectionExpression.equals(that.routeSelectionExpression) : that.routeSelectionExpression == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiName != null ? this.apiName.hashCode() : 0;
            result = 31 * result + (this.corsPreflight != null ? this.corsPreflight.hashCode() : 0);
            result = 31 * result + (this.createDefaultStage != null ? this.createDefaultStage.hashCode() : 0);
            result = 31 * result + (this.defaultAuthorizationScopes != null ? this.defaultAuthorizationScopes.hashCode() : 0);
            result = 31 * result + (this.defaultAuthorizer != null ? this.defaultAuthorizer.hashCode() : 0);
            result = 31 * result + (this.defaultDomainMapping != null ? this.defaultDomainMapping.hashCode() : 0);
            result = 31 * result + (this.defaultIntegration != null ? this.defaultIntegration.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disableExecuteApiEndpoint != null ? this.disableExecuteApiEndpoint.hashCode() : 0);
            result = 31 * result + (this.routeSelectionExpression != null ? this.routeSelectionExpression.hashCode() : 0);
            return result;
        }
    }
}
