package software.amazon.awscdk.services.appconfig;

/**
 * A sourced configuration represents configuration stored in an Amazon S3 bucket, AWS Secrets Manager secret, Systems Manager (SSM) Parameter Store parameter, SSM document, or AWS CodePipeline.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application application;
 * Bucket bucket;
 * SourcedConfiguration.Builder.create(this, "MySourcedConfiguration")
 *         .application(application)
 *         .location(ConfigurationSource.fromBucket(bucket, "path/to/file.json"))
 *         .type(ConfigurationType.FEATURE_FLAGS)
 *         .name("MyConfig")
 *         .description("This is my sourced configuration from CDK.")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:22.921Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.SourcedConfiguration")
public class SourcedConfiguration extends software.constructs.Construct implements software.amazon.awscdk.services.appconfig.IConfiguration, software.amazon.awscdk.services.appconfig.IExtensible {

    protected SourcedConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SourcedConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SourcedConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.SourcedConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addExistingEnvironmentsToApplication() {
        software.amazon.jsii.Kernel.call(this, "addExistingEnvironmentsToApplication", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Adds an extension association to the configuration profile.
     * <p>
     * @param extension The extension to create an association for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addExtension(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IExtension extension) {
        software.amazon.jsii.Kernel.call(this, "addExtension", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(extension, "extension is required") });
    }

    /**
     * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "atDeploymentTick", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "atDeploymentTick", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void deployConfigToEnvironments() {
        software.amazon.jsii.Kernel.call(this, "deployConfigToEnvironments", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Adds an extension defined by the action point and event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param actionPoint The action point which triggers the event. This parameter is required.
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an extension defined by the action point and event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param actionPoint The action point which triggers the event. This parameter is required.
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
        software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
    }

    /**
     * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the configuration profile.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
        software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
    }

    /**
     * The application associated with the configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IApplication getApplication() {
        return software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IApplication.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the configuration profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfigurationProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "configurationProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the configuration profile.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfigurationProfileId() {
        return software.amazon.jsii.Kernel.get(this, "configurationProfileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location where the configuration is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationSource getLocation() {
        return software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationSource.class));
    }

    /**
     * The deployment key for the configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getDeploymentKey() {
        return software.amazon.jsii.Kernel.get(this, "deploymentKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * The deployment strategy for the configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.IDeploymentStrategy getDeploymentStrategy() {
        return software.amazon.jsii.Kernel.get(this, "deploymentStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IDeploymentStrategy.class));
    }

    /**
     * The environments to deploy to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.IEnvironment> getDeployTo() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appconfig.IEnvironment>)(software.amazon.jsii.Kernel.get(this, "deployTo", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IEnvironment.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The description of the configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role to retrieve the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRetrievalRole() {
        return software.amazon.jsii.Kernel.get(this, "retrievalRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * The key to decrypt the configuration if applicable.
     * <p>
     * This key
     * can be used when storing configuration in AWS Secrets Manager, Systems Manager Parameter Store,
     * or Amazon S3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getSourceKey() {
        return software.amazon.jsii.Kernel.get(this, "sourceKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * The configuration type.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ConfigurationType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationType.class));
    }

    /**
     * The validators for the configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.IValidator> getValidators() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appconfig.IValidator>)(software.amazon.jsii.Kernel.get(this, "validators", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IValidator.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The version number of the configuration to deploy.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVersionNumber() {
        return software.amazon.jsii.Kernel.get(this, "versionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setApplicationId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationId", java.util.Objects.requireNonNull(value, "applicationId is required"));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ExtensibleBase getExtensible() {
        return software.amazon.jsii.Kernel.get(this, "extensible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ExtensibleBase.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setExtensible(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ExtensibleBase value) {
        software.amazon.jsii.Kernel.set(this, "extensible", java.util.Objects.requireNonNull(value, "extensible is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appconfig.SourcedConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appconfig.SourcedConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appconfig.SourcedConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appconfig.SourcedConfigurationProps.Builder();
        }

        /**
         * The deployment key of the configuration.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param deploymentKey The deployment key of the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentKey(final software.amazon.awscdk.services.kms.IKey deploymentKey) {
            this.props.deploymentKey(deploymentKey);
            return this;
        }

        /**
         * The deployment strategy for the configuration.
         * <p>
         * Default: - A deployment strategy with the rollout strategy set to
         * RolloutStrategy.CANARY_10_PERCENT_20_MINUTES
         * <p>
         * @return {@code this}
         * @param deploymentStrategy The deployment strategy for the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentStrategy(final software.amazon.awscdk.services.appconfig.IDeploymentStrategy deploymentStrategy) {
            this.props.deploymentStrategy(deploymentStrategy);
            return this;
        }

        /**
         * The list of environments to deploy the configuration to.
         * <p>
         * If this parameter is not specified, then there will be no
         * deployment created alongside this configuration.
         * <p>
         * Deployments can be added later using the <code>IEnvironment.addDeployment</code> or
         * <code>IEnvironment.addDeployments</code> methods.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param deployTo The list of environments to deploy the configuration to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployTo(final java.util.List<? extends software.amazon.awscdk.services.appconfig.IEnvironment> deployTo) {
            this.props.deployTo(deployTo);
            return this;
        }

        /**
         * The description of the configuration.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description The description of the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the configuration.
         * <p>
         * Default: - A name is generated.
         * <p>
         * @return {@code this}
         * @param name The name of the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The type of configuration.
         * <p>
         * Default: ConfigurationType.FREEFORM
         * <p>
         * @return {@code this}
         * @param type The type of configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.appconfig.ConfigurationType type) {
            this.props.type(type);
            return this;
        }

        /**
         * The validators for the configuration.
         * <p>
         * Default: - No validators.
         * <p>
         * @return {@code this}
         * @param validators The validators for the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validators(final java.util.List<? extends software.amazon.awscdk.services.appconfig.IValidator> validators) {
            this.props.validators(validators);
            return this;
        }

        /**
         * The application associated with the configuration.
         * <p>
         * @return {@code this}
         * @param application The application associated with the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(final software.amazon.awscdk.services.appconfig.IApplication application) {
            this.props.application(application);
            return this;
        }

        /**
         * The location where the configuration is stored.
         * <p>
         * @return {@code this}
         * @param location The location where the configuration is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder location(final software.amazon.awscdk.services.appconfig.ConfigurationSource location) {
            this.props.location(location);
            return this;
        }

        /**
         * The IAM role to retrieve the configuration.
         * <p>
         * Default: - Auto generated if location type is not ConfigurationSourceType.CODE_PIPELINE otherwise no role specified.
         * <p>
         * @return {@code this}
         * @param retrievalRole The IAM role to retrieve the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retrievalRole(final software.amazon.awscdk.services.iam.IRole retrievalRole) {
            this.props.retrievalRole(retrievalRole);
            return this;
        }

        /**
         * The version number of the sourced configuration to deploy.
         * <p>
         * If this is not specified,
         * then there will be no deployment.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param versionNumber The version number of the sourced configuration to deploy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionNumber(final java.lang.String versionNumber) {
            this.props.versionNumber(versionNumber);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appconfig.SourcedConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appconfig.SourcedConfiguration build() {
            return new software.amazon.awscdk.services.appconfig.SourcedConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
