package software.amazon.awscdk.services.appmesh;

/**
 * All Properties for Envoy Access Logging Format for mesh endpoints.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * LoggingFormatConfig loggingFormatConfig = LoggingFormatConfig.builder()
 *         .formatConfig(LoggingFormatProperty.builder()
 *                 .json(List.of(JsonFormatRefProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .text("text")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:23.321Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.LoggingFormatConfig")
@software.amazon.jsii.Jsii.Proxy(LoggingFormatConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoggingFormatConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * CFN configuration for Access Logging Format.
     * <p>
     * Default: - no access logging format
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnVirtualNode.LoggingFormatProperty getFormatConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoggingFormatConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoggingFormatConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoggingFormatConfig> {
        software.amazon.awscdk.services.appmesh.CfnVirtualNode.LoggingFormatProperty formatConfig;

        /**
         * Sets the value of {@link LoggingFormatConfig#getFormatConfig}
         * @param formatConfig CFN configuration for Access Logging Format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder formatConfig(software.amazon.awscdk.services.appmesh.CfnVirtualNode.LoggingFormatProperty formatConfig) {
            this.formatConfig = formatConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoggingFormatConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoggingFormatConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoggingFormatConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingFormatConfig {
        private final software.amazon.awscdk.services.appmesh.CfnVirtualNode.LoggingFormatProperty formatConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.formatConfig = software.amazon.jsii.Kernel.get(this, "formatConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnVirtualNode.LoggingFormatProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.formatConfig = builder.formatConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnVirtualNode.LoggingFormatProperty getFormatConfig() {
            return this.formatConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFormatConfig() != null) {
                data.set("formatConfig", om.valueToTree(this.getFormatConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.LoggingFormatConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoggingFormatConfig.Jsii$Proxy that = (LoggingFormatConfig.Jsii$Proxy) o;

            return this.formatConfig != null ? this.formatConfig.equals(that.formatConfig) : that.formatConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.formatConfig != null ? this.formatConfig.hashCode() : 0;
            return result;
        }
    }
}
