package software.amazon.awscdk.services.autoscaling;

/**
 * Supported EBS volume types for blockDevices.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * AutoScalingGroup autoScalingGroup = AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         .blockDevices(List.of(BlockDevice.builder()
 *                 .deviceName("gp3-volume")
 *                 .volume(BlockDeviceVolume.ebs(15, EbsDeviceOptions.builder()
 *                         .volumeType(EbsDeviceVolumeType.GP3)
 *                         .throughput(125)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:23.838Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.EbsDeviceVolumeType")
public enum EbsDeviceVolumeType {
    /**
     * Magnetic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Provisioned IOPS SSD - IO1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO1,
    /**
     * General Purpose SSD - GP2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GP2,
    /**
     * General Purpose SSD - GP3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GP3,
    /**
     * Throughput Optimized HDD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ST1,
    /**
     * Cold HDD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SC1,
}
