package software.amazon.awscdk.services.bedrock;

/**
 * The model identifiers for the Bedrock base foundation models.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * FoundationModel model = FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.AMAZON_TITAN_TEXT_G1_EXPRESS_V1);
 * BedrockInvokeModel task = BedrockInvokeModel.Builder.create(this, "Prompt Model")
 *         .model(model)
 *         .input(BedrockInvokeModelInputProps.builder().s3InputUri(JsonPath.stringAt("$.prompt")).build())
 *         .output(BedrockInvokeModelOutputProps.builder().s3OutputUri(JsonPath.stringAt("$.prompt")).build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html">https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:24.389Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.FoundationModelIdentifier")
public class FoundationModelIdentifier extends software.amazon.jsii.JsiiObject {

    protected FoundationModelIdentifier(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FoundationModelIdentifier(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AI21_J2_GRANDE_INSTRUCT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_J2_GRANDE_INSTRUCT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AI21_J2_JAMBA_INSTRUCT_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_J2_JAMBA_INSTRUCT_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AI21_J2_JUMBO_INSTRUCT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_J2_JUMBO_INSTRUCT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AI21_J2_MID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_J2_MID", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AI21_J2_ULTRA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_J2_ULTRA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AI21_JAMBA_1_5_LARGE_V_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_JAMBA_1_5_LARGE_V_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AI21_JAMBA_1_5_MINI_V_1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_JAMBA_1_5_MINI_V_1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AI21_LABS_JURASSIC_2_MID_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_LABS_JURASSIC_2_MID_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AI21_LABS_JURASSIC_2_ULTRA_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_LABS_JURASSIC_2_ULTRA_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AI21_LABS_JURASSIC_2_ULTRA_V1_0_8_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AI21_LABS_JURASSIC_2_ULTRA_V1_0_8K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_NOVA_CANVAS_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_NOVA_CANVAS_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_NOVA_LITE_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_NOVA_LITE_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_NOVA_LITE_V1_0_300_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_NOVA_LITE_V1_0_300_K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_NOVA_MICRO_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_NOVA_MICRO_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_NOVA_MICRO_V1_0_128_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_NOVA_MICRO_V1_0_128_K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_NOVA_PRO_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_NOVA_PRO_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_NOVA_PRO_V1_0_300_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_NOVA_PRO_V1_0_300_K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_NOVA_REEL_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_NOVA_REEL_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_RERANK_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_RERANK_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_EMBED_G1_TEXT_02 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_EMBED_G1_TEXT_02", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_EMBED_IMAGE_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_EMBED_IMAGE_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_EMBED_TEXT_V1_2_8_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_EMBED_TEXT_V1_2_8K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_EMBED_TEXT_V2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_EMBED_TEXT_V2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_EMBED_TEXT_V2_0_8_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_EMBED_TEXT_V2_0_8K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_EMBEDDINGS_G1_TEXT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_EMBEDDINGS_G1_TEXT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_IMAGE_GENERATOR_G1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_IMAGE_GENERATOR_G1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_IMAGE_GENERATOR_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_IMAGE_GENERATOR_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_IMAGE_GENERATOR_V2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_IMAGE_GENERATOR_V2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_MULTIMODAL_EMBEDDINGS_G1_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_MULTIMODAL_EMBEDDINGS_G1_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_TEXT_EXPRESS_V1_0_8_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_TEXT_EXPRESS_V1_0_8K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_TEXT_G1_EXPRESS_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_TEXT_G1_EXPRESS_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_TEXT_G1_LITE_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_TEXT_G1_LITE_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_TEXT_LITE_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_TEXT_LITE_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_TEXT_LITE_V1_0_4_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_TEXT_LITE_V1_0_4K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_TEXT_PREMIER_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_TEXT_PREMIER_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        AMAZON_TITAN_TG1_LARGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "AMAZON_TITAN_TG1_LARGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_5_HAIKU_20241022_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_5_HAIKU_20241022_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0_18_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0_18K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0_200_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0_200K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0_51_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0_51K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0_18_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0_18K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0_200_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0_200K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0_51_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0_51K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_HAIKU_20240307_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_HAIKU_20240307_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_HAIKU_20240307_V1_0_200_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_HAIKU_20240307_V1_0_200K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_HAIKU_20240307_V1_0_48_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_HAIKU_20240307_V1_0_48K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0_12_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0_12K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0_200_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0_200K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0_28_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0_28K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_SONNET_20240229_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_SONNET_20240229_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_SONNET_20240229_V1_0_200_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_SONNET_20240229_V1_0_200K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_3_SONNET_20240229_V1_0_28_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_3_SONNET_20240229_V1_0_28K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_INSTANT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_INSTANT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_INSTANT_V1_2_100_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_INSTANT_V1_2_100K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_V2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_V2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_V2_0_100_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_V2_0_100K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_V2_0_18_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_V2_0_18K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_V2_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_V2_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_V2_1_18_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_V2_1_18K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        ANTHROPIC_CLAUDE_V2_1_200_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "ANTHROPIC_CLAUDE_V2_1_200K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_COMMAND_LIGHT_TEXT_V14_7_4_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_COMMAND_LIGHT_TEXT_V14_7_4K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_COMMAND_LIGHT_V14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_COMMAND_LIGHT_V14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_COMMAND_R_PLUS_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_COMMAND_R_PLUS_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_COMMAND_R_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_COMMAND_R_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_COMMAND_TEXT_V14_7_4_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_COMMAND_TEXT_V14_7_4K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_COMMAND_V14 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_COMMAND_V14", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_EMBED_ENGLISH_V3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_EMBED_ENGLISH_V3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_EMBED_ENGLISH_V3_0_512 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_EMBED_ENGLISH_V3_0_512", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_EMBED_MULTILINGUAL_V3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_EMBED_MULTILINGUAL_V3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_EMBED_MULTILINGUAL_V3_0_512 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_EMBED_MULTILINGUAL_V3_0_512", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        COHERE_RERANK_V3_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "COHERE_RERANK_V3_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        LUMA_RAY_V2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "LUMA_RAY_V2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_2_13_B_CHAT_V1_0_4_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_2_13B_CHAT_V1_0_4K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_2_13_B_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_2_13B_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_2_13_B_V1_0_4_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_2_13B_V1_0_4K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_2_70_B_CHAT_V1_0_4_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_2_70B_CHAT_V1_0_4K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_2_70_B_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_2_70B_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_2_70_B_V1_0_4_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_2_70B_V1_0_4K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_2_CHAT_13_B_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_2_CHAT_13B_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_2_CHAT_70_B_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_2_CHAT_70B_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_1_405_INSTRUCT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_1_405_INSTRUCT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_1_70_INSTRUCT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_1_70_INSTRUCT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_1_70_INSTRUCT_V1_128_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_1_70_INSTRUCT_V1_128K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_1_8_B_INSTRUCT_V_128_K = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_1_8B_INSTRUCT_V_128K", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_1_8_B_INSTRUCT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_1_8B_INSTRUCT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_2_11_B_INSTRUCT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_2_11B_INSTRUCT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_2_1_B_INSTRUCT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_2_1B_INSTRUCT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_2_3_B_INSTRUCT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_2_3B_INSTRUCT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_2_90_B_INSTRUCT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_2_90B_INSTRUCT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_3_70_B_INSTRUCT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_3_70B_INSTRUCT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_70_INSTRUCT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_70_INSTRUCT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        META_LLAMA_3_8_B_INSTRUCT_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "META_LLAMA_3_8B_INSTRUCT_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        MISTRAL_LARGE_2_V0_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "MISTRAL_LARGE_2_V0_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        MISTRAL_LARGE_V0_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "MISTRAL_LARGE_V0_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        MISTRAL_MISTRAL_7_B_INSTRUCT_V0_2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "MISTRAL_MISTRAL_7B_INSTRUCT_V0_2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        MISTRAL_MIXTRAL_8_X7_B_INSTRUCT_V0_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "MISTRAL_MIXTRAL_8X7B_INSTRUCT_V0_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        MISTRAL_SMALL_V0_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "MISTRAL_SMALL_V0_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_SD3_5_LARGE_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_SD3_5_LARGE_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_SD3_LARGE_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_SD3_LARGE_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_STABLE_DIFFUSION_XL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_STABLE_DIFFUSION_XL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_STABLE_DIFFUSION_XL_V0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_STABLE_DIFFUSION_XL_V0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_STABLE_DIFFUSION_XL_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_STABLE_DIFFUSION_XL_V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_STABLE_DIFFUSION_XL_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_STABLE_DIFFUSION_XL_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_STABLE_IMAGE_CORE_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_STABLE_IMAGE_CORE_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_STABLE_IMAGE_CORE_V1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_STABLE_IMAGE_CORE_V1_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_STABLE_IMAGE_ULTRA_V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_STABLE_IMAGE_ULTRA_V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
        STABILITY_STABLE_IMAGE_ULTRA_V1_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class, "STABILITY_STABLE_IMAGE_ULTRA_V1_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.FoundationModelIdentifier.class));
    }

    /**
     * Constructor for foundation model identifier.
     * <p>
     * @param modelId the model identifier. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FoundationModelIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String modelId) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(modelId, "modelId is required") });
    }

    /**
     * (deprecated) Base model "ai21.j2-grande-instruct".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_J2_GRANDE_INSTRUCT;

    /**
     * Base model "ai21.jamba-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_J2_JAMBA_INSTRUCT_V1_0;

    /**
     * (deprecated) Base model "ai21.j2-jumbo-instruct".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_J2_JUMBO_INSTRUCT;

    /**
     * (deprecated) Base model "ai21.j2-mid".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_J2_MID;

    /**
     * (deprecated) Base model "ai21.j2-ultra".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_J2_ULTRA;

    /**
     * Base model "ai21.jamba-1-5-large-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_JAMBA_1_5_LARGE_V_1_0;

    /**
     * Base model "ai21.jamba-1-5-mini-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_JAMBA_1_5_MINI_V_1_0;

    /**
     * (deprecated) Base model "ai21.j2-mid-v1".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_LABS_JURASSIC_2_MID_V1;

    /**
     * (deprecated) Base model "ai21.j2-ultra-v1".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_LABS_JURASSIC_2_ULTRA_V1;

    /**
     * (deprecated) Base model "ai21.j2-ultra-v1:0:8k".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AI21_LABS_JURASSIC_2_ULTRA_V1_0_8_K;

    /**
     * Base model "amazon.nova-canvas-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_NOVA_CANVAS_V1_0;

    /**
     * Base model "amazon.nova-lite-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_NOVA_LITE_V1_0;

    /**
     * Base model "amazon.nova-lite-v1:0:300k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_NOVA_LITE_V1_0_300_K;

    /**
     * Base model "amazon.nova-micro-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_NOVA_MICRO_V1_0;

    /**
     * Base model "amazon.nova-micro-v1:0:128k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_NOVA_MICRO_V1_0_128_K;

    /**
     * Base model "amazon.nova-pro-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_NOVA_PRO_V1_0;

    /**
     * Base model "amazon.nova-pro-v1:0:300k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_NOVA_PRO_V1_0_300_K;

    /**
     * Base model "amazon.nova-reel-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_NOVA_REEL_V1_0;

    /**
     * Base model "amazon.rerank-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_RERANK_V1;

    /**
     * Base model "amazon.titan-embed-g1-text-02".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_EMBED_G1_TEXT_02;

    /**
     * Base model "amazon.titan-embed-image-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_EMBED_IMAGE_V1_0;

    /**
     * Base model "amazon.titan-embed-text-v1:2:8k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_EMBED_TEXT_V1_2_8_K;

    /**
     * Base model "amazon.titan-embed-text-v2:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_EMBED_TEXT_V2_0;

    /**
     * Base model "amazon.titan-embed-text-v2:0:8k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_EMBED_TEXT_V2_0_8_K;

    /**
     * Base model "amazon.titan-embed-text-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_EMBEDDINGS_G1_TEXT_V1;

    /**
     * Base model "amazon.titan-image-generator-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_IMAGE_GENERATOR_G1_V1;

    /**
     * Base model "amazon.titan-image-generator-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_IMAGE_GENERATOR_V1_0;

    /**
     * Base model "amazon.titan-image-generator-v2:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_IMAGE_GENERATOR_V2_0;

    /**
     * Base model "amazon.titan-embed-image-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_MULTIMODAL_EMBEDDINGS_G1_V1;

    /**
     * Base model "amazon.titan-text-express-v1:0:8k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_TEXT_EXPRESS_V1_0_8_K;

    /**
     * Base model "amazon.titan-text-express-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_TEXT_G1_EXPRESS_V1;

    /**
     * Base model "amazon.titan-text-lite-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_TEXT_G1_LITE_V1;

    /**
     * Base model "amazon.titan-text-lite-v1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_TEXT_LITE_V1;

    /**
     * Base model "amazon.titan-text-lite-v1:0:4k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_TEXT_LITE_V1_0_4_K;

    /**
     * Base model "amazon.titan-text-premier-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_TEXT_PREMIER_V1;

    /**
     * Base model "amazon.titan-tg1-large".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier AMAZON_TITAN_TG1_LARGE;

    /**
     * Base model "anthropic.claude-3-5-haiku-20241022-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_5_HAIKU_20241022_V1_0;

    /**
     * Base model "anthropic.claude-3-5-sonnet-20240620-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0;

    /**
     * Base model "anthropic.claude-3-5-sonnet-20240620-v1:0:18k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0_18_K;

    /**
     * Base model "anthropic.claude-3-5-sonnet-20240620-v1:0:200k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0_200_K;

    /**
     * Base model "anthropic.claude-3-5-sonnet-20240620-v1:0:51k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_5_SONNET_20240620_V1_0_51_K;

    /**
     * Base model "anthropic.claude-3-5-sonnet-20241022-v2:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0;

    /**
     * Base model "anthropic.claude-3-5-sonnet-20241022-v2:0:18k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0_18_K;

    /**
     * Base model "anthropic.claude-3-5-sonnet-20241022-v2:0:200k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0_200_K;

    /**
     * Base model "anthropic.claude-3-5-sonnet-20241022-v2:0:51k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_5_SONNET_20241022_V2_0_51_K;

    /**
     * Base model "anthropic.claude-3-haiku-20240307-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_HAIKU_20240307_V1_0;

    /**
     * Base model "anthropic.claude-3-haiku-20240307-v1:0:200k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_HAIKU_20240307_V1_0_200_K;

    /**
     * Base model "anthropic.claude-3-haiku-20240307-v1:0:48k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_HAIKU_20240307_V1_0_48_K;

    /**
     * Base model "anthropic.claude-3-opus-20240229-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0;

    /**
     * Base model "anthropic.claude-3-opus-20240229-v1:0:12k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0_12_K;

    /**
     * Base model "anthropic.claude-3-opus-20240229-v1:0:200k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0_200_K;

    /**
     * Base model "anthropic.claude-3-opus-20240229-v1:0:28k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_OPUS_20240229_V1_0_28_K;

    /**
     * Base model "anthropic.claude-3-sonnet-20240229-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_SONNET_20240229_V1_0;

    /**
     * Base model "anthropic.claude-3-sonnet-20240229-v1:0:200k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_SONNET_20240229_V1_0_200_K;

    /**
     * Base model "anthropic.claude-3-sonnet-20240229-v1:0:28k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_3_SONNET_20240229_V1_0_28_K;

    /**
     * (deprecated) Base model "anthropic.claude-instant-v1".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_INSTANT_V1;

    /**
     * (deprecated) Base model "anthropic.claude-instant-v1:2:100k".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_INSTANT_V1_2_100_K;

    /**
     * (deprecated) Base model "anthropic.claude-v1".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_V1;

    /**
     * (deprecated) Base model "anthropic.claude-v2".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_V2;

    /**
     * (deprecated) Base model "anthropic.claude-v2:0:100k".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_V2_0_100_K;

    /**
     * (deprecated) Base model "anthropic.claude-v2:0:18k".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_V2_0_18_K;

    /**
     * (deprecated) Base model "anthropic.claude-v2:1".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_V2_1;

    /**
     * (deprecated) Base model "anthropic.claude-v2:1:18k".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_V2_1_18_K;

    /**
     * (deprecated) Base model "anthropic.claude-v2:1:200k".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier ANTHROPIC_CLAUDE_V2_1_200_K;

    /**
     * Base model "cohere.command-light-text-v14:7:4k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_COMMAND_LIGHT_TEXT_V14_7_4_K;

    /**
     * Base model "cohere.command-light-text-v14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_COMMAND_LIGHT_V14;

    /**
     * Base model "cohere.command-r-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_COMMAND_R_PLUS_V1;

    /**
     * Base model "cohere.command-r-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_COMMAND_R_V1;

    /**
     * Base model "cohere.command-text-v14:7:4k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_COMMAND_TEXT_V14_7_4_K;

    /**
     * Base model "cohere.command-text-v14".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_COMMAND_V14;

    /**
     * Base model "cohere.embed-english-v3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_EMBED_ENGLISH_V3;

    /**
     * Base model "cohere.embed-english-v3:0:512".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_EMBED_ENGLISH_V3_0_512;

    /**
     * Base model "cohere.embed-multilingual-v3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_EMBED_MULTILINGUAL_V3;

    /**
     * Base model "cohere.embed-multilingual-v3:0:512".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_EMBED_MULTILINGUAL_V3_0_512;

    /**
     * Base model "cohere.rerank-v3-5:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier COHERE_RERANK_V3_5;

    /**
     * Base model "luma.ray-v2:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier LUMA_RAY_V2_0;

    /**
     * (deprecated) Base model "meta.llama2-13b-chat-v1:0:4k".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_2_13_B_CHAT_V1_0_4_K;

    /**
     * (deprecated) Base model "meta.llama2-13b-v1".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_2_13_B_V1;

    /**
     * (deprecated) Base model "meta.llama2-13b-v1:0:4k".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_2_13_B_V1_0_4_K;

    /**
     * (deprecated) Base model "meta.llama2-70b-chat-v1:0:4k".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_2_70_B_CHAT_V1_0_4_K;

    /**
     * (deprecated) Base model "meta.llama2-70b-v1".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_2_70_B_V1;

    /**
     * (deprecated) Base model "meta.llama2-70b-v1:0:4k".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_2_70_B_V1_0_4_K;

    /**
     * (deprecated) Base model "meta.llama2-13b-chat-v1".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_2_CHAT_13_B_V1;

    /**
     * (deprecated) Base model "meta.llama2-70b-chat-v1".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_2_CHAT_70_B_V1;

    /**
     * Base model "meta.llama3-1-405b-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_1_405_INSTRUCT_V1;

    /**
     * Base model "meta.llama3-1-70b-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_1_70_INSTRUCT_V1;

    /**
     * Base model "meta.llama3-1-70b-instruct-v1:0:128k".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_1_70_INSTRUCT_V1_128_K;

    /**
     * Base model "meta.llama3-1-8b-instruct-v1:0:128".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_1_8_B_INSTRUCT_V_128_K;

    /**
     * Base model "meta.llama3-1-8b-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_1_8_B_INSTRUCT_V1;

    /**
     * Base model "meta.llama3-2-11b-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_2_11_B_INSTRUCT_V1;

    /**
     * Base model "meta.llama3-2-1b-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_2_1_B_INSTRUCT_V1;

    /**
     * Base model "meta.llama3-2-3b-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_2_3_B_INSTRUCT_V1;

    /**
     * Base model "meta.llama3-2-90b-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_2_90_B_INSTRUCT_V1;

    /**
     * Base model "meta.llama3-3-70b-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_3_70_B_INSTRUCT_V1;

    /**
     * Base model "meta.llama3-70b-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_70_INSTRUCT_V1;

    /**
     * Base model "meta.llama3-8b-instruct-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier META_LLAMA_3_8_B_INSTRUCT_V1;

    /**
     * Base model "mistral.mistral-large-2407-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier MISTRAL_LARGE_2_V0_1;

    /**
     * Base model "mistral.mistral-large-2402-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier MISTRAL_LARGE_V0_1;

    /**
     * Base model "mistral.mistral-7b-instruct-v0:2".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier MISTRAL_MISTRAL_7_B_INSTRUCT_V0_2;

    /**
     * Base model "mistral.mixtral-8x7b-instruct-v0:1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier MISTRAL_MIXTRAL_8_X7_B_INSTRUCT_V0_1;

    /**
     * Base model "mistral.mistral-small-2402-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier MISTRAL_SMALL_V0_1;

    /**
     * Base model "stability.sd3-5-large-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_SD3_5_LARGE_V1_0;

    /**
     * Base model "stability.sd3-large-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_SD3_LARGE_V1_0;

    /**
     * (deprecated) Base model "stability.stable-diffusion-xl".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_STABLE_DIFFUSION_XL;

    /**
     * (deprecated) Base model "stability.stable-diffusion-xl-v0".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_STABLE_DIFFUSION_XL_V0;

    /**
     * (deprecated) Base model "stability.stable-diffusion-xl-v1".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_STABLE_DIFFUSION_XL_V1;

    /**
     * (deprecated) Base model "stability.stable-diffusion-xl-v1:0".
     * <p>
     * @deprecated use latest version of the model
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_STABLE_DIFFUSION_XL_V1_0;

    /**
     * Base model "stability.stable-image-core-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_STABLE_IMAGE_CORE_V1_0;

    /**
     * Base model "stability.stable-image-core-v1:1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_STABLE_IMAGE_CORE_V1_1;

    /**
     * Base model "stability.stable-image-ultra-v1:0".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_STABLE_IMAGE_ULTRA_V1_0;

    /**
     * Base model "stability.stable-image-ultra-v1:1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.bedrock.FoundationModelIdentifier STABILITY_STABLE_IMAGE_ULTRA_V1_1;

    /**
     * the model identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getModelId() {
        return software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
