package software.amazon.awscdk.services.billingconductor;

/**
 * Properties for defining a <code>CfnCustomLineItem</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.billingconductor.*;
 * CfnCustomLineItemProps cfnCustomLineItemProps = CfnCustomLineItemProps.builder()
 *         .billingGroupArn("billingGroupArn")
 *         .name("name")
 *         // the properties below are optional
 *         .accountId("accountId")
 *         .billingPeriodRange(BillingPeriodRangeProperty.builder()
 *                 .exclusiveEndBillingPeriod("exclusiveEndBillingPeriod")
 *                 .inclusiveStartBillingPeriod("inclusiveStartBillingPeriod")
 *                 .build())
 *         .customLineItemChargeDetails(CustomLineItemChargeDetailsProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .flat(CustomLineItemFlatChargeDetailsProperty.builder()
 *                         .chargeValue(123)
 *                         .build())
 *                 .lineItemFilters(List.of(LineItemFilterProperty.builder()
 *                         .attribute("attribute")
 *                         .matchOption("matchOption")
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .percentage(CustomLineItemPercentageChargeDetailsProperty.builder()
 *                         .percentageValue(123)
 *                         // the properties below are optional
 *                         .childAssociatedResources(List.of("childAssociatedResources"))
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:24.412Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_billingconductor.CfnCustomLineItemProps")
@software.amazon.jsii.Jsii.Proxy(CfnCustomLineItemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCustomLineItemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-billinggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-billinggrouparn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBillingGroupArn();

    /**
     * The custom line item's name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The AWS account in which this custom line item will be applied to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-accountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-accountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccountId() {
        return null;
    }

    /**
     * A time range for which the custom line item is effective.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-billingperiodrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-billingperiodrange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBillingPeriodRange() {
        return null;
    }

    /**
     * The charge details of a custom line item.
     * <p>
     * It should contain only one of <code>Flat</code> or <code>Percentage</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-customlineitemchargedetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-customlineitemchargedetails</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomLineItemChargeDetails() {
        return null;
    }

    /**
     * The custom line item's description.
     * <p>
     * This is shown on the Bills page in association with the charge value.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A map that contains tag keys and tag values that are attached to a custom line item.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-billingconductor-customlineitem.html#cfn-billingconductor-customlineitem-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCustomLineItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCustomLineItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCustomLineItemProps> {
        java.lang.String billingGroupArn;
        java.lang.String name;
        java.lang.String accountId;
        java.lang.Object billingPeriodRange;
        java.lang.Object customLineItemChargeDetails;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getBillingGroupArn}
         * @param billingGroupArn The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingGroupArn(java.lang.String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getName}
         * @param name The custom line item's name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getAccountId}
         * @param accountId The AWS account in which this custom line item will be applied to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountId(java.lang.String accountId) {
            this.accountId = accountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getBillingPeriodRange}
         * @param billingPeriodRange A time range for which the custom line item is effective.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingPeriodRange(software.amazon.awscdk.IResolvable billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getBillingPeriodRange}
         * @param billingPeriodRange A time range for which the custom line item is effective.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingPeriodRange(software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.BillingPeriodRangeProperty billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getCustomLineItemChargeDetails}
         * @param customLineItemChargeDetails The charge details of a custom line item.
         *                                    It should contain only one of <code>Flat</code> or <code>Percentage</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customLineItemChargeDetails(software.amazon.awscdk.IResolvable customLineItemChargeDetails) {
            this.customLineItemChargeDetails = customLineItemChargeDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getCustomLineItemChargeDetails}
         * @param customLineItemChargeDetails The charge details of a custom line item.
         *                                    It should contain only one of <code>Flat</code> or <code>Percentage</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customLineItemChargeDetails(software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.CustomLineItemChargeDetailsProperty customLineItemChargeDetails) {
            this.customLineItemChargeDetails = customLineItemChargeDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getDescription}
         * @param description The custom line item's description.
         *                    This is shown on the Bills page in association with the charge value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getTags}
         * @param tags A map that contains tag keys and tag values that are attached to a custom line item.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCustomLineItemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCustomLineItemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCustomLineItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCustomLineItemProps {
        private final java.lang.String billingGroupArn;
        private final java.lang.String name;
        private final java.lang.String accountId;
        private final java.lang.Object billingPeriodRange;
        private final java.lang.Object customLineItemChargeDetails;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.billingGroupArn = software.amazon.jsii.Kernel.get(this, "billingGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.billingPeriodRange = software.amazon.jsii.Kernel.get(this, "billingPeriodRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customLineItemChargeDetails = software.amazon.jsii.Kernel.get(this, "customLineItemChargeDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.billingGroupArn = java.util.Objects.requireNonNull(builder.billingGroupArn, "billingGroupArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.accountId = builder.accountId;
            this.billingPeriodRange = builder.billingPeriodRange;
            this.customLineItemChargeDetails = builder.customLineItemChargeDetails;
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getBillingGroupArn() {
            return this.billingGroupArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getAccountId() {
            return this.accountId;
        }

        @Override
        public final java.lang.Object getBillingPeriodRange() {
            return this.billingPeriodRange;
        }

        @Override
        public final java.lang.Object getCustomLineItemChargeDetails() {
            return this.customLineItemChargeDetails;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("billingGroupArn", om.valueToTree(this.getBillingGroupArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAccountId() != null) {
                data.set("accountId", om.valueToTree(this.getAccountId()));
            }
            if (this.getBillingPeriodRange() != null) {
                data.set("billingPeriodRange", om.valueToTree(this.getBillingPeriodRange()));
            }
            if (this.getCustomLineItemChargeDetails() != null) {
                data.set("customLineItemChargeDetails", om.valueToTree(this.getCustomLineItemChargeDetails()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_billingconductor.CfnCustomLineItemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCustomLineItemProps.Jsii$Proxy that = (CfnCustomLineItemProps.Jsii$Proxy) o;

            if (!billingGroupArn.equals(that.billingGroupArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) return false;
            if (this.billingPeriodRange != null ? !this.billingPeriodRange.equals(that.billingPeriodRange) : that.billingPeriodRange != null) return false;
            if (this.customLineItemChargeDetails != null ? !this.customLineItemChargeDetails.equals(that.customLineItemChargeDetails) : that.customLineItemChargeDetails != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.billingGroupArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
            result = 31 * result + (this.billingPeriodRange != null ? this.billingPeriodRange.hashCode() : 0);
            result = 31 * result + (this.customLineItemChargeDetails != null ? this.customLineItemChargeDetails.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
