package software.amazon.awscdk.services.cleanrooms;

/**
 * Creates a membership for a specific collaboration identifier and joins the collaboration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnMembership cfnMembership = CfnMembership.Builder.create(this, "MyCfnMembership")
 *         .collaborationIdentifier("collaborationIdentifier")
 *         .queryLogStatus("queryLogStatus")
 *         // the properties below are optional
 *         .defaultResultConfiguration(MembershipProtectedQueryResultConfigurationProperty.builder()
 *                 .outputConfiguration(MembershipProtectedQueryOutputConfigurationProperty.builder()
 *                         .s3(ProtectedQueryS3OutputConfigurationProperty.builder()
 *                                 .bucket("bucket")
 *                                 .resultFormat("resultFormat")
 *                                 // the properties below are optional
 *                                 .keyPrefix("keyPrefix")
 *                                 .singleFileOutput(false)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .roleArn("roleArn")
 *                 .build())
 *         .paymentConfiguration(MembershipPaymentConfigurationProperty.builder()
 *                 .queryCompute(MembershipQueryComputePaymentConfigProperty.builder()
 *                         .isResponsible(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .machineLearning(MembershipMLPaymentConfigProperty.builder()
 *                         .modelInference(MembershipModelInferencePaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         .modelTraining(MembershipModelTrainingPaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:24.552Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnMembership")
public class CfnMembership extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnMembership(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMembership(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cleanrooms.CfnMembership.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMembership(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cleanrooms.CfnMembershipProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the specified membership.
     * <p>
     * Example: <code>arn:aws:cleanrooms:us-east-1:111122223333:membership/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the Amazon Resource Name (ARN) of the specified collaboration.
     * <p>
     * Example: <code>arn:aws:cleanrooms:us-east-1:111122223333:collaboration/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCollaborationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCollaborationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the unique identifier of the specified collaboration creator account.
     * <p>
     * Example: <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCollaborationCreatorAccountId() {
        return software.amazon.jsii.Kernel.get(this, "attrCollaborationCreatorAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the unique identifier of the specified membership.
     * <p>
     * Example: <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE22222</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMembershipIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrMembershipIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The unique ID for the associated collaboration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCollaborationIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "collaborationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID for the associated collaboration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCollaborationIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "collaborationIdentifier", java.util.Objects.requireNonNull(value, "collaborationIdentifier is required"));
    }

    /**
     * An indicator as to whether query logging has been enabled or disabled for the membership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getQueryLogStatus() {
        return software.amazon.jsii.Kernel.get(this, "queryLogStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An indicator as to whether query logging has been enabled or disabled for the membership.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueryLogStatus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "queryLogStatus", java.util.Objects.requireNonNull(value, "queryLogStatus is required"));
    }

    /**
     * The default protected query result configuration as specified by the member who can receive results.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultResultConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "defaultResultConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The default protected query result configuration as specified by the member who can receive results.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultResultConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultResultConfiguration", value);
    }

    /**
     * The default protected query result configuration as specified by the member who can receive results.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultResultConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipProtectedQueryResultConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultResultConfiguration", value);
    }

    /**
     * The payment responsibilities accepted by the collaboration member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPaymentConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "paymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The payment responsibilities accepted by the collaboration member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPaymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "paymentConfiguration", value);
    }

    /**
     * The payment responsibilities accepted by the collaboration member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPaymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipPaymentConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "paymentConfiguration", value);
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * An object representing the collaboration member's machine learning payment responsibilities set by the collaboration creator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * MembershipMLPaymentConfigProperty membershipMLPaymentConfigProperty = MembershipMLPaymentConfigProperty.builder()
     *         .modelInference(MembershipModelInferencePaymentConfigProperty.builder()
     *                 .isResponsible(false)
     *                 .build())
     *         .modelTraining(MembershipModelTrainingPaymentConfigProperty.builder()
     *                 .isResponsible(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmlpaymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmlpaymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipMLPaymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MembershipMLPaymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MembershipMLPaymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The payment responsibilities accepted by the member for model inference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmlpaymentconfig.html#cfn-cleanrooms-membership-membershipmlpaymentconfig-modelinference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmlpaymentconfig.html#cfn-cleanrooms-membership-membershipmlpaymentconfig-modelinference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModelInference() {
            return null;
        }

        /**
         * The payment responsibilities accepted by the member for model training.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmlpaymentconfig.html#cfn-cleanrooms-membership-membershipmlpaymentconfig-modeltraining">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmlpaymentconfig.html#cfn-cleanrooms-membership-membershipmlpaymentconfig-modeltraining</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModelTraining() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MembershipMLPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MembershipMLPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MembershipMLPaymentConfigProperty> {
            java.lang.Object modelInference;
            java.lang.Object modelTraining;

            /**
             * Sets the value of {@link MembershipMLPaymentConfigProperty#getModelInference}
             * @param modelInference The payment responsibilities accepted by the member for model inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelInference(software.amazon.awscdk.IResolvable modelInference) {
                this.modelInference = modelInference;
                return this;
            }

            /**
             * Sets the value of {@link MembershipMLPaymentConfigProperty#getModelInference}
             * @param modelInference The payment responsibilities accepted by the member for model inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelInference(software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipModelInferencePaymentConfigProperty modelInference) {
                this.modelInference = modelInference;
                return this;
            }

            /**
             * Sets the value of {@link MembershipMLPaymentConfigProperty#getModelTraining}
             * @param modelTraining The payment responsibilities accepted by the member for model training.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelTraining(software.amazon.awscdk.IResolvable modelTraining) {
                this.modelTraining = modelTraining;
                return this;
            }

            /**
             * Sets the value of {@link MembershipMLPaymentConfigProperty#getModelTraining}
             * @param modelTraining The payment responsibilities accepted by the member for model training.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelTraining(software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipModelTrainingPaymentConfigProperty modelTraining) {
                this.modelTraining = modelTraining;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MembershipMLPaymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MembershipMLPaymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MembershipMLPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MembershipMLPaymentConfigProperty {
            private final java.lang.Object modelInference;
            private final java.lang.Object modelTraining;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modelInference = software.amazon.jsii.Kernel.get(this, "modelInference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelTraining = software.amazon.jsii.Kernel.get(this, "modelTraining", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modelInference = builder.modelInference;
                this.modelTraining = builder.modelTraining;
            }

            @Override
            public final java.lang.Object getModelInference() {
                return this.modelInference;
            }

            @Override
            public final java.lang.Object getModelTraining() {
                return this.modelTraining;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getModelInference() != null) {
                    data.set("modelInference", om.valueToTree(this.getModelInference()));
                }
                if (this.getModelTraining() != null) {
                    data.set("modelTraining", om.valueToTree(this.getModelTraining()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipMLPaymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MembershipMLPaymentConfigProperty.Jsii$Proxy that = (MembershipMLPaymentConfigProperty.Jsii$Proxy) o;

                if (this.modelInference != null ? !this.modelInference.equals(that.modelInference) : that.modelInference != null) return false;
                return this.modelTraining != null ? this.modelTraining.equals(that.modelTraining) : that.modelTraining == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modelInference != null ? this.modelInference.hashCode() : 0;
                result = 31 * result + (this.modelTraining != null ? this.modelTraining.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the collaboration member's model inference payment responsibilities set by the collaboration creator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * MembershipModelInferencePaymentConfigProperty membershipModelInferencePaymentConfigProperty = MembershipModelInferencePaymentConfigProperty.builder()
     *         .isResponsible(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmodelinferencepaymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmodelinferencepaymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipModelInferencePaymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MembershipModelInferencePaymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MembershipModelInferencePaymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the collaboration member has accepted to pay for model inference costs ( <code>TRUE</code> ) or has not accepted to pay for model inference costs ( <code>FALSE</code> ).
         * <p>
         * If the collaboration creator has not specified anyone to pay for model inference costs, then the member who can query is the default payer.
         * <p>
         * An error message is returned for the following reasons:
         * <p>
         * <ul>
         * <li>If you set the value to <code>FALSE</code> but you are responsible to pay for model inference costs.</li>
         * <li>If you set the value to <code>TRUE</code> but you are not responsible to pay for model inference costs.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmodelinferencepaymentconfig.html#cfn-cleanrooms-membership-membershipmodelinferencepaymentconfig-isresponsible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmodelinferencepaymentconfig.html#cfn-cleanrooms-membership-membershipmodelinferencepaymentconfig-isresponsible</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsResponsible();

        /**
         * @return a {@link Builder} of {@link MembershipModelInferencePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MembershipModelInferencePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MembershipModelInferencePaymentConfigProperty> {
            java.lang.Object isResponsible;

            /**
             * Sets the value of {@link MembershipModelInferencePaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration member has accepted to pay for model inference costs ( <code>TRUE</code> ) or has not accepted to pay for model inference costs ( <code>FALSE</code> ). This parameter is required.
             *                      If the collaboration creator has not specified anyone to pay for model inference costs, then the member who can query is the default payer.
             *                      <p>
             *                      An error message is returned for the following reasons:
             *                      <p>
             *                      <ul>
             *                      <li>If you set the value to <code>FALSE</code> but you are responsible to pay for model inference costs.</li>
             *                      <li>If you set the value to <code>TRUE</code> but you are not responsible to pay for model inference costs.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(java.lang.Boolean isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Sets the value of {@link MembershipModelInferencePaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration member has accepted to pay for model inference costs ( <code>TRUE</code> ) or has not accepted to pay for model inference costs ( <code>FALSE</code> ). This parameter is required.
             *                      If the collaboration creator has not specified anyone to pay for model inference costs, then the member who can query is the default payer.
             *                      <p>
             *                      An error message is returned for the following reasons:
             *                      <p>
             *                      <ul>
             *                      <li>If you set the value to <code>FALSE</code> but you are responsible to pay for model inference costs.</li>
             *                      <li>If you set the value to <code>TRUE</code> but you are not responsible to pay for model inference costs.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(software.amazon.awscdk.IResolvable isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MembershipModelInferencePaymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MembershipModelInferencePaymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MembershipModelInferencePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MembershipModelInferencePaymentConfigProperty {
            private final java.lang.Object isResponsible;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isResponsible = software.amazon.jsii.Kernel.get(this, "isResponsible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isResponsible = java.util.Objects.requireNonNull(builder.isResponsible, "isResponsible is required");
            }

            @Override
            public final java.lang.Object getIsResponsible() {
                return this.isResponsible;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("isResponsible", om.valueToTree(this.getIsResponsible()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipModelInferencePaymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MembershipModelInferencePaymentConfigProperty.Jsii$Proxy that = (MembershipModelInferencePaymentConfigProperty.Jsii$Proxy) o;

                return this.isResponsible.equals(that.isResponsible);
            }

            @Override
            public final int hashCode() {
                int result = this.isResponsible.hashCode();
                return result;
            }
        }
    }
    /**
     * An object representing the collaboration member's model training payment responsibilities set by the collaboration creator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * MembershipModelTrainingPaymentConfigProperty membershipModelTrainingPaymentConfigProperty = MembershipModelTrainingPaymentConfigProperty.builder()
     *         .isResponsible(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmodeltrainingpaymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmodeltrainingpaymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipModelTrainingPaymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MembershipModelTrainingPaymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MembershipModelTrainingPaymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the collaboration member has accepted to pay for model training costs ( <code>TRUE</code> ) or has not accepted to pay for model training costs ( <code>FALSE</code> ).
         * <p>
         * If the collaboration creator has not specified anyone to pay for model training costs, then the member who can query is the default payer.
         * <p>
         * An error message is returned for the following reasons:
         * <p>
         * <ul>
         * <li>If you set the value to <code>FALSE</code> but you are responsible to pay for model training costs.</li>
         * <li>If you set the value to <code>TRUE</code> but you are not responsible to pay for model training costs.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmodeltrainingpaymentconfig.html#cfn-cleanrooms-membership-membershipmodeltrainingpaymentconfig-isresponsible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipmodeltrainingpaymentconfig.html#cfn-cleanrooms-membership-membershipmodeltrainingpaymentconfig-isresponsible</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsResponsible();

        /**
         * @return a {@link Builder} of {@link MembershipModelTrainingPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MembershipModelTrainingPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MembershipModelTrainingPaymentConfigProperty> {
            java.lang.Object isResponsible;

            /**
             * Sets the value of {@link MembershipModelTrainingPaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration member has accepted to pay for model training costs ( <code>TRUE</code> ) or has not accepted to pay for model training costs ( <code>FALSE</code> ). This parameter is required.
             *                      If the collaboration creator has not specified anyone to pay for model training costs, then the member who can query is the default payer.
             *                      <p>
             *                      An error message is returned for the following reasons:
             *                      <p>
             *                      <ul>
             *                      <li>If you set the value to <code>FALSE</code> but you are responsible to pay for model training costs.</li>
             *                      <li>If you set the value to <code>TRUE</code> but you are not responsible to pay for model training costs.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(java.lang.Boolean isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Sets the value of {@link MembershipModelTrainingPaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration member has accepted to pay for model training costs ( <code>TRUE</code> ) or has not accepted to pay for model training costs ( <code>FALSE</code> ). This parameter is required.
             *                      If the collaboration creator has not specified anyone to pay for model training costs, then the member who can query is the default payer.
             *                      <p>
             *                      An error message is returned for the following reasons:
             *                      <p>
             *                      <ul>
             *                      <li>If you set the value to <code>FALSE</code> but you are responsible to pay for model training costs.</li>
             *                      <li>If you set the value to <code>TRUE</code> but you are not responsible to pay for model training costs.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(software.amazon.awscdk.IResolvable isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MembershipModelTrainingPaymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MembershipModelTrainingPaymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MembershipModelTrainingPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MembershipModelTrainingPaymentConfigProperty {
            private final java.lang.Object isResponsible;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isResponsible = software.amazon.jsii.Kernel.get(this, "isResponsible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isResponsible = java.util.Objects.requireNonNull(builder.isResponsible, "isResponsible is required");
            }

            @Override
            public final java.lang.Object getIsResponsible() {
                return this.isResponsible;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("isResponsible", om.valueToTree(this.getIsResponsible()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipModelTrainingPaymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MembershipModelTrainingPaymentConfigProperty.Jsii$Proxy that = (MembershipModelTrainingPaymentConfigProperty.Jsii$Proxy) o;

                return this.isResponsible.equals(that.isResponsible);
            }

            @Override
            public final int hashCode() {
                int result = this.isResponsible.hashCode();
                return result;
            }
        }
    }
    /**
     * An object representing the payment responsibilities accepted by the collaboration member.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * MembershipPaymentConfigurationProperty membershipPaymentConfigurationProperty = MembershipPaymentConfigurationProperty.builder()
     *         .queryCompute(MembershipQueryComputePaymentConfigProperty.builder()
     *                 .isResponsible(false)
     *                 .build())
     *         // the properties below are optional
     *         .machineLearning(MembershipMLPaymentConfigProperty.builder()
     *                 .modelInference(MembershipModelInferencePaymentConfigProperty.builder()
     *                         .isResponsible(false)
     *                         .build())
     *                 .modelTraining(MembershipModelTrainingPaymentConfigProperty.builder()
     *                         .isResponsible(false)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershippaymentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershippaymentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipPaymentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MembershipPaymentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MembershipPaymentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The payment responsibilities accepted by the collaboration member for query compute costs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershippaymentconfiguration.html#cfn-cleanrooms-membership-membershippaymentconfiguration-querycompute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershippaymentconfiguration.html#cfn-cleanrooms-membership-membershippaymentconfiguration-querycompute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQueryCompute();

        /**
         * The payment responsibilities accepted by the collaboration member for machine learning costs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershippaymentconfiguration.html#cfn-cleanrooms-membership-membershippaymentconfiguration-machinelearning">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershippaymentconfiguration.html#cfn-cleanrooms-membership-membershippaymentconfiguration-machinelearning</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMachineLearning() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MembershipPaymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MembershipPaymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MembershipPaymentConfigurationProperty> {
            java.lang.Object queryCompute;
            java.lang.Object machineLearning;

            /**
             * Sets the value of {@link MembershipPaymentConfigurationProperty#getQueryCompute}
             * @param queryCompute The payment responsibilities accepted by the collaboration member for query compute costs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryCompute(software.amazon.awscdk.IResolvable queryCompute) {
                this.queryCompute = queryCompute;
                return this;
            }

            /**
             * Sets the value of {@link MembershipPaymentConfigurationProperty#getQueryCompute}
             * @param queryCompute The payment responsibilities accepted by the collaboration member for query compute costs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryCompute(software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipQueryComputePaymentConfigProperty queryCompute) {
                this.queryCompute = queryCompute;
                return this;
            }

            /**
             * Sets the value of {@link MembershipPaymentConfigurationProperty#getMachineLearning}
             * @param machineLearning The payment responsibilities accepted by the collaboration member for machine learning costs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineLearning(software.amazon.awscdk.IResolvable machineLearning) {
                this.machineLearning = machineLearning;
                return this;
            }

            /**
             * Sets the value of {@link MembershipPaymentConfigurationProperty#getMachineLearning}
             * @param machineLearning The payment responsibilities accepted by the collaboration member for machine learning costs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineLearning(software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipMLPaymentConfigProperty machineLearning) {
                this.machineLearning = machineLearning;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MembershipPaymentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MembershipPaymentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MembershipPaymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MembershipPaymentConfigurationProperty {
            private final java.lang.Object queryCompute;
            private final java.lang.Object machineLearning;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryCompute = software.amazon.jsii.Kernel.get(this, "queryCompute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.machineLearning = software.amazon.jsii.Kernel.get(this, "machineLearning", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryCompute = java.util.Objects.requireNonNull(builder.queryCompute, "queryCompute is required");
                this.machineLearning = builder.machineLearning;
            }

            @Override
            public final java.lang.Object getQueryCompute() {
                return this.queryCompute;
            }

            @Override
            public final java.lang.Object getMachineLearning() {
                return this.machineLearning;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryCompute", om.valueToTree(this.getQueryCompute()));
                if (this.getMachineLearning() != null) {
                    data.set("machineLearning", om.valueToTree(this.getMachineLearning()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipPaymentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MembershipPaymentConfigurationProperty.Jsii$Proxy that = (MembershipPaymentConfigurationProperty.Jsii$Proxy) o;

                if (!queryCompute.equals(that.queryCompute)) return false;
                return this.machineLearning != null ? this.machineLearning.equals(that.machineLearning) : that.machineLearning == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryCompute.hashCode();
                result = 31 * result + (this.machineLearning != null ? this.machineLearning.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for protected query results.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * MembershipProtectedQueryOutputConfigurationProperty membershipProtectedQueryOutputConfigurationProperty = MembershipProtectedQueryOutputConfigurationProperty.builder()
     *         .s3(ProtectedQueryS3OutputConfigurationProperty.builder()
     *                 .bucket("bucket")
     *                 .resultFormat("resultFormat")
     *                 // the properties below are optional
     *                 .keyPrefix("keyPrefix")
     *                 .singleFileOutput(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipprotectedqueryoutputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipprotectedqueryoutputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipProtectedQueryOutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MembershipProtectedQueryOutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MembershipProtectedQueryOutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Required configuration for a protected query with an <code>s3</code> output type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipprotectedqueryoutputconfiguration.html#cfn-cleanrooms-membership-membershipprotectedqueryoutputconfiguration-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipprotectedqueryoutputconfiguration.html#cfn-cleanrooms-membership-membershipprotectedqueryoutputconfiguration-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3();

        /**
         * @return a {@link Builder} of {@link MembershipProtectedQueryOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MembershipProtectedQueryOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MembershipProtectedQueryOutputConfigurationProperty> {
            java.lang.Object s3;

            /**
             * Sets the value of {@link MembershipProtectedQueryOutputConfigurationProperty#getS3}
             * @param s3 Required configuration for a protected query with an <code>s3</code> output type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link MembershipProtectedQueryOutputConfigurationProperty#getS3}
             * @param s3 Required configuration for a protected query with an <code>s3</code> output type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.cleanrooms.CfnMembership.ProtectedQueryS3OutputConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MembershipProtectedQueryOutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MembershipProtectedQueryOutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MembershipProtectedQueryOutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MembershipProtectedQueryOutputConfigurationProperty {
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3 = java.util.Objects.requireNonNull(builder.s3, "s3 is required");
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3", om.valueToTree(this.getS3()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipProtectedQueryOutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MembershipProtectedQueryOutputConfigurationProperty.Jsii$Proxy that = (MembershipProtectedQueryOutputConfigurationProperty.Jsii$Proxy) o;

                return this.s3.equals(that.s3);
            }

            @Override
            public final int hashCode() {
                int result = this.s3.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for protected query results.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * MembershipProtectedQueryResultConfigurationProperty membershipProtectedQueryResultConfigurationProperty = MembershipProtectedQueryResultConfigurationProperty.builder()
     *         .outputConfiguration(MembershipProtectedQueryOutputConfigurationProperty.builder()
     *                 .s3(ProtectedQueryS3OutputConfigurationProperty.builder()
     *                         .bucket("bucket")
     *                         .resultFormat("resultFormat")
     *                         // the properties below are optional
     *                         .keyPrefix("keyPrefix")
     *                         .singleFileOutput(false)
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipprotectedqueryresultconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipprotectedqueryresultconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipProtectedQueryResultConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MembershipProtectedQueryResultConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MembershipProtectedQueryResultConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration for protected query results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipprotectedqueryresultconfiguration.html#cfn-cleanrooms-membership-membershipprotectedqueryresultconfiguration-outputconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipprotectedqueryresultconfiguration.html#cfn-cleanrooms-membership-membershipprotectedqueryresultconfiguration-outputconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutputConfiguration();

        /**
         * The unique ARN for an IAM role that is used by AWS Clean Rooms to write protected query results to the result location, given by the member who can receive results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipprotectedqueryresultconfiguration.html#cfn-cleanrooms-membership-membershipprotectedqueryresultconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipprotectedqueryresultconfiguration.html#cfn-cleanrooms-membership-membershipprotectedqueryresultconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MembershipProtectedQueryResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MembershipProtectedQueryResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MembershipProtectedQueryResultConfigurationProperty> {
            java.lang.Object outputConfiguration;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link MembershipProtectedQueryResultConfigurationProperty#getOutputConfiguration}
             * @param outputConfiguration Configuration for protected query results. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputConfiguration(software.amazon.awscdk.IResolvable outputConfiguration) {
                this.outputConfiguration = outputConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MembershipProtectedQueryResultConfigurationProperty#getOutputConfiguration}
             * @param outputConfiguration Configuration for protected query results. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputConfiguration(software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipProtectedQueryOutputConfigurationProperty outputConfiguration) {
                this.outputConfiguration = outputConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MembershipProtectedQueryResultConfigurationProperty#getRoleArn}
             * @param roleArn The unique ARN for an IAM role that is used by AWS Clean Rooms to write protected query results to the result location, given by the member who can receive results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MembershipProtectedQueryResultConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MembershipProtectedQueryResultConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MembershipProtectedQueryResultConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MembershipProtectedQueryResultConfigurationProperty {
            private final java.lang.Object outputConfiguration;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputConfiguration = software.amazon.jsii.Kernel.get(this, "outputConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputConfiguration = java.util.Objects.requireNonNull(builder.outputConfiguration, "outputConfiguration is required");
                this.roleArn = builder.roleArn;
            }

            @Override
            public final java.lang.Object getOutputConfiguration() {
                return this.outputConfiguration;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("outputConfiguration", om.valueToTree(this.getOutputConfiguration()));
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipProtectedQueryResultConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MembershipProtectedQueryResultConfigurationProperty.Jsii$Proxy that = (MembershipProtectedQueryResultConfigurationProperty.Jsii$Proxy) o;

                if (!outputConfiguration.equals(that.outputConfiguration)) return false;
                return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputConfiguration.hashCode();
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the payment responsibilities accepted by the collaboration member for query compute costs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * MembershipQueryComputePaymentConfigProperty membershipQueryComputePaymentConfigProperty = MembershipQueryComputePaymentConfigProperty.builder()
     *         .isResponsible(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipquerycomputepaymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipquerycomputepaymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipQueryComputePaymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MembershipQueryComputePaymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MembershipQueryComputePaymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the collaboration member has accepted to pay for query compute costs ( <code>TRUE</code> ) or has not accepted to pay for query compute costs ( <code>FALSE</code> ).
         * <p>
         * If the collaboration creator has not specified anyone to pay for query compute costs, then the member who can query is the default payer.
         * <p>
         * An error message is returned for the following reasons:
         * <p>
         * <ul>
         * <li>If you set the value to <code>FALSE</code> but you are responsible to pay for query compute costs.</li>
         * <li>If you set the value to <code>TRUE</code> but you are not responsible to pay for query compute costs.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipquerycomputepaymentconfig.html#cfn-cleanrooms-membership-membershipquerycomputepaymentconfig-isresponsible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-membershipquerycomputepaymentconfig.html#cfn-cleanrooms-membership-membershipquerycomputepaymentconfig-isresponsible</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsResponsible();

        /**
         * @return a {@link Builder} of {@link MembershipQueryComputePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MembershipQueryComputePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MembershipQueryComputePaymentConfigProperty> {
            java.lang.Object isResponsible;

            /**
             * Sets the value of {@link MembershipQueryComputePaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration member has accepted to pay for query compute costs ( <code>TRUE</code> ) or has not accepted to pay for query compute costs ( <code>FALSE</code> ). This parameter is required.
             *                      If the collaboration creator has not specified anyone to pay for query compute costs, then the member who can query is the default payer.
             *                      <p>
             *                      An error message is returned for the following reasons:
             *                      <p>
             *                      <ul>
             *                      <li>If you set the value to <code>FALSE</code> but you are responsible to pay for query compute costs.</li>
             *                      <li>If you set the value to <code>TRUE</code> but you are not responsible to pay for query compute costs.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(java.lang.Boolean isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Sets the value of {@link MembershipQueryComputePaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration member has accepted to pay for query compute costs ( <code>TRUE</code> ) or has not accepted to pay for query compute costs ( <code>FALSE</code> ). This parameter is required.
             *                      If the collaboration creator has not specified anyone to pay for query compute costs, then the member who can query is the default payer.
             *                      <p>
             *                      An error message is returned for the following reasons:
             *                      <p>
             *                      <ul>
             *                      <li>If you set the value to <code>FALSE</code> but you are responsible to pay for query compute costs.</li>
             *                      <li>If you set the value to <code>TRUE</code> but you are not responsible to pay for query compute costs.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(software.amazon.awscdk.IResolvable isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MembershipQueryComputePaymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MembershipQueryComputePaymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MembershipQueryComputePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MembershipQueryComputePaymentConfigProperty {
            private final java.lang.Object isResponsible;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isResponsible = software.amazon.jsii.Kernel.get(this, "isResponsible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isResponsible = java.util.Objects.requireNonNull(builder.isResponsible, "isResponsible is required");
            }

            @Override
            public final java.lang.Object getIsResponsible() {
                return this.isResponsible;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("isResponsible", om.valueToTree(this.getIsResponsible()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnMembership.MembershipQueryComputePaymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MembershipQueryComputePaymentConfigProperty.Jsii$Proxy that = (MembershipQueryComputePaymentConfigProperty.Jsii$Proxy) o;

                return this.isResponsible.equals(that.isResponsible);
            }

            @Override
            public final int hashCode() {
                int result = this.isResponsible.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains the configuration to write the query results to S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ProtectedQueryS3OutputConfigurationProperty protectedQueryS3OutputConfigurationProperty = ProtectedQueryS3OutputConfigurationProperty.builder()
     *         .bucket("bucket")
     *         .resultFormat("resultFormat")
     *         // the properties below are optional
     *         .keyPrefix("keyPrefix")
     *         .singleFileOutput(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-protectedquerys3outputconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-protectedquerys3outputconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnMembership.ProtectedQueryS3OutputConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProtectedQueryS3OutputConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProtectedQueryS3OutputConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket to unload the protected query results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-protectedquerys3outputconfiguration.html#cfn-cleanrooms-membership-protectedquerys3outputconfiguration-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-protectedquerys3outputconfiguration.html#cfn-cleanrooms-membership-protectedquerys3outputconfiguration-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * Intended file format of the result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-protectedquerys3outputconfiguration.html#cfn-cleanrooms-membership-protectedquerys3outputconfiguration-resultformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-protectedquerys3outputconfiguration.html#cfn-cleanrooms-membership-protectedquerys3outputconfiguration-resultformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResultFormat();

        /**
         * The S3 prefix to unload the protected query results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-protectedquerys3outputconfiguration.html#cfn-cleanrooms-membership-protectedquerys3outputconfiguration-keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-protectedquerys3outputconfiguration.html#cfn-cleanrooms-membership-protectedquerys3outputconfiguration-keyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefix() {
            return null;
        }

        /**
         * Indicates whether files should be output as a single file ( <code>TRUE</code> ) or output as multiple files ( <code>FALSE</code> ).
         * <p>
         * This parameter is only supported for analyses with the Spark analytics engine.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-protectedquerys3outputconfiguration.html#cfn-cleanrooms-membership-protectedquerys3outputconfiguration-singlefileoutput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-membership-protectedquerys3outputconfiguration.html#cfn-cleanrooms-membership-protectedquerys3outputconfiguration-singlefileoutput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleFileOutput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProtectedQueryS3OutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProtectedQueryS3OutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProtectedQueryS3OutputConfigurationProperty> {
            java.lang.String bucket;
            java.lang.String resultFormat;
            java.lang.String keyPrefix;
            java.lang.Object singleFileOutput;

            /**
             * Sets the value of {@link ProtectedQueryS3OutputConfigurationProperty#getBucket}
             * @param bucket The S3 bucket to unload the protected query results. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link ProtectedQueryS3OutputConfigurationProperty#getResultFormat}
             * @param resultFormat Intended file format of the result. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resultFormat(java.lang.String resultFormat) {
                this.resultFormat = resultFormat;
                return this;
            }

            /**
             * Sets the value of {@link ProtectedQueryS3OutputConfigurationProperty#getKeyPrefix}
             * @param keyPrefix The S3 prefix to unload the protected query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyPrefix(java.lang.String keyPrefix) {
                this.keyPrefix = keyPrefix;
                return this;
            }

            /**
             * Sets the value of {@link ProtectedQueryS3OutputConfigurationProperty#getSingleFileOutput}
             * @param singleFileOutput Indicates whether files should be output as a single file ( <code>TRUE</code> ) or output as multiple files ( <code>FALSE</code> ).
             *                         This parameter is only supported for analyses with the Spark analytics engine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleFileOutput(java.lang.Boolean singleFileOutput) {
                this.singleFileOutput = singleFileOutput;
                return this;
            }

            /**
             * Sets the value of {@link ProtectedQueryS3OutputConfigurationProperty#getSingleFileOutput}
             * @param singleFileOutput Indicates whether files should be output as a single file ( <code>TRUE</code> ) or output as multiple files ( <code>FALSE</code> ).
             *                         This parameter is only supported for analyses with the Spark analytics engine.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleFileOutput(software.amazon.awscdk.IResolvable singleFileOutput) {
                this.singleFileOutput = singleFileOutput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProtectedQueryS3OutputConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProtectedQueryS3OutputConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProtectedQueryS3OutputConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProtectedQueryS3OutputConfigurationProperty {
            private final java.lang.String bucket;
            private final java.lang.String resultFormat;
            private final java.lang.String keyPrefix;
            private final java.lang.Object singleFileOutput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resultFormat = software.amazon.jsii.Kernel.get(this, "resultFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyPrefix = software.amazon.jsii.Kernel.get(this, "keyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.singleFileOutput = software.amazon.jsii.Kernel.get(this, "singleFileOutput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.resultFormat = java.util.Objects.requireNonNull(builder.resultFormat, "resultFormat is required");
                this.keyPrefix = builder.keyPrefix;
                this.singleFileOutput = builder.singleFileOutput;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getResultFormat() {
                return this.resultFormat;
            }

            @Override
            public final java.lang.String getKeyPrefix() {
                return this.keyPrefix;
            }

            @Override
            public final java.lang.Object getSingleFileOutput() {
                return this.singleFileOutput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("resultFormat", om.valueToTree(this.getResultFormat()));
                if (this.getKeyPrefix() != null) {
                    data.set("keyPrefix", om.valueToTree(this.getKeyPrefix()));
                }
                if (this.getSingleFileOutput() != null) {
                    data.set("singleFileOutput", om.valueToTree(this.getSingleFileOutput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnMembership.ProtectedQueryS3OutputConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProtectedQueryS3OutputConfigurationProperty.Jsii$Proxy that = (ProtectedQueryS3OutputConfigurationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!resultFormat.equals(that.resultFormat)) return false;
                if (this.keyPrefix != null ? !this.keyPrefix.equals(that.keyPrefix) : that.keyPrefix != null) return false;
                return this.singleFileOutput != null ? this.singleFileOutput.equals(that.singleFileOutput) : that.singleFileOutput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.resultFormat.hashCode());
                result = 31 * result + (this.keyPrefix != null ? this.keyPrefix.hashCode() : 0);
                result = 31 * result + (this.singleFileOutput != null ? this.singleFileOutput.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cleanrooms.CfnMembership}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cleanrooms.CfnMembership> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cleanrooms.CfnMembershipProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cleanrooms.CfnMembershipProps.Builder();
        }

        /**
         * The unique ID for the associated collaboration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-collaborationidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-collaborationidentifier</a>
         * @param collaborationIdentifier The unique ID for the associated collaboration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collaborationIdentifier(final java.lang.String collaborationIdentifier) {
            this.props.collaborationIdentifier(collaborationIdentifier);
            return this;
        }

        /**
         * An indicator as to whether query logging has been enabled or disabled for the membership.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-querylogstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-querylogstatus</a>
         * @param queryLogStatus An indicator as to whether query logging has been enabled or disabled for the membership. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogStatus(final java.lang.String queryLogStatus) {
            this.props.queryLogStatus(queryLogStatus);
            return this;
        }

        /**
         * The default protected query result configuration as specified by the member who can receive results.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-defaultresultconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-defaultresultconfiguration</a>
         * @param defaultResultConfiguration The default protected query result configuration as specified by the member who can receive results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultResultConfiguration(final software.amazon.awscdk.IResolvable defaultResultConfiguration) {
            this.props.defaultResultConfiguration(defaultResultConfiguration);
            return this;
        }
        /**
         * The default protected query result configuration as specified by the member who can receive results.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-defaultresultconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-defaultresultconfiguration</a>
         * @param defaultResultConfiguration The default protected query result configuration as specified by the member who can receive results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultResultConfiguration(final software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipProtectedQueryResultConfigurationProperty defaultResultConfiguration) {
            this.props.defaultResultConfiguration(defaultResultConfiguration);
            return this;
        }

        /**
         * The payment responsibilities accepted by the collaboration member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-paymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-paymentconfiguration</a>
         * @param paymentConfiguration The payment responsibilities accepted by the collaboration member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder paymentConfiguration(final software.amazon.awscdk.IResolvable paymentConfiguration) {
            this.props.paymentConfiguration(paymentConfiguration);
            return this;
        }
        /**
         * The payment responsibilities accepted by the collaboration member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-paymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-paymentconfiguration</a>
         * @param paymentConfiguration The payment responsibilities accepted by the collaboration member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder paymentConfiguration(final software.amazon.awscdk.services.cleanrooms.CfnMembership.MembershipPaymentConfigurationProperty paymentConfiguration) {
            this.props.paymentConfiguration(paymentConfiguration);
            return this;
        }

        /**
         * An optional label that you can assign to a resource when you create it.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-membership.html#cfn-cleanrooms-membership-tags</a>
         * @param tags An optional label that you can assign to a resource when you create it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cleanrooms.CfnMembership}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cleanrooms.CfnMembership build() {
            return new software.amazon.awscdk.services.cleanrooms.CfnMembership(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
