package software.amazon.awscdk.services.cloudfront;

/**
 * The level of permissions granted to the CloudFront Distribution when configuring OAC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket = new Bucket(this, "myBucket");
 * IOrigin s3Origin = S3BucketOrigin.withOriginAccessControl(myBucket, S3BucketOriginWithOACProps.builder()
 *         .originAccessLevels(List.of(AccessLevel.READ, AccessLevel.WRITE, AccessLevel.DELETE))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:24.668Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.AccessLevel")
public enum AccessLevel {
    /**
     * Grants read permissions to CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    READ,
    /**
     * Grants list permissions to CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LIST,
    /**
     * Grants write permission to CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WRITE,
    /**
     * Grants delete permission to CloudFront Distribution.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELETE,
}
